/*
 * Copyright 2007-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 */

package griffon.samples.swingpad

import com.bric.image.transition.Transition2D
import griffon.plugins.transitions.FadeTransition2D

import java.awt.Color

import com.bric.image.transition.spunk.*
import com.bric.image.transition.vanilla.*

/**
 * @author Andres Almiray
 */
class Transitions {
    static List transitions = [
            new BarsTransition2D(Transition2D.HORIZONTAL, true),
            new BarsTransition2D(Transition2D.HORIZONTAL, false),
            new BarsTransition2D(Transition2D.VERTICAL, true),
            new BarsTransition2D(Transition2D.VERTICAL, false),
            new BatTransition2D(Transition2D.IN),
            new BatTransition2D(Transition2D.OUT),
            new BlendTransition2D(),
            new BlindsTransition2D(Transition2D.LEFT),
            new BlindsTransition2D(Transition2D.RIGHT),
            new BlindsTransition2D(Transition2D.UP),
            new BlindsTransition2D(Transition2D.DOWN),
            new BoxTransition2D(Transition2D.IN),
            new BoxTransition2D(Transition2D.OUT),
            new CheckerboardTransition2D(Transition2D.LEFT),
            new CheckerboardTransition2D(Transition2D.RIGHT),
            new CheckerboardTransition2D(Transition2D.UP),
            new CheckerboardTransition2D(Transition2D.DOWN),
            new CircleTransition2D(Transition2D.IN),
            new CircleTransition2D(Transition2D.OUT),
            new CollapseTransition2D(),
            new CurtainTransition2D(),
            new DiamondsTransition2D(55),
            new DiamondsTransition2D(90),
            new DiamondsTransition2D(120),
            new DocumentaryTransition2D(Transition2D.LEFT),
            new DocumentaryTransition2D(Transition2D.RIGHT),
            new DocumentaryTransition2D(Transition2D.UP),
            new DocumentaryTransition2D(Transition2D.DOWN),
            new DotsTransition2D(),
            new DropTransition2D(),
            new FadeTransition2D(Color.BLACK),
            new FlurryTransition2D(Transition2D.IN),
            new FlurryTransition2D(Transition2D.OUT),
            new FunkyWipeTransition2D(true),
            new FunkyWipeTransition2D(false),
            new GooTransition2D(),
            new HalftoneTransition2D(Transition2D.IN),
            new HalftoneTransition2D(Transition2D.OUT),
            //new KaleidoscopeTransition2D(),
            new LevitateTransition2D(),
            new MeshShuffleTransition2D(),
            //new MicroscopeTransition2D(),
            //new MirageTransition2D(),
            new MotionBlendTransition2D(),
            //new RefractiveTransition2D(),
            new PivotTransition2D(Transition2D.TOP_LEFT, true),
            new PivotTransition2D(Transition2D.TOP_RIGHT, true),
            new PivotTransition2D(Transition2D.BOTTOM_LEFT, true),
            new PivotTransition2D(Transition2D.BOTTOM_RIGHT, true),
            new PivotTransition2D(Transition2D.TOP_LEFT, false),
            new PivotTransition2D(Transition2D.TOP_RIGHT, false),
            new PivotTransition2D(Transition2D.BOTTOM_LEFT, false),
            new PivotTransition2D(Transition2D.BOTTOM_RIGHT, false),
            new PushTransition2D(Transition2D.LEFT),
            new PushTransition2D(Transition2D.RIGHT),
            new PushTransition2D(Transition2D.UP),
            new PushTransition2D(Transition2D.DOWN),
            new RadialWipeTransition2D(Transition2D.CLOCKWISE),
            new RadialWipeTransition2D(Transition2D.COUNTER_CLOCKWISE),
            new RevealTransition2D(Transition2D.LEFT),
            new RevealTransition2D(Transition2D.RIGHT),
            new RevealTransition2D(Transition2D.UP),
            new RevealTransition2D(Transition2D.DOWN),
            new RotateTransition2D(Transition2D.IN),
            new RotateTransition2D(Transition2D.OUT),
            new ScaleTransition2D(Transition2D.IN),
            new ScaleTransition2D(Transition2D.OUT),
            new ScribbleTransition2D(false),
            new ScribbleTransition2D(true),
            new SlideTransition2D(Transition2D.LEFT),
            new SlideTransition2D(Transition2D.RIGHT),
            new SlideTransition2D(Transition2D.UP),
            new SlideTransition2D(Transition2D.DOWN),
            new SpiralTransition2D(false),
            new SpiralTransition2D(true),
            new SplitTransition2D(Transition2D.HORIZONTAL, false),
            new SplitTransition2D(Transition2D.VERTICAL, false),
            new SplitTransition2D(Transition2D.HORIZONTAL, true),
            new SplitTransition2D(Transition2D.VERTICAL, true),
            new SquareRainTransition2D(),
            new SquaresTransition2D(),
            new StarTransition2D(Transition2D.IN),
            new StarTransition2D(Transition2D.OUT),
            new StarsTransition2D(Transition2D.LEFT),
            new StarsTransition2D(Transition2D.RIGHT),
            new SwivelTransition2D(Transition2D.CLOCKWISE),
            new SwivelTransition2D(Transition2D.COUNTER_CLOCKWISE),
            new TossTransition2D(Transition2D.LEFT),
            new TossTransition2D(Transition2D.RIGHT),
            new WaveTransition2D(Transition2D.UP),
            new WaveTransition2D(Transition2D.RIGHT),
            new WeaveTransition2D(),
            new WipeTransition2D(Transition2D.LEFT),
            new WipeTransition2D(Transition2D.RIGHT),
            new WipeTransition2D(Transition2D.UP),
            new WipeTransition2D(Transition2D.DOWN),
            new ZoomTransition2D(Transition2D.LEFT),
            new ZoomTransition2D(Transition2D.RIGHT)
    ]

    static List code = [
            'new BarsTransition2D(Transition2D.HORIZONTAL,true)',
            'new BarsTransition2D(Transition2D.HORIZONTAL,false)',
            'new BarsTransition2D(Transition2D.VERTICAL,true)',
            'new BarsTransition2D(Transition2D.VERTICAL,false)',
            'new BatTransition2D(Transition2D.IN)',
            'new BatTransition2D(Transition2D.OUT)',
            'new BlendTransition2D()',
            'new BlindsTransition2D(Transition2D.LEFT)',
            'new BlindsTransition2D(Transition2D.RIGHT)',
            'new BlindsTransition2D(Transition2D.UP)',
            'new BlindsTransition2D(Transition2D.DOWN)',
            'new BoxTransition2D(Transition2D.IN)',
            'new BoxTransition2D(Transition2D.OUT)',
            'new CheckerboardTransition2D(Transition2D.LEFT)',
            'new CheckerboardTransition2D(Transition2D.RIGHT)',
            'new CheckerboardTransition2D(Transition2D.UP)',
            'new CheckerboardTransition2D(Transition2D.DOWN)',
            'new CircleTransition2D(Transition2D.IN)',
            'new CircleTransition2D(Transition2D.OUT)',
            'new CollapseTransition2D()',
            'new CurtainTransition2D()',
            'new DiamondsTransition2D(55)',
            'new DiamondsTransition2D(90)',
            'new DiamondsTransition2D(120)',
            'new DocumentaryTransition2D(Transition2D.LEFT)',
            'new DocumentaryTransition2D(Transition2D.RIGHT)',
            'new DocumentaryTransition2D(Transition2D.UP)',
            'new DocumentaryTransition2D(Transition2D.DOWN)',
            'new DotsTransition2D()',
            'new DropTransition2D()',
            'new FadeTransition2D(Color.BLACK)',
            'new FlurryTransition2D(Transition2D.IN)',
            'new FlurryTransition2D(Transition2D.OUT)',
            'new FunkyWipeTransition2D(true)',
            'new FunkyWipeTransition2D(false)',
            'new GooTransition2D()',
            'new HalftoneTransition2D(Transition2D.IN)',
            'new HalftoneTransition2D(Transition2D.OUT)',
            //new KaleidoscopeTransition2D(),
            'new LevitateTransition2D()',
            'new MeshShuffleTransition2D()',
            //new MicroscopeTransition2D(),
            //new MirageTransition2D(),
            'new MotionBlendTransition2D()',
            //new RefractiveTransition2D()',
            'new PivotTransition2D(Transition2D.TOP_LEFT, true)',
            'new PivotTransition2D(Transition2D.TOP_RIGHT, true)',
            'new PivotTransition2D(Transition2D.BOTTOM_LEFT, true)',
            'new PivotTransition2D(Transition2D.BOTTOM_RIGHT, true)',
            'new PivotTransition2D(Transition2D.TOP_LEFT, false)',
            'new PivotTransition2D(Transition2D.TOP_RIGHT, false)',
            'new PivotTransition2D(Transition2D.BOTTOM_LEFT, false)',
            'new PivotTransition2D(Transition2D.BOTTOM_RIGHT, false)',
            'new PushTransition2D(Transition2D.LEFT)',
            'new PushTransition2D(Transition2D.RIGHT)',
            'new PushTransition2D(Transition2D.UP)',
            'new PushTransition2D(Transition2D.DOWN)',
            'new RadialWipeTransition2D(Transition2D.CLOCKWISE)',
            'new RadialWipeTransition2D(Transition2D.COUNTER_CLOCKWISE)',
            'new RevealTransition2D(Transition2D.LEFT)',
            'new RevealTransition2D(Transition2D.RIGHT)',
            'new RevealTransition2D(Transition2D.UP)',
            'new RevealTransition2D(Transition2D.DOWN)',
            'new RotateTransition2D(Transition2D.IN)',
            'new RotateTransition2D(Transition2D.OUT)',
            'new ScaleTransition2D(Transition2D.IN)',
            'new ScaleTransition2D(Transition2D.OUT)',
            'new ScribbleTransition2D(false)',
            'new ScribbleTransition2D(true)',
            'new SlideTransition2D(Transition2D.LEFT)',
            'new SlideTransition2D(Transition2D.RIGHT)',
            'new SlideTransition2D(Transition2D.UP)',
            'new SlideTransition2D(Transition2D.DOWN)',
            'new SpiralTransition2D(false)',
            'new SpiralTransition2D(true)',
            'new SplitTransition2D(Transition2D.HORIZONTAL,false)',
            'new SplitTransition2D(Transition2D.VERTICAL,false)',
            'new SplitTransition2D(Transition2D.HORIZONTAL,true)',
            'new SplitTransition2D(Transition2D.VERTICAL,true)',
            'new SquareRainTransition2D()',
            'new SquaresTransition2D()',
            'new StarTransition2D(Transition2D.IN)',
            'new StarTransition2D(Transition2D.OUT)',
            'new StarsTransition2D(Transition2D.LEFT)',
            'new StarsTransition2D(Transition2D.RIGHT)',
            'new SwivelTransition2D(Transition2D.CLOCKWISE)',
            'new SwivelTransition2D(Transition2D.COUNTER_CLOCKWISE)',
            'new TossTransition2D(Transition2D.LEFT)',
            'new TossTransition2D(Transition2D.RIGHT)',
            'new WaveTransition2D(Transition2D.UP)',
            'new WaveTransition2D(Transition2D.RIGHT)',
            'new WeaveTransition2D()',
            'new WipeTransition2D(Transition2D.LEFT)',
            'new WipeTransition2D(Transition2D.RIGHT)',
            'new WipeTransition2D(Transition2D.UP)',
            'new WipeTransition2D(Transition2D.DOWN)',
            'new ZoomTransition2D(Transition2D.LEFT)',
            'new ZoomTransition2D(Transition2D.RIGHT)'
    ]
}
