/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SixteenSegment
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "sixteen-segment";
    private ObjectProperty<Color> color;
    private BooleanProperty plainColor;
    private StringProperty character;
    private BooleanProperty dotOn;
    private Map<Integer, List<Segment>> mapping;
    private ObjectProperty<Map<Integer, List<Segment>>> customSegmentMapping;

    public SixteenSegment() {
        this(" ", Color.rgb((int)255, (int)126, (int)18));
    }

    public SixteenSegment(String CHARACTER) {
        this(CHARACTER, Color.rgb((int)255, (int)126, (int)18));
    }

    public SixteenSegment(String CHARACTER, Color COLOR) {
        this.color = new SimpleObjectProperty((Object)COLOR);
        this.plainColor = new SimpleBooleanProperty(false);
        this.character = new SimpleStringProperty(CHARACTER);
        this.dotOn = new SimpleBooleanProperty(false);
        this.mapping = new HashMap<Integer, List<Segment>>(42);
        this.init();
    }

    private void init() {
        this.initMapping();
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    private void initMapping() {
        this.mapping.put(20, Arrays.asList(new Segment[0]));
        this.mapping.put(42, Arrays.asList(Segment.G, Segment.H, Segment.J, Segment.L, Segment.M, Segment.N));
        this.mapping.put(43, Arrays.asList(Segment.H, Segment.K, Segment.M, Segment.P));
        this.mapping.put(44, Arrays.asList(Segment.N));
        this.mapping.put(45, Arrays.asList(Segment.P, Segment.K));
        this.mapping.put(46, Arrays.asList(Segment.DOT));
        this.mapping.put(47, Arrays.asList(Segment.J, Segment.N));
        this.mapping.put(48, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.J, Segment.N));
        this.mapping.put(49, Arrays.asList(Segment.J, Segment.B, Segment.C));
        this.mapping.put(50, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.D2, Segment.D1, Segment.E, Segment.P, Segment.K));
        this.mapping.put(51, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.K));
        this.mapping.put(52, Arrays.asList(Segment.B, Segment.C, Segment.F, Segment.P, Segment.K));
        this.mapping.put(53, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.F, Segment.P, Segment.K));
        this.mapping.put(54, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(55, Arrays.asList(Segment.A1, Segment.A2, Segment.J, Segment.M));
        this.mapping.put(56, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(57, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.F, Segment.P, Segment.K));
        this.mapping.put(65, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(66, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.H, Segment.M, Segment.K));
        this.mapping.put(67, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(68, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.H, Segment.M));
        this.mapping.put(69, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(70, Arrays.asList(Segment.A1, Segment.A2, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(71, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.K));
        this.mapping.put(72, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(73, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.M, Segment.H));
        this.mapping.put(74, Arrays.asList(Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E));
        this.mapping.put(75, Arrays.asList(Segment.E, Segment.F, Segment.J, Segment.L, Segment.P));
        this.mapping.put(76, Arrays.asList(Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(77, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.G, Segment.J));
        this.mapping.put(78, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.G, Segment.L));
        this.mapping.put(79, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(80, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(81, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.L));
        this.mapping.put(82, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.E, Segment.F, Segment.P, Segment.K, Segment.L));
        this.mapping.put(83, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.G, Segment.K));
        this.mapping.put(84, Arrays.asList(Segment.A1, Segment.A2, Segment.H, Segment.M));
        this.mapping.put(85, Arrays.asList(Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(86, Arrays.asList(Segment.E, Segment.F, Segment.J, Segment.N));
        this.mapping.put(87, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.L, Segment.N));
        this.mapping.put(88, Arrays.asList(Segment.G, Segment.J, Segment.L, Segment.N));
        this.mapping.put(89, Arrays.asList(Segment.G, Segment.J, Segment.M));
        this.mapping.put(90, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.J, Segment.N));
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final boolean isPlainColor() {
        return this.plainColor.get();
    }

    public final void setPlainColor(boolean PLAIN_COLOR) {
        this.plainColor.set(PLAIN_COLOR);
    }

    public final BooleanProperty plainColorProperty() {
        return this.plainColor;
    }

    public final String getCharacter() {
        return (String)this.character.get();
    }

    public final void setCharacter(String CHARACTER) {
        this.character.set((Object)CHARACTER);
    }

    public final void setCharacter(Character CHARACTER) {
        this.character.set((Object)String.valueOf(CHARACTER));
    }

    public final StringProperty characterProperty() {
        return this.character;
    }

    public final boolean isDotOn() {
        return this.dotOn.get();
    }

    public final void setDotOn(boolean DOT_ON) {
        this.dotOn.set(DOT_ON);
    }

    public final BooleanProperty dotOnProperty() {
        return this.dotOn;
    }

    public final Map<Integer, List<Segment>> getCustomSegmentMapping() {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        return (Map)this.customSegmentMapping.get();
    }

    public final void setCustomSegmentMapping(Map<Integer, List<Segment>> CUSTOM_SEGMENT_MAPPING) {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        ((Map)this.customSegmentMapping.get()).clear();
        for (int key : CUSTOM_SEGMENT_MAPPING.keySet()) {
            ((Map)this.customSegmentMapping.get()).put(key, CUSTOM_SEGMENT_MAPPING.get(key));
        }
    }

    public final ObjectProperty<Map<Integer, List<Segment>>> customSegmentMappingProperty() {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        return this.customSegmentMapping;
    }

    public final Map<Integer, List<Segment>> getSegmentMapping() {
        HashMap<Integer, List<Segment>> segmentMapping = new HashMap<Integer, List<Segment>>(42);
        for (int key : this.mapping.keySet()) {
            segmentMapping.put(key, this.mapping.get(key));
        }
        return segmentMapping;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double width = WIDTH <= HEIGHT ? WIDTH : HEIGHT / 1.5;
        double height = WIDTH <= HEIGHT ? WIDTH * 1.5 : HEIGHT;
        super.setPrefSize(width, height);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Segment {
        A1,
        A2,
        B,
        C,
        D2,
        D1,
        E,
        F,
        G,
        H,
        J,
        K,
        L,
        M,
        N,
        P,
        DOT;

    }
}

