/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.GaugeModelEvent;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeModel {
    private DoubleProperty value;
    private BooleanProperty valueAnimationEnabled;
    private DoubleProperty animationDuration;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private DoubleProperty range;
    private BooleanProperty niceScaling;
    private DoubleProperty niceMinValue;
    private DoubleProperty niceMaxValue;
    private DoubleProperty niceRange;
    private DoubleProperty minMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private DoubleProperty threshold;
    private BooleanProperty thresholdBehaviorInverted;
    private BooleanProperty thresholdExceeded;
    private StringProperty title;
    private StringProperty unit;
    private DoubleProperty lcdValue;
    private BooleanProperty lcdValueCoupled;
    private DoubleProperty lcdThreshold;
    private BooleanProperty lcdThresholdBehaviorInverted;
    private StringProperty lcdUnit;
    private ObjectProperty<Gauge.NumberSystem> lcdNumberSystem;
    private IntegerProperty maxNoOfMajorTicks;
    private IntegerProperty maxNoOfMinorTicks;
    private IntegerProperty majorTickSpacing;
    private IntegerProperty minorTickSpacing;
    private ObjectProperty<Gauge.Trend> trend;
    private ObservableList<Section> sections;
    private ObservableList<Section> areas;
    private ObservableList<Section> tickMarkSections;
    private ObservableList<Marker> markers;
    private ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEvent = new SimpleObjectProperty();

    public GaugeModel() {
        this.value = new SimpleDoubleProperty(0.0);
        this.valueAnimationEnabled = new SimpleBooleanProperty(true);
        this.animationDuration = new SimpleDoubleProperty(800.0);
        this.minValue = new SimpleDoubleProperty(0.0);
        this.maxValue = new SimpleDoubleProperty(100.0);
        this.range = new SimpleDoubleProperty(100.0);
        this.niceScaling = new SimpleBooleanProperty(true);
        this.niceMinValue = new SimpleDoubleProperty(0.0);
        this.niceMaxValue = new SimpleDoubleProperty(100.0);
        this.niceRange = new SimpleDoubleProperty(100.0);
        this.minMeasuredValue = new SimpleDoubleProperty(100.0);
        this.maxMeasuredValue = new SimpleDoubleProperty(0.0);
        this.threshold = new SimpleDoubleProperty(50.0);
        this.thresholdBehaviorInverted = new SimpleBooleanProperty(false);
        this.thresholdExceeded = new SimpleBooleanProperty(false);
        this.title = new SimpleStringProperty("title");
        this.unit = new SimpleStringProperty("unit");
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.lcdValueCoupled = new SimpleBooleanProperty(true);
        this.lcdThreshold = new SimpleDoubleProperty(50.0);
        this.lcdThresholdBehaviorInverted = new SimpleBooleanProperty(false);
        this.lcdUnit = new SimpleStringProperty("");
        this.lcdNumberSystem = new SimpleObjectProperty((Object)Gauge.NumberSystem.DECIMAL);
        this.maxNoOfMajorTicks = new SimpleIntegerProperty(10);
        this.maxNoOfMinorTicks = new SimpleIntegerProperty(10);
        this.majorTickSpacing = new SimpleIntegerProperty(10);
        this.minorTickSpacing = new SimpleIntegerProperty(1);
        this.trend = new SimpleObjectProperty((Object)Gauge.Trend.UNKNOWN);
        this.sections = FXCollections.observableArrayList();
        this.areas = FXCollections.observableArrayList();
        this.tickMarkSections = FXCollections.observableArrayList();
        this.markers = FXCollections.observableArrayList();
    }

    public final ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEventProperty() {
        return this.onGaugeModelEvent;
    }

    public final void setOnGaugeModelEvent(EventHandler<GaugeModelEvent> HANDLER) {
        this.onGaugeModelEventProperty().set(HANDLER);
    }

    public final EventHandler<GaugeModelEvent> getOnGaugeModelEvent() {
        return (EventHandler)this.onGaugeModelEventProperty().get();
    }

    public void fireGaugeModelEvent() {
        EventHandler<GaugeModelEvent> MODEL_EVENT_HANDLER = this.getOnGaugeModelEvent();
        if (MODEL_EVENT_HANDLER != null) {
            GaugeModelEvent GAUGE_MODEL_EVENT = new GaugeModelEvent();
            MODEL_EVENT_HANDLER.handle((Event)GAUGE_MODEL_EVENT);
        }
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(Double.compare(VALUE, this.niceMinValue.get()) < 0 ? this.niceMinValue.get() : (Double.compare(VALUE, this.niceMaxValue.get()) > 0 ? this.niceMaxValue.get() : VALUE));
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final boolean isValueAnimationEnabled() {
        return this.valueAnimationEnabled.get();
    }

    public final void setValueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.valueAnimationEnabled.set(VALUE_ANIMATION_ENABLED);
    }

    public final BooleanProperty valueAnimationEnabledProperty() {
        return this.valueAnimationEnabled;
    }

    public final double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration.set(ANIMATION_DURATION);
    }

    public final DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getRange() {
        return this.range.get();
    }

    public final DoubleProperty rangeProperty() {
        return this.range;
    }

    public final double getMinMeasuredValue() {
        return this.minMeasuredValue.get();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.minMeasuredValue.set(MIN_MEASURED_VALUE);
    }

    public final DoubleProperty minMeasuredValueProperty() {
        return this.minMeasuredValue;
    }

    public final void resetMinMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
    }

    public final double getMaxMeasuredValue() {
        return this.maxMeasuredValue.get();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
    }

    public final DoubleProperty maxMeasuredValueProperty() {
        return this.maxMeasuredValue;
    }

    public final void resetMaxMeasuredValue() {
        this.setMaxMeasuredValue(this.getValue());
    }

    public final void resetMinMaxMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public final double getThreshold() {
        return this.threshold.get();
    }

    public final void setThreshold(double THRESHOLD) {
        this.threshold.set(Double.compare(THRESHOLD, this.niceMinValue.get()) < 0 ? this.niceMinValue.get() : (Double.compare(THRESHOLD, this.niceMaxValue.get()) > 0 ? this.niceMaxValue.get() : THRESHOLD));
    }

    public final DoubleProperty thresholdProperty() {
        return this.threshold;
    }

    public final boolean isThresholdBehaviorInverted() {
        return this.thresholdBehaviorInverted.get();
    }

    public final void setThresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.thresholdBehaviorInverted.set(THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty thresholdBehaviorInvertedProperty() {
        return this.thresholdBehaviorInverted;
    }

    public final boolean isThresholdExceeded() {
        return this.thresholdExceeded.get();
    }

    public final void setThresholdExceeded(boolean THRESHOLD_EXCEEDED) {
        this.thresholdExceeded.set(THRESHOLD_EXCEEDED);
    }

    public final BooleanProperty thresholdExceededProperty() {
        return this.thresholdExceeded;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getUnit() {
        return (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        this.unit.set((Object)UNIT);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final double getLcdValue() {
        return this.lcdValue.get();
    }

    public final void setLcdValue(double LCD_VALUE) {
        this.lcdValue.set(LCD_VALUE);
    }

    public final DoubleProperty lcdValueProperty() {
        return this.lcdValue;
    }

    public final boolean isLcdValueCoupled() {
        return this.lcdValueCoupled.get();
    }

    public final void setLcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.lcdValueCoupled.set(LCD_VALUE_COUPLED);
    }

    public final BooleanProperty lcdValueCoupledProperty() {
        return this.lcdValueCoupled;
    }

    public final double getLcdThreshold() {
        return this.lcdThreshold.get();
    }

    public final void setLcdThreshold(double LCD_THRESHOLD) {
        this.lcdThreshold.set(LCD_THRESHOLD);
    }

    public final DoubleProperty lcdThresholdProperty() {
        return this.lcdThreshold;
    }

    public final boolean isLcdThresholdBehaviorInverted() {
        return this.lcdThresholdBehaviorInverted.get();
    }

    public final void setLcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.lcdThresholdBehaviorInverted.set(LCD_THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty lcdThresholdBehaviorInvertedProperty() {
        return this.lcdThresholdBehaviorInverted;
    }

    public final String getLcdUnit() {
        return (String)this.lcdUnit.get();
    }

    public final void setLcdUnit(String LCD_UNIT_STRING) {
        this.lcdUnit.set((Object)LCD_UNIT_STRING);
    }

    public final StringProperty lcdUnitProperty() {
        return this.lcdUnit;
    }

    public final Gauge.NumberSystem getLcdNumberSystem() {
        return (Gauge.NumberSystem)((Object)this.lcdNumberSystem.get());
    }

    public final void setLcdNumberSystem(Gauge.NumberSystem LCD_NUMBER_SYSTEM) {
        this.lcdNumberSystem.set((Object)LCD_NUMBER_SYSTEM);
    }

    public final ObjectProperty lcdNumberSystemProperty() {
        return this.lcdNumberSystem;
    }

    public final int getMaxNoOfMajorTicks() {
        return this.maxNoOfMajorTicks.get();
    }

    public final void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.maxNoOfMajorTicks.set(MAX_NO_OF_MAJOR_TICKS);
    }

    public final IntegerProperty maxNoOfMajorTicksProperty() {
        return this.maxNoOfMajorTicks;
    }

    public final int getMaxNoOfMinorTicks() {
        return this.maxNoOfMinorTicks.get();
    }

    public final void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.maxNoOfMinorTicks.set(MAX_NO_OF_MINOR_TICKS);
    }

    public final IntegerProperty maxNoOfMinorTicksProperty() {
        return this.maxNoOfMinorTicks;
    }

    public final int getMajorTickSpacing() {
        return this.majorTickSpacing.get();
    }

    public final void setMajorTickSpacing(int MAJOR_TICKSPACING) {
        this.majorTickSpacing.set(MAJOR_TICKSPACING);
    }

    public final IntegerProperty majorTickSpacingProperty() {
        return this.majorTickSpacing;
    }

    public final int getMinorTickSpacing() {
        return this.minorTickSpacing.get();
    }

    public final void setMinorTickSpacing(int MINOR_TICKSPACING) {
        this.minorTickSpacing.set(MINOR_TICKSPACING);
    }

    public final IntegerProperty minorTickSpacingProperty() {
        return this.minorTickSpacing;
    }

    public final Gauge.Trend getTrend() {
        return (Gauge.Trend)((Object)this.trend.get());
    }

    public final void setTrend(Gauge.Trend TREND) {
        this.trend.set((Object)TREND);
    }

    public final ObjectProperty<Gauge.Trend> trendProperty() {
        return this.trend;
    }

    public final boolean isNiceScaling() {
        return this.niceScaling.get();
    }

    public final void setNiceScaling(boolean NICE_SCALING) {
        this.niceScaling.set(NICE_SCALING);
    }

    public final BooleanProperty niceScalingProperty() {
        return this.niceScaling;
    }

    public final List<Section> getSections() {
        ArrayList<Section> SECTIONS_COPY = new ArrayList<Section>(this.sections.size());
        SECTIONS_COPY.addAll((Collection<Section>)this.sections);
        return SECTIONS_COPY;
    }

    public final void setSections(Section ... SECTION_ARRAY) {
        this.sections.clear();
        for (Section SECTION : SECTION_ARRAY) {
            this.sections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.clear();
        for (Section SECTION : SECTIONS) {
            this.sections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void addSection(Section SECTION) {
        this.sections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeSection(Section SECTION) {
        for (Section section : this.sections) {
            if (!section.equals(SECTION)) continue;
            this.sections.remove((Object)section);
            this.fireGaugeModelEvent();
            break;
        }
    }

    public final void resetSections() {
        this.sections.clear();
        this.fireGaugeModelEvent();
    }

    public final List<Section> getAreas() {
        ArrayList<Section> AREAS_COPY = new ArrayList<Section>(this.areas.size());
        AREAS_COPY.addAll((Collection<Section>)this.areas);
        return AREAS_COPY;
    }

    public final void setAreas(Section ... AREA_ARRAY) {
        this.areas.clear();
        for (Section AREA : AREA_ARRAY) {
            this.areas.add((Object)new Section(AREA.getStart(), AREA.getStop(), AREA.getColor(), AREA.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void setAreas(List<Section> AREAS) {
        this.areas.clear();
        for (Section AREA : AREAS) {
            this.areas.add((Object)new Section(AREA.getStart(), AREA.getStop(), AREA.getColor(), AREA.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void addArea(Section AREA) {
        this.areas.add((Object)new Section(AREA.getStart(), AREA.getStop(), AREA.getColor(), AREA.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeArea(Section AREA) {
        for (Section area : this.areas) {
            if (!area.equals(AREA)) continue;
            this.areas.remove((Object)area);
            this.fireGaugeModelEvent();
            break;
        }
    }

    public final void resetAreas() {
        this.areas.clear();
        this.fireGaugeModelEvent();
    }

    public final List<Section> getTickMarkSections() {
        ArrayList<Section> TICK_MARK_SECTIONS_COPY = new ArrayList<Section>(this.tickMarkSections.size());
        TICK_MARK_SECTIONS_COPY.addAll((Collection<Section>)this.tickMarkSections);
        return TICK_MARK_SECTIONS_COPY;
    }

    public final void setTickMarkSections(Section ... SECTIONS_ARRAY) {
        this.tickMarkSections.clear();
        for (Section SECTION : SECTIONS_ARRAY) {
            this.tickMarkSections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void setTickMarkSections(List<Section> SECTIONS) {
        this.tickMarkSections.clear();
        for (Section SECTION : SECTIONS) {
            this.tickMarkSections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        }
        this.fireGaugeModelEvent();
    }

    public final void addTickMarkSection(Section SECTION) {
        this.tickMarkSections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeTickMarkSection(Section SECTION) {
        for (Section section : this.tickMarkSections) {
            if (!section.equals(SECTION)) continue;
            this.tickMarkSections.remove((Object)section);
            this.fireGaugeModelEvent();
            break;
        }
    }

    public final void resetTickMarkSections() {
        this.tickMarkSections.clear();
        this.fireGaugeModelEvent();
    }

    public final List<Marker> getMarkers() {
        ArrayList<Marker> INDICATORS_COPY = new ArrayList<Marker>(this.markers.size());
        INDICATORS_COPY.addAll((Collection<Marker>)this.markers);
        return INDICATORS_COPY;
    }

    public final void setMarkers(Marker ... MARKER_ARRAY) {
        this.markers.clear();
        for (Marker MARKER : MARKER_ARRAY) {
            this.markers.add((Object)new Marker(MARKER.getValue(), MARKER.getColor(), MARKER.getText(), MARKER.isVisible()));
        }
        this.fireGaugeModelEvent();
    }

    public final void setMarkers(List<Marker> MARKERS) {
        this.markers.clear();
        for (Marker MARKER : MARKERS) {
            this.markers.add((Object)new Marker(MARKER.getValue(), MARKER.getColor(), MARKER.getText(), MARKER.isVisible()));
        }
        this.fireGaugeModelEvent();
    }

    public final void addMarker(Marker MARKER) {
        this.markers.add((Object)new Marker(MARKER.getValue(), MARKER.getColor(), MARKER.getText(), MARKER.isVisible()));
        this.fireGaugeModelEvent();
    }

    public final void removeMarker(Marker MARKER) {
        for (Marker marker : this.markers) {
            if (!marker.equals(MARKER)) continue;
            this.markers.remove((Object)marker);
            this.fireGaugeModelEvent();
            break;
        }
    }

    public final void resetMarkers() {
        this.markers.clear();
        this.fireGaugeModelEvent();
    }

    protected void calcRange(double ANGLE_RANGE) {
        if (this.isNiceScaling()) {
            this.niceRange.set(GaugeModel.calcNiceNumber(this.range.doubleValue(), false));
            this.majorTickSpacing.set((int)GaugeModel.calcNiceNumber(this.niceRange.get() / (double)(this.getMaxNoOfMajorTicks() - 1), true));
            this.niceMinValue.set(Math.floor(this.getMinValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.niceMaxValue.set(Math.ceil(this.getMaxValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.minorTickSpacing.set((int)GaugeModel.calcNiceNumber((double)this.getMajorTickSpacing() / ((double)this.getMaxNoOfMajorTicks() - 1.0), true));
            this.minValue.set(this.niceMinValue.get());
            this.maxValue.set(this.niceMaxValue.get());
            this.range.set(this.niceMaxValue.get() - this.niceMinValue.get());
        } else {
            this.niceRange.set(this.getMaxValue() - this.getMinValue());
            this.niceMinValue.set(this.getMinValue());
            this.niceMaxValue.set(this.getMaxValue());
            this.range.set(this.getMaxValue() - this.getMinValue());
        }
    }

    private static double calcNiceNumber(double RANGE, boolean ROUND) {
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double NICE_FRACTION = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (Double.compare(FRACTION, 1.0) <= 0 ? 1.0 : (Double.compare(FRACTION, 2.0) <= 0 ? 2.0 : (Double.compare(FRACTION, 5.0) <= 0 ? 5.0 : 10.0)));
        return NICE_FRACTION * Math.pow(10.0, EXPONENT);
    }
}

