/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.scene.control.gauge.ColorDef;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.GaugeModelEvent;
import jfxtras.labs.scene.control.gauge.LcdDesign;
import jfxtras.labs.scene.control.gauge.LedColor;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Radial;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.StyleModel;
import jfxtras.labs.scene.control.gauge.StyleModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Gauge
extends Control {
    private ObjectProperty<GaugeModel> gaugeModelProperty;
    private ObjectProperty<StyleModel> styleModelProperty;
    private GaugeModel gaugeModel;
    private StyleModel styleModel;
    private ObjectProperty<RadialRange> radialRange;
    private DoubleProperty angleStep;
    private final ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEvent = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<StyleModelEvent>> onStyleModelEvent = new SimpleObjectProperty();

    public Gauge() {
        this(new GaugeModel());
    }

    public Gauge(GaugeModel GAUGE_MODEL) {
        this(GAUGE_MODEL, new StyleModel());
    }

    public Gauge(StyleModel STYLE_MODEL) {
        this(new GaugeModel(), STYLE_MODEL);
    }

    public Gauge(GaugeModel GAUGE_MODEL, StyleModel STYLE_MODEL) {
        this.gaugeModelProperty = new SimpleObjectProperty((Object)GAUGE_MODEL);
        this.styleModelProperty = new SimpleObjectProperty((Object)STYLE_MODEL);
        this.gaugeModel = (GaugeModel)this.gaugeModelProperty.get();
        this.styleModel = (StyleModel)this.styleModelProperty.get();
        this.radialRange = new SimpleObjectProperty((Object)RadialRange.RADIAL_300);
        this.angleStep = new SimpleDoubleProperty(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
        this.ledBlinkingProperty().bind((ObservableValue)this.thresholdExceededProperty());
        this.addGaugeModelListener();
        this.addStyleModelListener();
    }

    public abstract void init();

    private final void addGaugeModelListener() {
        this.gaugeModel.setOnGaugeModelEvent(new EventHandler<GaugeModelEvent>(){

            public void handle(GaugeModelEvent EVENT) {
                Gauge.this.forwardModelEvent(EVENT);
            }
        });
    }

    private final void addStyleModelListener() {
        this.styleModel.setOnStyleModelEvent(new EventHandler<StyleModelEvent>(){

            public void handle(StyleModelEvent EVENT) {
                Gauge.this.forwardStyleModelEvent(EVENT);
            }
        });
    }

    public final ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEventProperty() {
        return this.onGaugeModelEvent;
    }

    public final void setOnGaugeModelEvent(EventHandler<GaugeModelEvent> HANDLER) {
        this.onGaugeModelEventProperty().set(HANDLER);
    }

    public final EventHandler<GaugeModelEvent> getOnGaugeModelEvent() {
        return (EventHandler)this.onGaugeModelEventProperty().get();
    }

    public void forwardModelEvent(GaugeModelEvent EVENT) {
        EventHandler<GaugeModelEvent> MODEL_EVENT_HANDLER = this.getOnGaugeModelEvent();
        if (MODEL_EVENT_HANDLER != null) {
            MODEL_EVENT_HANDLER.handle((Event)EVENT);
        }
    }

    public final ObjectProperty<EventHandler<StyleModelEvent>> onStyleModelEventProperty() {
        return this.onStyleModelEvent;
    }

    public final void setOnStyleModelEvent(EventHandler<StyleModelEvent> HANDLER) {
        this.onStyleModelEventProperty().set(HANDLER);
    }

    public final EventHandler<StyleModelEvent> getOnStyleModelEvent() {
        return (EventHandler)this.onStyleModelEventProperty().get();
    }

    public void forwardStyleModelEvent(StyleModelEvent EVENT) {
        EventHandler<StyleModelEvent> STYLE_MODEL_EVENT_HANDLER = this.getOnStyleModelEvent();
        if (STYLE_MODEL_EVENT_HANDLER != null) {
            STYLE_MODEL_EVENT_HANDLER.handle((Event)EVENT);
        }
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("steelseries.css").toExternalForm();
    }

    public final StyleModel getStyleModel() {
        return (StyleModel)this.styleModelProperty.get();
    }

    public final void setStyleModel(StyleModel STYLE_MODEL) {
        this.styleModelProperty.set((Object)STYLE_MODEL);
        this.styleModel = (StyleModel)this.styleModelProperty().get();
        this.addStyleModelListener();
        this.styleModel.fireStyleModelEvent();
        this.init();
    }

    public final ObjectProperty<StyleModel> styleModelProperty() {
        return this.styleModelProperty;
    }

    public final GaugeModel getGaugeModel() {
        return (GaugeModel)this.gaugeModelProperty.get();
    }

    public final void setGaugeModel(GaugeModel GAUGE_MODEL) {
        this.gaugeModelProperty.set((Object)GAUGE_MODEL);
        this.gaugeModel = (GaugeModel)this.gaugeModelProperty.get();
        this.addGaugeModelListener();
        this.gaugeModel.fireGaugeModelEvent();
        this.init();
    }

    public final ObjectProperty<GaugeModel> gaugeModelProperty() {
        return this.gaugeModelProperty;
    }

    public final RadialRange getRadialRange() {
        return (RadialRange)((Object)this.radialRange.get());
    }

    public void setRadialRange(RadialRange RADIAL_RANGE) {
        this.radialRange.set((Object)RADIAL_RANGE);
        this.gaugeModel.calcRange(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE);
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final ObjectProperty<RadialRange> radialRangeProperty() {
        return this.radialRange;
    }

    public final double getAngleStep() {
        return this.angleStep.get();
    }

    public final void recalcRange() {
        this.gaugeModel.calcRange(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE);
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final DoubleProperty angleStepProperty() {
        return this.angleStep;
    }

    public final Point2D getLedPosition() {
        return ((RadialRange)((Object)this.radialRange.get())).LED_POSITION;
    }

    public final Point2D getUserLedPosition() {
        return ((RadialRange)((Object)this.radialRange.get())).USER_LED_POSITION;
    }

    public final double getValue() {
        return this.gaugeModel.getValue();
    }

    public final void setValue(double VALUE) {
        this.gaugeModel.setValue(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.gaugeModel.valueProperty();
    }

    public final boolean isValueAnimationEnabled() {
        return this.gaugeModel.isValueAnimationEnabled();
    }

    public final void setValueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.gaugeModel.setValueAnimationEnabled(VALUE_ANIMATION_ENABLED);
    }

    public final BooleanProperty valueAnimationEnabledProperty() {
        return this.gaugeModel.valueAnimationEnabledProperty();
    }

    public final double getAnimationDuration() {
        return this.gaugeModel.getAnimationDuration();
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.gaugeModel.setAnimationDuration(ANIMATION_DURATION);
    }

    public final DoubleProperty animationDurationProperty() {
        return this.gaugeModel.animationDurationProperty();
    }

    public final double getMinValue() {
        return this.gaugeModel.getMinValue();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.gaugeModel.setMinValue(MIN_VALUE);
        this.gaugeModel.calcRange(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE);
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final DoubleProperty minValueProperty() {
        return this.gaugeModel.minValueProperty();
    }

    public final double getMaxValue() {
        return this.gaugeModel.getMaxValue();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.gaugeModel.setMaxValue(MAX_VALUE);
        this.gaugeModel.calcRange(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE);
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final DoubleProperty maxValueProperty() {
        return this.gaugeModel.maxValueProperty();
    }

    public final double getRange() {
        return this.gaugeModel.getRange();
    }

    public final DoubleProperty rangeProperty() {
        return this.gaugeModel.rangeProperty();
    }

    public final double getMinMeasuredValue() {
        return this.gaugeModel.getMinMeasuredValue();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.gaugeModel.setMinMeasuredValue(MIN_MEASURED_VALUE);
    }

    public final DoubleProperty minMeasuredValueProperty() {
        return this.gaugeModel.minMeasuredValueProperty();
    }

    public final boolean isBargraph() {
        return this.styleModel.isBargraph();
    }

    public final void setBargraph(boolean BARGRAPH) {
        this.styleModel.setBargraph(BARGRAPH);
    }

    public final BooleanProperty bargraphProperty() {
        return this.styleModel.bargraphProperty();
    }

    public final boolean isMinMeasuredValueVisible() {
        return this.styleModel.isMinMeasuredValueVisible();
    }

    public final void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMinMeasuredValueVisible(MIN_MEASURED_VALUE_VISIBLE);
    }

    public final BooleanProperty minMeasuredValueVisibleProperty() {
        return this.styleModel.minMeasuredValueVisibleProperty();
    }

    public final void resetMinMeasuredValue() {
        this.gaugeModel.resetMinMeasuredValue();
    }

    public final double getMaxMeasuredValue() {
        return this.gaugeModel.getMaxMeasuredValue();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.gaugeModel.setMaxMeasuredValue(MAX_MEASURED_VALUE);
    }

    public final DoubleProperty maxMeasuredValueProperty() {
        return this.gaugeModel.maxMeasuredValueProperty();
    }

    public final boolean isMaxMeasuredValueVisible() {
        return this.styleModel.isMaxMeasuredValueVisible();
    }

    public final void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMaxMeasuredValueVisible(MAX_MEASURED_VALUE_VISIBLE);
    }

    public final BooleanProperty maxMeasuredValueVisibleProperty() {
        return this.styleModel.maxMeasuredValueVisibleProperty();
    }

    public final void resetMaxMeasuredValue() {
        this.gaugeModel.resetMaxMeasuredValue();
    }

    public final void resetMinMaxMeasuredValue() {
        this.gaugeModel.resetMinMaxMeasuredValue();
    }

    public final double getThreshold() {
        return this.gaugeModel.getThreshold();
    }

    public final void setThreshold(double THRESHOLD) {
        this.gaugeModel.setThreshold(THRESHOLD);
    }

    public final DoubleProperty thresholdProperty() {
        return this.gaugeModel.thresholdProperty();
    }

    public final boolean isThresholdBehaviorInverted() {
        return this.gaugeModel.isThresholdBehaviorInverted();
    }

    public final void setThresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setThresholdBehaviorInverted(THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty thresholdBehaviorInvertedProperty() {
        return this.gaugeModel.thresholdBehaviorInvertedProperty();
    }

    public final boolean isThresholdExceeded() {
        return this.gaugeModel.isThresholdExceeded();
    }

    public final void setThresholdExceeded(boolean THRESHOLD_EXCEEDED) {
        this.gaugeModel.setThresholdExceeded(THRESHOLD_EXCEEDED);
    }

    public final BooleanProperty thresholdExceededProperty() {
        return this.gaugeModel.thresholdExceededProperty();
    }

    public final boolean isThresholdVisible() {
        return this.styleModel.isThresholdVisible();
    }

    public final void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.styleModel.setThresholdVisible(THRESHOLD_VISIBLE);
    }

    public final BooleanProperty thresholdVisibleProperty() {
        return this.styleModel.thresholdVisibleProperty();
    }

    public final ThresholdColor getThresholdColor() {
        return this.styleModel.getThresholdColor();
    }

    public final void setThresholdColor(ThresholdColor THRESHOLD_COLOR) {
        this.styleModel.setThresholdColor(THRESHOLD_COLOR);
    }

    public final ObjectProperty<ThresholdColor> thresholdColorProperty() {
        return this.styleModel.thresholdColorProperty();
    }

    public final String getTitle() {
        return this.gaugeModel.getTitle();
    }

    public final void setTitle(String TITLE) {
        this.gaugeModel.setTitle(TITLE);
    }

    public final StringProperty titleProperty() {
        return this.gaugeModel.titleProperty();
    }

    public final String getUnit() {
        return this.gaugeModel.getUnit();
    }

    public final void setUnit(String UNIT) {
        this.gaugeModel.setUnit(UNIT);
    }

    public final StringProperty unitProperty() {
        return this.gaugeModel.unitProperty();
    }

    public final FrameDesign getFrameDesign() {
        return this.styleModel.getFrameDesign();
    }

    public final void setFrameDesign(FrameDesign FRAME_DESIGN) {
        this.styleModel.setFrameDesign(FRAME_DESIGN);
    }

    public final ObjectProperty<FrameDesign> frameDesignProperty() {
        return this.styleModel.frameDesignProperty();
    }

    public final boolean isFrameVisible() {
        return this.styleModel.isFrameVisible();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.styleModel.setFrameVisible(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        return this.styleModel.frameVisibleProperty();
    }

    public final BackgroundDesign getBackgroundDesign() {
        return this.styleModel.getBackgroundDesign();
    }

    public final void setBackgroundDesign(BackgroundDesign BACKGROUND_DESIGN) {
        this.styleModel.setBackgroundDesign(BACKGROUND_DESIGN);
    }

    public final ObjectProperty<BackgroundDesign> backgroundDesignProperty() {
        return this.styleModel.backgroundDesignProperty();
    }

    public final boolean isBackgroundVisible() {
        return this.styleModel.isBackgroundVisible();
    }

    public final void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.styleModel.setBackgroundVisible(BACKGROUND_VISIBLE);
    }

    public final BooleanProperty backgroundVisibleProperty() {
        return this.styleModel.backgroundVisibleProperty();
    }

    public final KnobDesign getKnobDesign() {
        return this.styleModel.getKnobDesign();
    }

    public final void setKnobDesign(KnobDesign KNOB_DESIGN) {
        this.styleModel.setKnobDesign(KNOB_DESIGN);
    }

    public final ObjectProperty<KnobDesign> knobDesignProperty() {
        return this.styleModel.knobDesignProperty();
    }

    public final KnobColor getKnobColor() {
        return this.styleModel.getKnobColor();
    }

    public final void setKnobColor(KnobColor KNOB_COLOR) {
        this.styleModel.setKnobColor(KNOB_COLOR);
    }

    public final ObjectProperty<KnobColor> knobColorProperty() {
        return this.styleModel.knobColorProperty();
    }

    public final boolean isPostsVisible() {
        return this.styleModel.isPostsVisible();
    }

    public final void setPostsVisible(boolean POSTS_VISIBLE) {
        this.styleModel.setPostsVisible(POSTS_VISIBLE);
    }

    public final BooleanProperty postsVisibleProperty() {
        return this.styleModel.postsVisibleProperty();
    }

    public final PointerType getPointerType() {
        return this.styleModel.getPointerType();
    }

    public final void setPointerType(PointerType POINTER_TYPE) {
        this.styleModel.setPointerType(POINTER_TYPE);
    }

    public final ObjectProperty<PointerType> pointerTypeProperty() {
        return this.styleModel.pointerTypeProperty();
    }

    public final ColorDef getValueColor() {
        return this.styleModel.getValueColor();
    }

    public final void setValueColor(ColorDef VALUE_COLOR) {
        this.styleModel.setValueColor(VALUE_COLOR);
    }

    public final ObjectProperty<ColorDef> valueColorProperty() {
        return this.styleModel.valueColorProperty();
    }

    public final boolean isPointerGlowEnabled() {
        return this.styleModel.isPointerGlowEnabled();
    }

    public final void setPointerGlowEnabled(boolean POINTER_GLOW_ENABLED) {
        this.styleModel.setPointerGlowEnabled(POINTER_GLOW_ENABLED);
    }

    public final BooleanProperty pointerGlowEnabledProperty() {
        return this.styleModel.pointerGlowEnabledProperty();
    }

    public final boolean isPointerShadowEnabled() {
        return this.styleModel.isPointerShadowEnabled();
    }

    public final void setPointerShadowEnabled(boolean POINTER_SHADOW_ENABLED) {
        this.styleModel.setPointerShadowEnabled(POINTER_SHADOW_ENABLED);
    }

    public final BooleanProperty pointerShadowEnabledProperty() {
        return this.styleModel.pointerShadowEnabledProperty();
    }

    public final boolean isLedVisible() {
        return this.styleModel.isLedVisible();
    }

    public final void setLedVisible(boolean LED_VISIBLE) {
        this.styleModel.setLedVisible(LED_VISIBLE);
    }

    public final BooleanProperty ledVisibleProperty() {
        return this.styleModel.ledVisibleProperty();
    }

    public final LedColor getLedColor() {
        return this.styleModel.getLedColor();
    }

    public final void setLedColor(LedColor LED_COLOR) {
        this.styleModel.setLedColor(LED_COLOR);
    }

    public final ObjectProperty<LedColor> ledColorProperty() {
        return this.styleModel.ledColorProperty();
    }

    public final boolean isLedBlinking() {
        return this.styleModel.isLedBlinking();
    }

    public final void setLedBlinking(boolean LED_BLINKING) {
        this.styleModel.setLedBlinking(LED_BLINKING);
    }

    public final BooleanProperty ledBlinkingProperty() {
        return this.styleModel.ledBlinkingProperty();
    }

    public final boolean isUserLedVisible() {
        return this.styleModel.isUserLedVisible();
    }

    public final void setUserLedVisible(boolean USER_LED_VISIBLE) {
        this.styleModel.setUserLedVisible(USER_LED_VISIBLE);
    }

    public final BooleanProperty userLedVisibleProperty() {
        return this.styleModel.userLedVisibleProperty();
    }

    public final LedColor getUserLedColor() {
        return this.styleModel.getUserLedColor();
    }

    public final void setUserLedColor(LedColor USER_LED_COLOR) {
        this.styleModel.setUserLedColor(USER_LED_COLOR);
    }

    public final ObjectProperty<LedColor> userLedColorProperty() {
        return this.styleModel.userLedColorProperty();
    }

    public final boolean isUserLedOn() {
        return this.styleModel.isUserLedOn();
    }

    public final void setUserLedOn(boolean USER_LED_ON) {
        this.styleModel.setUserLedOn(USER_LED_ON);
    }

    public final BooleanProperty userLedOnProperty() {
        return this.styleModel.userLedOnProperty();
    }

    public final boolean isUserLedBlinking() {
        return this.styleModel.isUserLedBlinking();
    }

    public final void setUserLedBlinking(boolean USER_LED_BLINKING) {
        this.styleModel.setUserLedBlinking(USER_LED_BLINKING);
    }

    public final BooleanProperty userLedBlinkingProperty() {
        return this.styleModel.userLedBlinkingProperty();
    }

    public final String getTitleFont() {
        return this.styleModel.getTitleFont();
    }

    public final void setTitleFont(String TITLE_FONT) {
        this.styleModel.setTitleFont(TITLE_FONT);
    }

    public final StringProperty titleFontProperty() {
        return this.styleModel.titleFontProperty();
    }

    public final String getUnitFont() {
        return this.styleModel.getUnitFont();
    }

    public final void setUnitFont(String UNIT_FONT) {
        this.styleModel.setUnitFont(UNIT_FONT);
    }

    public final StringProperty unitFontProperty() {
        return this.styleModel.unitFontProperty();
    }

    public final Radial.ForegroundType getForegroundType() {
        return this.styleModel.getForegroundType();
    }

    public final void setForegroundType(Radial.ForegroundType FOREGROUND_TYPE) {
        this.styleModel.setForegroundType(FOREGROUND_TYPE);
    }

    public final ObjectProperty<Radial.ForegroundType> foregroundTypeProperty() {
        return this.styleModel.foregroundTypeProperty();
    }

    public final boolean isForegroundVisible() {
        return this.styleModel.isForegroundVisible();
    }

    public final void setForegroundVisible(boolean FOREGROUND_VISIBLE) {
        this.styleModel.setForegroundVisible(FOREGROUND_VISIBLE);
    }

    public final BooleanProperty foregroundVisibleProperty() {
        return this.styleModel.foregroundVisibleProperty();
    }

    public final double getLcdValue() {
        return this.gaugeModel.getLcdValue();
    }

    public final void setLcdValue(double LCD_VALUE) {
        this.gaugeModel.setLcdValue(LCD_VALUE);
    }

    public final DoubleProperty lcdValueProperty() {
        return this.gaugeModel.lcdValueProperty();
    }

    public final boolean isLcdValueCoupled() {
        return this.gaugeModel.isLcdValueCoupled();
    }

    public final void setLcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.gaugeModel.setLcdValueCoupled(LCD_VALUE_COUPLED);
    }

    public final BooleanProperty lcdValueCoupledProperty() {
        return this.gaugeModel.lcdValueCoupledProperty();
    }

    public final double getLcdThreshold() {
        return this.gaugeModel.getLcdThreshold();
    }

    public final void setLcdThreshold(double LCD_THRESHOLD) {
        this.gaugeModel.setLcdThreshold(LCD_THRESHOLD);
    }

    public final DoubleProperty lcdThresholdProperty() {
        return this.gaugeModel.lcdThresholdProperty();
    }

    public final boolean isLcdThresholdBehaviorInverted() {
        return this.gaugeModel.isLcdThresholdBehaviorInverted();
    }

    public final void setLcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setLcdThresholdBehaviorInverted(LCD_THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty lcdThresholdBehaviorInvertedProperty() {
        return this.gaugeModel.lcdThresholdBehaviorInvertedProperty();
    }

    public final boolean isLcdThresholdVisible() {
        return this.styleModel.isLcdThresholdVisible();
    }

    public final void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.styleModel.setLcdThresholdVisible(LCD_THRESHOLD_VISIBLE);
    }

    public final BooleanProperty lcdThresholdVisibleProperty() {
        return this.styleModel.lcdThresholdVisibleProperty();
    }

    public final LcdDesign getLcdDesign() {
        return this.styleModel.getLcdDesign();
    }

    public final void setLcdDesign(LcdDesign LCD_Design) {
        this.styleModel.setLcdDesign(LCD_Design);
    }

    public final ObjectProperty lcdDesignProperty() {
        return this.styleModel.lcdDesignProperty();
    }

    public final boolean isLcdVisible() {
        return this.styleModel.isLcdVisible();
    }

    public final void setLcdVisible(boolean LCD_VISIBLE) {
        this.styleModel.setLcdVisible(LCD_VISIBLE);
    }

    public final BooleanProperty lcdVisibleProperty() {
        return this.styleModel.lcdVisibleProperty();
    }

    public final boolean isLcdDigitalFontEnabled() {
        return this.styleModel.isLcdDigitalFontEnabled();
    }

    public final void setLcdDigitalFontEnabled(boolean LCD_DIGITAL_FONT_ENABLED) {
        this.styleModel.setLcdDigitalFontEnabled(LCD_DIGITAL_FONT_ENABLED);
    }

    public final BooleanProperty lcdDigitalFontEnabledProperty() {
        return this.styleModel.lcdDigitalFontEnabledProperty();
    }

    public final String getLcdUnit() {
        return this.gaugeModel.getLcdUnit();
    }

    public final void setLcdUnit(String LCD_UNIT) {
        this.gaugeModel.setLcdUnit(LCD_UNIT);
    }

    public final StringProperty lcdUnitProperty() {
        return this.gaugeModel.lcdUnitProperty();
    }

    public final boolean isLcdUnitVisible() {
        return this.styleModel.getLcdUnitVisible();
    }

    public final void setLcdUnitVisible(boolean LCD_UNIT_VISIBLE) {
        this.styleModel.setLcdUnitVisible(LCD_UNIT_VISIBLE);
    }

    public final BooleanProperty lcdUnitVisibleProperty() {
        return this.styleModel.lcdUnitVisibleProperty();
    }

    public final String getLcdUnitFont() {
        return this.styleModel.getLcdUnitFont();
    }

    public final void setLcdUnitFont(String LCD_UNIT_FONT) {
        this.styleModel.setLcdUnitFont(LCD_UNIT_FONT);
    }

    public final StringProperty lcdUnitFontProperty() {
        return this.styleModel.lcdUnitFontProperty();
    }

    public final String getLcdTitleFont() {
        return this.styleModel.getLcdTitleFont();
    }

    public final void setLcdTitleFont(String LCD_TITLE_FONT) {
        this.styleModel.setLcdTitleFont(LCD_TITLE_FONT);
    }

    public final StringProperty lcdTitleFontProperty() {
        return this.styleModel.lcdTitleFontProperty();
    }

    public final NumberSystem getLcdNumberSystem() {
        return this.gaugeModel.getLcdNumberSystem();
    }

    public final void setLcdNumberSystem(NumberSystem LCD_NUMBER_SYSTEM) {
        this.gaugeModel.setLcdNumberSystem(LCD_NUMBER_SYSTEM);
    }

    public final ObjectProperty lcdNumberSystemProperty() {
        return this.gaugeModel.lcdNumberSystemProperty();
    }

    public final boolean isLcdNumberSystemVisible() {
        return this.styleModel.isLcdNumberSystemVisible();
    }

    public final void setLcdNumberSystemVisible(boolean LCD_NUMBER_SYSTEM_VISIBLE) {
        this.styleModel.setLcdNumberSystemVisible(LCD_NUMBER_SYSTEM_VISIBLE);
    }

    public final BooleanProperty lcdNumberSystemVisibleProperty() {
        return this.styleModel.lcdNumberSystemVisibleProperty();
    }

    public final int getLcdDecimals() {
        return this.styleModel.getLcdDecimals();
    }

    public final void setLcdDecimals(int LCD_DECIMALS) {
        this.styleModel.setLcdDecimals(LCD_DECIMALS);
    }

    public final IntegerProperty lcdDecimalsProperty() {
        return this.styleModel.lcdDecimalsProperty();
    }

    public final boolean isLcdBlinking() {
        return this.styleModel.isLcdBlinking();
    }

    public final void setLcdBlinking(boolean LCD_BLINKING) {
        this.styleModel.setLcdBlinking(LCD_BLINKING);
    }

    public final BooleanProperty lcdBlinkingProperty() {
        return this.styleModel.lcdBlinkingProperty();
    }

    public final boolean isGlowVisible() {
        return this.styleModel.isGlowVisible();
    }

    public final void setGlowVisible(boolean GLOW_VISIBLE) {
        this.styleModel.setGlowVisible(GLOW_VISIBLE);
    }

    public final BooleanProperty glowVisibleProperty() {
        return this.styleModel.glowVisibleProperty();
    }

    public final boolean isGlowOn() {
        return this.styleModel.isGlowOn();
    }

    public final void setGlowOn(boolean GLOW_ON) {
        this.styleModel.setGlowOn(GLOW_ON);
    }

    public final BooleanProperty glowOnProperty() {
        return this.styleModel.glowOnProperty();
    }

    public final boolean isPulsatingGlow() {
        return this.styleModel.isPulsatingGlow();
    }

    public final void setPulsatingGlow(boolean PULSATING_GLOW) {
        this.styleModel.setPulsatingGlow(PULSATING_GLOW);
    }

    public final BooleanProperty pulsatingGlowProperty() {
        return this.styleModel.pulsatingGlowProperty();
    }

    public final Color getGlowColor() {
        return this.styleModel.getGlowColor();
    }

    public final void setGlowColor(Color GLOW_COLOR) {
        this.styleModel.setGlowColor(GLOW_COLOR);
    }

    public final ObjectProperty<Color> glowColorProperty() {
        return this.styleModel.glowColorProperty();
    }

    public final boolean isTickmarksVisible() {
        return this.styleModel.isTickmarksVisible();
    }

    public final void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.styleModel.setTickmarksVisible(TICKMARKS_VISIBLE);
    }

    public final BooleanProperty tickmarksVisibleProperty() {
        return this.styleModel.tickmarksVisibleProperty();
    }

    public final boolean isMajorTicksVisible() {
        return this.styleModel.isMajorTicksVisible();
    }

    public final void setMajorTicksVisible(boolean MAJOR_TICKS_VISIBLE) {
        this.styleModel.setMajorTicksVisible(MAJOR_TICKS_VISIBLE);
    }

    public final BooleanProperty majorTicksVisibleProperty() {
        return this.styleModel.majorTicksVisibleProperty();
    }

    public final TickmarkType getMajorTickmarkType() {
        return this.styleModel.getMajorTickmarkType();
    }

    public final void setMajorTickmarkType(TickmarkType TICKMARK_TYPE) {
        this.styleModel.setMajorTickmarkType(TICKMARK_TYPE);
    }

    public final ObjectProperty<TickmarkType> majorTickmarkTypeProperty() {
        return this.styleModel.majorTickmarkTypeProperty();
    }

    public final Color getMajorTickmarkColor() {
        return this.styleModel.getMajorTickmarkColor();
    }

    public final void setMajorTickmarkColor(Color MAJOR_TICKMARK_COLOR) {
        this.styleModel.setMajorTickmarkColor(MAJOR_TICKMARK_COLOR);
    }

    public final ObjectProperty<Color> majorTickmarkColorProperty() {
        return this.styleModel.majorTickmarkColorProperty();
    }

    public final boolean isMinorTicksVisible() {
        return this.styleModel.isMinorTicksVisible();
    }

    public final void setMinorTicksVisible(boolean MINOR_TICKS_VISIBLE) {
        this.styleModel.setMinorTicksVisible(MINOR_TICKS_VISIBLE);
    }

    public final BooleanProperty minorTicksVisibleProperty() {
        return this.styleModel.minorTicksVisibleProperty();
    }

    public final Color getMinorTickmarkColor() {
        return this.styleModel.getMinorTickmarkColor();
    }

    public final void setMinorTickmarkColor(Color MINOR_TICKMARK_COLOR) {
        this.styleModel.setMinorTickmarkColor(MINOR_TICKMARK_COLOR);
    }

    public final ObjectProperty<Color> minorTickmarkColorProperty() {
        return this.styleModel.minorTickmarkColorProperty();
    }

    public final boolean isTickLabelsVisible() {
        return this.styleModel.isTickLabelsVisible();
    }

    public final void setTickLabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.styleModel.setTickLabelsVisible(TICKLABELS_VISIBLE);
    }

    public final BooleanProperty ticklabelsVisibleProperty() {
        return this.styleModel.ticklabelsVisibleProperty();
    }

    public final TicklabelOrientation getTickLabelOrientation() {
        return this.styleModel.getTickLabelOrientation();
    }

    public final void setTickLabelOrientation(TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.styleModel.setTickLabelOrientation(TICKLABEL_ORIENTATION);
    }

    public final ObjectProperty<TicklabelOrientation> tickLabelOrientationProperty() {
        return this.styleModel.tickLabelOrientationProperty();
    }

    public final NumberFormat getTickLabelNumberFormat() {
        return this.styleModel.getTickLabelNumberFormat();
    }

    public final void setTickLabelNumberFormat(NumberFormat TICKLABEL_NUMBER_FORMAT) {
        this.styleModel.setTickLabelNumberFormat(TICKLABEL_NUMBER_FORMAT);
    }

    public final ObjectProperty<NumberFormat> tickLabelNumberFormatProperty() {
        return this.styleModel.tickLabelNumberFormatProperty();
    }

    public final Point2D getTickmarksOffset() {
        return this.styleModel.getTickmarksOffset();
    }

    public final void setTickmarksOffset(Point2D TICKMARKS_OFFSET) {
        this.styleModel.setTickmarksOffset(TICKMARKS_OFFSET);
    }

    public final ObjectProperty<Point2D> tickmarksOffsetProperty() {
        return this.styleModel.tickmarksOffsetProperty();
    }

    public final boolean isTickmarkGlowEnabled() {
        return this.styleModel.isTickmarkGlowEnabled();
    }

    public final void setTickmarkGlowEnabled(boolean TICKMARK_GLOW_ENABLED) {
        this.styleModel.setTickmarkGlowEnabled(TICKMARK_GLOW_ENABLED);
    }

    public final BooleanProperty tickmarkGlowEnabledProperty() {
        return this.styleModel.tickmarkGlowEnabledProperty();
    }

    public final Color getTickmarkGlowColor() {
        return this.styleModel.getTickmarkGlowColor();
    }

    public final void setTickmarkGlowColor(Color TICKMARK_GLOW_COLOR) {
        this.styleModel.setTickmarkGlowColor(TICKMARK_GLOW_COLOR);
    }

    public final ObjectProperty<Color> tickmarkGlowProperty() {
        return this.styleModel.tickmarkGlowColorProperty();
    }

    public final int getMaxNoOfMajorTicks() {
        return this.gaugeModel.getMaxNoOfMajorTicks();
    }

    public final void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.gaugeModel.setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
    }

    public final IntegerProperty maxNoOfMajorTicksProperty() {
        return this.gaugeModel.maxNoOfMajorTicksProperty();
    }

    public final int getMaxNoOfMinorTicks() {
        return this.gaugeModel.getMaxNoOfMinorTicks();
    }

    public final void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.gaugeModel.setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
    }

    public final IntegerProperty maxNoOfMinorTicksProperty() {
        return this.gaugeModel.maxNoOfMinorTicksProperty();
    }

    public final int getMajorTickSpacing() {
        return this.gaugeModel.getMajorTickSpacing();
    }

    public final void setMajorTickSpacing(int MAJOR_TICKSPACING) {
        this.gaugeModel.setMajorTickSpacing(MAJOR_TICKSPACING);
    }

    public final IntegerProperty majorTickSpacingProperty() {
        return this.gaugeModel.majorTickSpacingProperty();
    }

    public final int getMinorTickSpacing() {
        return this.gaugeModel.getMinorTickSpacing();
    }

    public final void setMinorTickSpacing(int MINOR_TICKSPACING) {
        this.gaugeModel.setMinorTickSpacing(MINOR_TICKSPACING);
    }

    public final IntegerProperty minorTickSpacingProperty() {
        return this.gaugeModel.minorTickSpacingProperty();
    }

    public final boolean isNiceScaling() {
        return this.gaugeModel.isNiceScaling();
    }

    public final void setNiceScaling(boolean NICE_SCALING) {
        this.gaugeModel.setNiceScaling(NICE_SCALING);
        this.recalcRange();
    }

    public final BooleanProperty niceScalingProperty() {
        return this.gaugeModel.niceScalingProperty();
    }

    public final List<Section> getSections() {
        return this.gaugeModel.getSections();
    }

    public final void setSections(Section ... SECTION_ARRAY) {
        this.gaugeModel.setSections(SECTION_ARRAY);
    }

    public final void setSections(List<Section> SECTIONS) {
        this.gaugeModel.setSections(SECTIONS);
    }

    public final void addSection(Section SECTION) {
        this.gaugeModel.addSection(SECTION);
    }

    public final void removeSection(Section SECTION) {
        this.gaugeModel.removeSection(SECTION);
    }

    public final void resetSections() {
        this.gaugeModel.resetSections();
    }

    public final boolean isSectionsVisible() {
        return this.styleModel.isSectionsVisible();
    }

    public final void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.styleModel.setSectionsVisible(SECTIONS_VISIBLE);
    }

    public final BooleanProperty sectionsVisibleProperty() {
        return this.styleModel.sectionsVisibleProperty();
    }

    public final boolean isExpandedSections() {
        return this.styleModel.isExpandedSections();
    }

    public final void setExpandedSections(boolean EXPANDED_SECTIONS) {
        this.styleModel.setExpandedSections(EXPANDED_SECTIONS);
    }

    public final BooleanProperty expandedSectionsProperty() {
        return this.styleModel.expandedSectionsProperty();
    }

    public final boolean isSectionsHighlighting() {
        return this.styleModel.isSectionsHighlighting();
    }

    public final void setSectionsHighlighting(boolean SECTIONS_HIGHLIGHTING) {
        this.styleModel.setSectionsHighlighting(SECTIONS_HIGHLIGHTING);
    }

    public final BooleanProperty sectionsHighlightingProperty() {
        return this.styleModel.sectionsHighlightingProperty();
    }

    public final boolean isShowSectionTickmarksOnly() {
        return this.styleModel.isShowSectionTickmarksOnly();
    }

    public final void setShowSectionTickmarksOnly(boolean SHOW_SECTION_TICKMARKS_ONLY) {
        this.styleModel.setShowSectionTickmarksOnly(SHOW_SECTION_TICKMARKS_ONLY);
    }

    public final BooleanProperty showSectionTickmarksOnlyProperty() {
        return this.styleModel.showSectionTickmarksOnlyProperty();
    }

    public final List<Section> getAreas() {
        return this.gaugeModel.getAreas();
    }

    public final void setAreas(Section ... AREA_ARRAY) {
        this.gaugeModel.setAreas(AREA_ARRAY);
    }

    public final void setAreas(List<Section> AREAS) {
        this.gaugeModel.setAreas(AREAS);
    }

    public final void addArea(Section AREA) {
        this.gaugeModel.addArea(AREA);
    }

    public final void removeArea(Section AREA) {
        this.gaugeModel.removeArea(AREA);
    }

    public final void resetAreas() {
        this.gaugeModel.resetAreas();
    }

    public final boolean isAreasVisible() {
        return this.styleModel.isAreasVisible();
    }

    public final void setAreasVisible(boolean AREAS_VISIBLE) {
        this.styleModel.setAreasVisible(AREAS_VISIBLE);
    }

    public final BooleanProperty areasVisibleProperty() {
        return this.styleModel.areasVisibleProperty();
    }

    public final boolean isAreasHighlighting() {
        return this.styleModel.isAreasHighlighting();
    }

    public final void setAreasHighlighting(boolean AREAS_HIGHLIGHTING) {
        this.styleModel.setAreasHighlighting(AREAS_HIGHLIGHTING);
    }

    public final BooleanProperty areasHighlightingProperty() {
        return this.styleModel.areasHighlightingProperty();
    }

    public final List<Section> getTickMarkSections() {
        return this.gaugeModel.getTickMarkSections();
    }

    public final void setTickMarkSections(Section ... TICK_MARK_SECTION_ARRAY) {
        this.gaugeModel.setTickMarkSections(TICK_MARK_SECTION_ARRAY);
    }

    public final void setTickMarkSections(List<Section> TICK_MARK_SECTIONS) {
        this.gaugeModel.setTickMarkSections(TICK_MARK_SECTIONS);
    }

    public final void addTickMarkSection(Section TICK_MARK_SECTION) {
        this.gaugeModel.addTickMarkSection(TICK_MARK_SECTION);
    }

    public final void removeTickMarkSection(Section TICK_MARK_SECTION) {
        this.gaugeModel.removeTickMarkSection(TICK_MARK_SECTION);
    }

    public final void resetTickMarkSections() {
        this.gaugeModel.resetTickMarkSections();
    }

    public final List<Marker> getMarkers() {
        return this.gaugeModel.getMarkers();
    }

    public final void setMarkers(Marker ... MARKER_ARRAY) {
        this.gaugeModel.setMarkers(MARKER_ARRAY);
    }

    public final void setMarkers(List<Marker> MARKERS) {
        this.gaugeModel.setMarkers(MARKERS);
    }

    public final void addMarker(Marker MARKER) {
        this.gaugeModel.addMarker(MARKER);
    }

    public final void removeMarker(Marker MARKER) {
        this.gaugeModel.removeMarker(MARKER);
    }

    public final void resetMarkers() {
        this.gaugeModel.resetMarkers();
    }

    public final boolean isMarkersVisible() {
        return this.styleModel.isMarkersVisible();
    }

    public final void setMarkersVisible(boolean INDICATORS_VISIBLE) {
        this.styleModel.setMarkersVisible(INDICATORS_VISIBLE);
    }

    public final BooleanProperty markersVisibleProperty() {
        return this.styleModel.markersVisibleProperty();
    }

    public final Color getTextureColor() {
        return this.styleModel.getTextureColor();
    }

    public final String getTextureColorString() {
        return this.styleModel.getTextureColorString();
    }

    public final void setTextureColor(Color TEXTURE_COLOR) {
        this.styleModel.setTextureColor(TEXTURE_COLOR);
    }

    public final ObjectProperty<Color> textureColorProperty() {
        return this.styleModel.textureColorProperty();
    }

    public final Color getSimpleGradientBaseColor() {
        return this.styleModel.getSimpleGradientBaseColor();
    }

    public final String getSimpleGradientBaseColorString() {
        return this.styleModel.getSimpleGradientBaseColorString();
    }

    public final void setSimpleGradientBaseColor(Color SIMPLE_GRADIENT_BASE_COLOR) {
        this.styleModel.setSimpleGradientBaseColor(SIMPLE_GRADIENT_BASE_COLOR);
    }

    public final ObjectProperty<Color> simpleGradientBaseColorProperty() {
        return this.styleModel.simpleGradientBaseColorProperty();
    }

    public final boolean isTitleVisible() {
        return this.styleModel.isTitleVisible();
    }

    public final void setTitleVisible(boolean TITLE_VISIBLE) {
        this.styleModel.setTitleVisible(TITLE_VISIBLE);
    }

    public final BooleanProperty titleVisibleProperty() {
        return this.styleModel.titleVisibleProperty();
    }

    public final boolean isUnitVisible() {
        return this.styleModel.isUnitVisible();
    }

    public final void setUnitVisible(boolean UNIT_VISIBLE) {
        this.styleModel.setUnitVisible(UNIT_VISIBLE);
    }

    public final BooleanProperty unitVisibleProperty() {
        return this.styleModel.unitVisibleProperty();
    }

    public final Trend getTrend() {
        return this.gaugeModel.getTrend();
    }

    public final void setTrend(Trend TREND) {
        this.gaugeModel.setTrend(TREND);
    }

    public final ObjectProperty<Trend> trendProperty() {
        return this.gaugeModel.trendProperty();
    }

    public final boolean isTrendVisible() {
        return this.styleModel.isTrendVisible();
    }

    public final void setTrendVisible(boolean TREND_VISIBLE) {
        this.styleModel.setTrendVisible(TREND_VISIBLE);
    }

    public final BooleanProperty trendVisibleProperty() {
        return this.styleModel.trendVisibleProperty();
    }

    public final Color getTrendUpColor() {
        return this.styleModel.getTrendUpColor();
    }

    public final void setTrendUpColor(Color TREND_UP_COLOR) {
        this.styleModel.setTrendUpColor(TREND_UP_COLOR);
    }

    public final ObjectProperty<Color> trendUpColorProperty() {
        return this.styleModel.trendUpColorProperty();
    }

    public final Color getTrendSteadyColor() {
        return this.styleModel.getTrendSteadyColor();
    }

    public final void setTrendSteadyColor(Color TREND_STEADY_COLOR) {
        this.styleModel.setTrendSteadyColor(TREND_STEADY_COLOR);
    }

    public final ObjectProperty<Color> trendSteadyColorProperty() {
        return this.styleModel.trendSteadyColorProperty();
    }

    public final Color getTrendDownColor() {
        return this.styleModel.getTrendDownColor();
    }

    public final void setTrendDownColor(Color TREND_DOWN_COLOR) {
        this.styleModel.setTrendDownColor(TREND_DOWN_COLOR);
    }

    public final ObjectProperty<Color> trendDownColorProperty() {
        return this.styleModel.trendDownColorProperty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Trend {
        UP("up"),
        STEADY("steady"),
        DOWN("down"),
        UNKNOWN("unknown");

        public final ArrayList<int[]> ledMatrix = new ArrayList(9);

        private Trend(String TYPE) {
            if (TYPE == "up") {
                this.ledMatrix.add(new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 1, 1, 1, 1, 1, 0, 1, 1});
                this.ledMatrix.add(new int[]{1, 1, 1, 1, 1, 0, 0, 0, 1});
                this.ledMatrix.add(new int[]{0, 1, 1, 1, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 1, 0, 0, 0, 0, 0, 0});
            }
            if (TYPE == "steady") {
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0});
                this.ledMatrix.add(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0});
                this.ledMatrix.add(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 0, 0, 0, 0});
            }
            if (TYPE == "down") {
                this.ledMatrix.add(new int[]{0, 0, 1, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 1, 1, 1, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{1, 1, 1, 1, 1, 0, 0, 0, 1});
                this.ledMatrix.add(new int[]{0, 1, 1, 1, 1, 1, 0, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1});
                this.ledMatrix.add(new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1});
            }
            if (TYPE == "unknown") {
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.ledMatrix.add(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TicklabelOrientation {
        NORMAL,
        HORIZONTAL,
        TANGENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TickmarkType {
        LINE,
        TRIANGLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThresholdColor {
        RED("-fx-red;"),
        GREEN("-fx-green;"),
        BLUE("-fx-blue;"),
        ORANGE("-fx-orange;"),
        YELLOW("-fx-yellow;"),
        CYAN("-fx-cyan;"),
        MAGENTA("-fx-magenta;"),
        WHITE("-fx-white;"),
        GRAY("-fx-gray;"),
        BLACK("-fx-black;"),
        RAITH("-fx-raith;"),
        GREEN_LCD("-fx-green-lcd;"),
        JUG_GREEN("-fx-jug-green;"),
        CUSTOM("-fx-custom;");

        public final String CSS;

        private ThresholdColor(String CSS_COLOR) {
            this.CSS = "-fx-threshold: " + CSS_COLOR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointerType {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4,
        TYPE5,
        TYPE6,
        TYPE7,
        TYPE8,
        TYPE9,
        TYPE10,
        TYPE11,
        TYPE12,
        TYPE13,
        TYPE14,
        TYPE15,
        TYPE16;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberSystem {
        DECIMAL("dec"),
        HEXADECIMAL("hex"),
        OCTAL("oct");

        private String text;

        private NumberSystem(String TEXT) {
            this.text = TEXT;
        }

        public String toString() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberFormat {
        AUTO("0"),
        STANDARD("0"),
        FRACTIONAL("0.0#"),
        SCIENTIFIC("0.##E0"),
        PERCENTAGE("##0.0%");

        private final DecimalFormat DF;

        private NumberFormat(String FORMAT_STRING) {
            Locale.setDefault(new Locale("en", "US"));
            this.DF = new DecimalFormat(FORMAT_STRING);
        }

        public String format(Number NUMBER) {
            return this.DF.format(NUMBER);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnobDesign {
        STANDARD,
        PLAIN,
        METAL,
        BIG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnobColor {
        BLACK,
        BRASS,
        SILVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RadialRange {
        RADIAL_300(300.0, -150.0, 240.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 150.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_270(270.0, -180.0, 270.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 180.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_180(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 90.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_180N(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 90.0, new Point2D(0.6, 0.35), new Point2D(0.3, 0.35), 1.0, 0.38),
        RADIAL_180S(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 0.0, new Point2D(0.6, 0.2), new Point2D(0.3, 0.2), -1.0, 0.38),
        RADIAL_90(90.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 91.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_90N(90.0, 315.0, 225.0, new Rectangle(0.55, 0.52, 0.55, 0.12), 45.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.5),
        RADIAL_90W(90.0, 225.0, 45.0, new Rectangle(0.2, 0.58, 0.45, 0.12), 45.0, new Point2D(0.12, 0.35), new Point2D(0.12, 0.55), 1.0, 0.5),
        RADIAL_90S(90.0, -135.0, 45.0, new Rectangle(0.55, 0.36, 0.55, 0.12), 45.0, new Point2D(0.6, 0.5), new Point2D(0.3, 0.5), -1.0, 0.5),
        RADIAL_90E(90.0, 135.0, 225.0, new Rectangle(0.2, 0.58, 0.45, 0.12), 45.0, new Point2D(0.78, 0.35), new Point2D(0.78, 0.55), -1.0, 0.5);

        public final double ANGLE_RANGE;
        public final double ROTATION_OFFSET;
        public final double SECTIONS_OFFSET;
        public final Rectangle LCD_FACTORS;
        public final double TICKLABEL_ORIENATION_CHANGE_ANGLE;
        public final Point2D LED_POSITION;
        public final Point2D USER_LED_POSITION;
        public final double ANGLE_STEP_SIGN;
        public final double RADIUS_FACTOR;

        private RadialRange(double ANGLE_RANGE, double ROTATION_OFFSET, double SECTIONS_OFFSET, Rectangle LCD_FACTORS, double TICKLABEL_ORIENATION_CHANGE_ANGLE, Point2D LED_POSITION, Point2D USER_LED_POSITION, double ANGLE_STEP_SIGN, double RADIUS_FACTOR) {
            this.ANGLE_RANGE = ANGLE_RANGE;
            this.ROTATION_OFFSET = ROTATION_OFFSET;
            this.SECTIONS_OFFSET = SECTIONS_OFFSET;
            this.LCD_FACTORS = LCD_FACTORS;
            this.TICKLABEL_ORIENATION_CHANGE_ANGLE = TICKLABEL_ORIENATION_CHANGE_ANGLE;
            this.LED_POSITION = LED_POSITION;
            this.USER_LED_POSITION = USER_LED_POSITION;
            this.ANGLE_STEP_SIGN = ANGLE_STEP_SIGN;
            this.RADIUS_FACTOR = RADIUS_FACTOR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameDesign {
        METAL("framedesign-metal"),
        GLOSSY_METAL("framedesign-glossymetal"),
        DARK_GLOSSY("framedesign-darkglossy"),
        BRASS("framedesign-brass"),
        STEEL("framedesign-steel"),
        GOLD("framedesign-gold"),
        ANTHRACITE("framedesign-anthracite"),
        TILTED_GRAY("framedesign-tiltedgray"),
        TILTED_BLACK("framedesign-tiltedblack"),
        CUSTOM("framedesign-custom");

        public final String CSS;

        private FrameDesign(String CSS) {
            this.CSS = CSS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackgroundDesign {
        DARK_GRAY("backgrounddesign-darkgray"),
        SATIN_GRAY("backgrounddesign-satingray"),
        LIGHT_GRAY("backgrounddesign-lightgray"),
        WHITE("backgrounddesign-white"),
        BLACK("backgrounddesign-black"),
        BEIGE("backgrounddesign-beige"),
        BROWN("backgrounddesign-brown"),
        RED("backgrounddesign-red"),
        GREEN("backgrounddesign-green"),
        BLUE("backgrounddesign-blue"),
        ANTHRACITE("backgrounddesign-anthracite"),
        MUD("backgrounddesign-mud"),
        SIMPLE_GRADIENT("backgrounddesign-simplegradient"),
        TRANSPARENT("backgrounddesign-transparent"),
        CUSTOM("backgrounddesign-custom");

        public final String CSS_BACKGROUND;
        public final String CSS_TEXT;

        private BackgroundDesign(String CSS_BACKGROUND) {
            this.CSS_BACKGROUND = CSS_BACKGROUND;
            this.CSS_TEXT = CSS_BACKGROUND + "-text";
        }
    }
}

