/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Battery
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "battery";
    private DoubleProperty chargingLevel = new SimpleDoubleProperty(0.0);
    private BooleanProperty charging = new SimpleBooleanProperty(false);
    private ObjectProperty<ChargeCondition> chargeCondition = new SimpleObjectProperty((Object)ChargeCondition.EMPTY);
    private ObjectProperty<ChargeIndicator> chargeIndicator = new SimpleObjectProperty((Object)ChargeIndicator.PLUG);
    private ObjectProperty<Stop[]> levelColors = new SimpleObjectProperty((Object)new Stop[]{new Stop(0.0, Color.RED), new Stop(0.55, Color.YELLOW), new Stop(1.0, Color.hsb((double)102.0, (double)1.0, (double)0.85))});

    public Battery() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final double getChargingLevel() {
        return this.chargingLevel.get();
    }

    public final void setChargingLevel(double CHARGING_LEVEL) {
        this.chargingLevel.set(CHARGING_LEVEL < 0.0 ? 0.0 : (CHARGING_LEVEL > 1.0 ? 1.0 : CHARGING_LEVEL));
    }

    public final DoubleProperty chargingLevelProperty() {
        return this.chargingLevel;
    }

    public final boolean isCharging() {
        return this.charging.get();
    }

    public final void setCharging(boolean CHARGING) {
        this.charging.set(CHARGING);
    }

    public final ChargeCondition getChargeCondition() {
        return (ChargeCondition)((Object)this.chargeCondition.get());
    }

    public final void setChargeCondition(ChargeCondition CHARGE_CONDITION) {
        this.chargeCondition.set((Object)CHARGE_CONDITION);
    }

    public final ObjectProperty<ChargeCondition> chargeConditionProperty() {
        return this.chargeCondition;
    }

    public final ChargeIndicator getChargeIndicator() {
        return (ChargeIndicator)((Object)this.chargeIndicator.get());
    }

    public final void setChargeIndicator(ChargeIndicator CHARGE_INDICATOR) {
        this.chargeIndicator.set((Object)CHARGE_INDICATOR);
    }

    public final ObjectProperty<ChargeIndicator> chargeIndicatorProperty() {
        return this.chargeIndicator;
    }

    public final BooleanProperty chargingProperty() {
        return this.charging;
    }

    public final Stop[] getLevelColors() {
        return (Stop[])this.levelColors.get();
    }

    public final void setLevelColors(Stop[] LEVEL_COLORS) {
        if (LEVEL_COLORS.length == 0) {
            this.levelColors.set((Object)new Stop[]{new Stop(0.0, Color.RED), new Stop(0.55, Color.YELLOW), new Stop(1.0, Color.hsb((double)102.0, (double)1.0, (double)0.85))});
        } else {
            this.levelColors.set((Object)LEVEL_COLORS);
        }
    }

    public final ObjectProperty<Stop[]> levelColorsProperty() {
        return this.levelColors;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChargeIndicator {
        PLUG,
        FLASH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChargeCondition {
        EMPTY,
        PARTLY_CHARGED,
        CHARGED;

    }
}

