/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigInteger;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerBigIntegerList
extends AbstractList<BigInteger> {
    private BigInteger from;
    private int size;
    private BigInteger step;

    public SpinnerBigIntegerList() {
        this(BigInteger.valueOf(-1073741824L).add(BigInteger.ONE), BigInteger.valueOf(0x3FFFFFFFL), BigInteger.ONE);
    }

    public SpinnerBigIntegerList(BigInteger from, BigInteger to) {
        this(from, to, from.compareTo(to) > 0 ? BigInteger.valueOf(-1L) : BigInteger.ONE);
    }

    public SpinnerBigIntegerList(BigInteger from, BigInteger to, BigInteger step) {
        this.from = from;
        this.size = to.subtract(from).divide(step).add(BigInteger.ONE).intValue();
        if (this.size < 0) {
            throw new IllegalArgumentException("This results in a negative size: " + from + ", " + to + "," + step);
        }
        this.step = step;
    }

    @Override
    public BigInteger get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be < 0: " + index);
        }
        BigInteger lValue = this.from.add(BigInteger.valueOf(index).multiply(this.step));
        return lValue;
    }

    @Override
    public int indexOf(Object o) {
        BigInteger lValue = (BigInteger)o;
        BigInteger lIndex = lValue.subtract(this.from).divide(this.step);
        return lIndex.intValue();
    }

    @Override
    public int size() {
        return this.size;
    }
}

