/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.util.Callback;
import javafx.util.StringConverter;
import jfxtras.labs.scene.control.SpinnerIntegerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spinner<T>
extends Control {
    private ListChangeListener<T> listChangeListener = new ListChangeListener<T>(){

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            int lIndex = Spinner.this.getIndex();
            if (lIndex >= Spinner.this.getItems().size()) {
                lIndex = Spinner.this.getItems().size() - 1;
                Spinner.this.setIndex(lIndex);
                return;
            }
            Spinner.this.valueObjectProperty.setValue(Spinner.this.getItems().get(lIndex));
        }
    };
    private final ObjectProperty<T> valueObjectProperty = new SimpleObjectProperty((Object)this, "value", null);
    private final ObjectProperty<Integer> indexObjectProperty = new SimpleObjectProperty((Object)this, "index", null);
    private final ObjectProperty<Boolean> cyclicObjectProperty = new SimpleObjectProperty((Object)this, "cyclic", (Object)false);
    private final ObjectProperty<Boolean> editableObjectProperty = new SimpleObjectProperty((Object)this, "editable", (Object)false);
    private final ObjectProperty<ObservableList<T>> itemsObjectProperty = new SimpleObjectProperty((Object)this, "items", null);
    private final ObjectProperty<Callback<Spinner<T>, Node>> cellFactoryObjectProperty = new SimpleObjectProperty((Object)this, "cellFactory", (Object)new DefaultCellFactory());
    private final ObjectProperty<StringConverter<T>> stringConverterObjectProperty = new SimpleObjectProperty((Object)this, "stringConverter", (Object)new DefaultStringConverter());
    private final ObjectProperty<ArrowDirection> arrowDirectionObjectProperty = new SimpleObjectProperty((Object)this, "arrowDirection", (Object)ArrowDirection.HORIZONTAL);
    private final ObjectProperty<ArrowPosition> arrowPositionObjectProperty = new SimpleObjectProperty((Object)this, "arrowPosition", (Object)ArrowPosition.TRAILING);
    private final ObjectProperty<Pos> alignmentObjectProperty = new SimpleObjectProperty((Object)this, "alignment", (Object)Pos.CENTER_LEFT);
    private final ObjectProperty<Callback<T, Integer>> addCallbackObjectProperty = new SimpleObjectProperty((Object)this, "addCallback", null);
    private final ObjectProperty<EventHandler<CycleEvent>> iOnCycleObjectProperty = new SimpleObjectProperty(null);
    public static final String ONCYCLE_PROPERTY_ID = "onCycle";

    public Spinner() {
        this.construct();
    }

    public Spinner(ObservableList<T> items) {
        this.construct();
        this.setItems(items);
        this.first();
    }

    public Spinner(ObservableList<T> items, T startValue) {
        this.construct();
        this.setItems(items);
        this.setValue(startValue);
    }

    public Spinner(List<T> list) {
        this(FXCollections.observableList(list));
    }

    public Spinner(T ... list) {
        this(Arrays.asList(list));
    }

    public Spinner(int from, int to) {
        this(new SpinnerIntegerList(from, to));
    }

    public Spinner(int from, int to, int step) {
        this(new SpinnerIntegerList(from, to, step));
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
        this.valueObjectProperty.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> property, T oldValue, T newValue) {
                int lIdx = Spinner.this.getItems().indexOf(newValue);
                if (!Spinner.equals(Spinner.this.indexObjectProperty.getValue(), lIdx)) {
                    Spinner.this.indexObjectProperty.setValue((Object)lIdx);
                }
            }
        });
        this.indexObjectProperty.addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> property, Integer oldIndex, Integer newIndex) {
                Object lValue;
                Object object = lValue = newIndex < 0 ? null : Spinner.this.getItems().get(newIndex.intValue());
                if (!Spinner.equals(Spinner.this.valueObjectProperty.getValue(), lValue)) {
                    Spinner.this.valueObjectProperty.setValue(lValue);
                }
            }
        });
        this.itemsObjectProperty.addListener(new ChangeListener<ObservableList<T>>(){

            public void changed(ObservableValue<? extends ObservableList<T>> property, ObservableList<T> oldList, ObservableList<T> newList) {
                if (oldList != null) {
                    oldList.removeListener(Spinner.this.listChangeListener);
                }
                if (newList != null) {
                    newList.addListener(Spinner.this.listChangeListener);
                }
            }
        });
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueObjectProperty;
    }

    public T getValue() {
        return (T)this.valueObjectProperty.getValue();
    }

    public void setValue(T value) {
        this.valueObjectProperty.setValue(value);
    }

    public Spinner<T> withValue(T value) {
        this.setValue(value);
        return this;
    }

    public ObjectProperty<Integer> indexProperty() {
        return this.indexObjectProperty;
    }

    public Integer getIndex() {
        return (Integer)this.indexObjectProperty.getValue();
    }

    public void setIndex(Integer value) {
        this.indexObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withIndex(Integer value) {
        this.setIndex(value);
        return this;
    }

    public ObjectProperty<Boolean> cyclicProperty() {
        return this.cyclicObjectProperty;
    }

    public Boolean isCyclic() {
        return (Boolean)this.cyclicObjectProperty.getValue();
    }

    public void setCyclic(Boolean value) {
        this.cyclicObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withCyclic(Boolean value) {
        this.setCyclic(value);
        return this;
    }

    public ObjectProperty<Boolean> editableProperty() {
        return this.editableObjectProperty;
    }

    public Boolean isEditable() {
        return (Boolean)this.editableObjectProperty.getValue();
    }

    public void setEditable(Boolean value) {
        this.editableObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withEditable(Boolean value) {
        this.setEditable(value);
        return this;
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.itemsObjectProperty;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.itemsObjectProperty.getValue();
    }

    public void setItems(ObservableList<T> value) {
        this.itemsObjectProperty.setValue(value);
    }

    public Spinner<T> withItems(ObservableList<T> value) {
        this.setItems(value);
        return this;
    }

    public ObjectProperty<Callback<Spinner<T>, Node>> cellFactoryProperty() {
        return this.cellFactoryObjectProperty;
    }

    public Callback<Spinner<T>, Node> getCellFactory() {
        return (Callback)this.cellFactoryObjectProperty.getValue();
    }

    public void setCellFactory(Callback<Spinner<T>, Node> value) {
        this.cellFactoryObjectProperty.setValue(value);
    }

    public Spinner<T> withCellFactory(Callback<Spinner<T>, Node> value) {
        this.setCellFactory(value);
        return this;
    }

    public ObjectProperty<StringConverter<T>> stringConverterProperty() {
        return this.stringConverterObjectProperty;
    }

    public StringConverter<T> getStringConverter() {
        return (StringConverter)this.stringConverterObjectProperty.getValue();
    }

    public void setStringConverter(StringConverter<T> value) {
        this.stringConverterObjectProperty.setValue(value);
    }

    public Spinner<T> withStringConverter(StringConverter<T> value) {
        this.setStringConverter(value);
        return this;
    }

    public ObjectProperty<ArrowDirection> arrowDirectionProperty() {
        return this.arrowDirectionObjectProperty;
    }

    public ArrowDirection getArrowDirection() {
        return (ArrowDirection)((Object)this.arrowDirectionObjectProperty.getValue());
    }

    public void setArrowDirection(ArrowDirection value) {
        this.arrowDirectionObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withArrowDirection(ArrowDirection value) {
        this.setArrowDirection(value);
        return this;
    }

    public ObjectProperty<ArrowPosition> arrowPositionProperty() {
        return this.arrowPositionObjectProperty;
    }

    public ArrowPosition getArrowPosition() {
        return (ArrowPosition)((Object)this.arrowPositionObjectProperty.getValue());
    }

    public void setArrowPosition(ArrowPosition value) {
        this.arrowPositionObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withArrowPosition(ArrowPosition value) {
        this.setArrowPosition(value);
        return this;
    }

    public ObjectProperty<Pos> alignmentProperty() {
        return this.alignmentObjectProperty;
    }

    public Pos isAlignment() {
        return (Pos)this.alignmentObjectProperty.getValue();
    }

    public void setAlignment(Pos value) {
        this.alignmentObjectProperty.setValue((Object)value);
    }

    public Spinner<T> withAlignment(Pos value) {
        this.setAlignment(value);
        return this;
    }

    public ObjectProperty<Callback<T, Integer>> addCallbackProperty() {
        return this.addCallbackObjectProperty;
    }

    public Callback<T, Integer> getAddCallback() {
        return (Callback)this.addCallbackObjectProperty.getValue();
    }

    public void setAddCallback(Callback<T, Integer> value) {
        this.addCallbackObjectProperty.setValue(value);
    }

    public Spinner<T> withAddCallback(Callback<T, Integer> value) {
        this.setAddCallback(value);
        return this;
    }

    public ObjectProperty<EventHandler<CycleEvent>> onCycleProperty() {
        return this.iOnCycleObjectProperty;
    }

    public EventHandler<CycleEvent> getOnCycle() {
        return (EventHandler)this.iOnCycleObjectProperty.getValue();
    }

    public void setOnCycle(EventHandler<CycleEvent> value) {
        this.iOnCycleObjectProperty.setValue(value);
    }

    public Spinner<T> withOnCycle(EventHandler<CycleEvent> value) {
        this.setOnCycle(value);
        return this;
    }

    public void fireCycleEvent(CycleDirection cycleDirection) {
        EventHandler<CycleEvent> lCycleEventHandler = this.getOnCycle();
        if (lCycleEventHandler != null) {
            CycleEvent lCycleEvent = new CycleEvent();
            lCycleEvent.cycleDirection = cycleDirection;
            lCycleEventHandler.handle((Event)lCycleEvent);
        }
    }

    public void first() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        this.indexObjectProperty.setValue((Object)0);
    }

    public void decrement() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        int lOldIdx = (Integer)this.indexObjectProperty.getValue();
        int lIdx = lOldIdx - 1;
        if (lIdx < 0) {
            if (this.isCyclic() != null && !this.isCyclic().booleanValue()) {
                return;
            }
            lIdx = this.getItems().size() - 1;
            this.fireCycleEvent(CycleDirection.BOTTOM_TO_TOP);
        }
        this.indexObjectProperty.setValue((Object)lIdx);
    }

    public void increment() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        int lOldIdx = (Integer)this.indexObjectProperty.getValue();
        int lIdx = lOldIdx + 1;
        if (lIdx >= this.getItems().size()) {
            if (this.isCyclic() != null && !this.isCyclic().booleanValue()) {
                return;
            }
            lIdx = 0;
            this.fireCycleEvent(CycleDirection.TOP_TO_BOTTOM);
        }
        this.indexObjectProperty.setValue((Object)lIdx);
    }

    public void last() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        this.indexObjectProperty.setValue((Object)(this.getItems().size() - 1));
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CycleDirection {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }

    public static class CycleEvent
    extends Event {
        private Object oldIdx;
        private Object newIdx;
        CycleDirection cycleDirection;

        public CycleEvent() {
            super(new EventType());
        }

        public CycleEvent(Object source, EventTarget target) {
            super(source, target, new EventType());
        }

        public Object getOldIdx() {
            return this.oldIdx;
        }

        public Object getNewIdx() {
            return this.newIdx;
        }

        public boolean cycledDown() {
            return this.cycleDirection == CycleDirection.TOP_TO_BOTTOM;
        }

        public boolean cycledUp() {
            return this.cycleDirection == CycleDirection.BOTTOM_TO_TOP;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultCellFactory
    implements Callback<Spinner<T>, Node> {
        private Label label = null;

        DefaultCellFactory() {
        }

        public Node call(Spinner<T> spinner) {
            Object lValue = spinner.getValue();
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setText(lValue == null ? "" : Spinner.this.getStringConverter().toString(lValue));
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultStringConverter
    extends StringConverter<T> {
        DefaultStringConverter() {
        }

        public T fromString(String string) {
            throw new IllegalStateException("not implemented");
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArrowPosition {
        LEADING,
        TRAILING,
        SPLIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArrowDirection {
        VERTICAL,
        HORIZONTAL;

    }
}

