/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTextField
extends TextField {
    private final NumberFormat nf;
    private ObjectProperty<BigDecimal> number = new SimpleObjectProperty();

    public final BigDecimal getNumber() {
        return (BigDecimal)this.number.get();
    }

    public final void setNumber(BigDecimal value) {
        this.number.set((Object)value);
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.number;
    }

    public NumberTextField() {
        this(BigDecimal.ZERO);
    }

    public NumberTextField(BigDecimal value) {
        this(value, NumberFormat.getInstance());
        this.initHandlers();
    }

    public NumberTextField(BigDecimal value, NumberFormat nf) {
        this.nf = nf;
        this.initHandlers();
        this.setNumber(value);
    }

    private void initHandlers() {
        this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                NumberTextField.this.parseAndFormatInput();
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    NumberTextField.this.parseAndFormatInput();
                }
            }
        });
        this.numberProperty().addListener((ChangeListener)new ChangeListener<BigDecimal>(){

            public void changed(ObservableValue<? extends BigDecimal> obserable, BigDecimal oldValue, BigDecimal newValue) {
                NumberTextField.this.setText(NumberTextField.this.nf.format(newValue));
            }
        });
    }

    private void parseAndFormatInput() {
        try {
            String input = this.getText();
            if (input == null || input.length() == 0) {
                return;
            }
            Number parsedNumber = this.nf.parse(input);
            BigDecimal newValue = new BigDecimal(parsedNumber.toString());
            this.setNumber(newValue);
            this.selectAll();
        }
        catch (ParseException ex) {
            this.setText(this.nf.format(this.number.get()));
        }
    }
}

