/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import jfxtras.labs.scene.control.NumberTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberSpinner
extends HBox {
    public static final String ARROW = "NumberSpinnerArrow";
    public static final String NUMBER_FIELD = "NumberField";
    public static final String NUMBER_SPINNER = "NumberSpinner";
    public static final String SPINNER_BUTTON_UP = "SpinnerButtonUp";
    public static final String SPINNER_BUTTON_DOWN = "SpinnerButtonDown";
    private final String BUTTONS_BOX = "ButtonsBox";
    private NumberTextField numberField;
    private ObjectProperty<BigDecimal> stepWitdhProperty = new SimpleObjectProperty();
    private final double ARROW_SIZE = 4.0;
    private final Button incrementButton;
    private final Button decrementButton;
    private final NumberBinding buttonHeight;
    private final NumberBinding spacing;

    public NumberSpinner() {
        this(BigDecimal.ZERO, BigDecimal.ONE);
    }

    public NumberSpinner(BigDecimal value, BigDecimal stepWidth) {
        this(value, stepWidth, NumberFormat.getInstance());
    }

    public NumberSpinner(BigDecimal value, BigDecimal stepWidth, NumberFormat nf) {
        this.setId(NUMBER_SPINNER);
        this.stepWitdhProperty.set((Object)stepWidth);
        this.numberField = new NumberTextField(value, nf);
        this.numberField.setId(NUMBER_FIELD);
        this.numberField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.DOWN) {
                    NumberSpinner.this.decrement();
                    keyEvent.consume();
                }
                if (keyEvent.getCode() == KeyCode.UP) {
                    NumberSpinner.this.increment();
                    keyEvent.consume();
                }
            }
        });
        Path arrowUp = new Path();
        arrowUp.setId(ARROW);
        arrowUp.getElements().addAll((Object[])new PathElement[]{new MoveTo(-4.0, 0.0), new LineTo(4.0, 0.0), new LineTo(0.0, -4.0), new LineTo(-4.0, 0.0)});
        arrowUp.setMouseTransparent(true);
        Path arrowDown = new Path();
        arrowDown.setId(ARROW);
        arrowDown.getElements().addAll((Object[])new PathElement[]{new MoveTo(-4.0, 0.0), new LineTo(4.0, 0.0), new LineTo(0.0, 4.0), new LineTo(-4.0, 0.0)});
        arrowDown.setMouseTransparent(true);
        this.buttonHeight = this.numberField.heightProperty().subtract(3).divide(2);
        this.spacing = this.numberField.heightProperty().subtract(2).subtract((ObservableNumberValue)this.buttonHeight.multiply(2));
        VBox buttons = new VBox();
        buttons.setId("ButtonsBox");
        this.incrementButton = new Button();
        this.incrementButton.setId(SPINNER_BUTTON_UP);
        this.incrementButton.prefWidthProperty().bind((ObservableValue)this.numberField.heightProperty());
        this.incrementButton.minWidthProperty().bind((ObservableValue)this.numberField.heightProperty());
        this.incrementButton.maxHeightProperty().bind((ObservableValue)this.buttonHeight.add((ObservableNumberValue)this.spacing));
        this.incrementButton.prefHeightProperty().bind((ObservableValue)this.buttonHeight.add((ObservableNumberValue)this.spacing));
        this.incrementButton.minHeightProperty().bind((ObservableValue)this.buttonHeight.add((ObservableNumberValue)this.spacing));
        this.incrementButton.setFocusTraversable(false);
        this.incrementButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                NumberSpinner.this.increment();
                ae.consume();
            }
        });
        StackPane incPane = new StackPane();
        incPane.getChildren().addAll((Object[])new Node[]{this.incrementButton, arrowUp});
        incPane.setAlignment(Pos.CENTER);
        this.decrementButton = new Button();
        this.decrementButton.setId(SPINNER_BUTTON_DOWN);
        this.decrementButton.prefWidthProperty().bind((ObservableValue)this.numberField.heightProperty());
        this.decrementButton.minWidthProperty().bind((ObservableValue)this.numberField.heightProperty());
        this.decrementButton.maxHeightProperty().bind((ObservableValue)this.buttonHeight);
        this.decrementButton.prefHeightProperty().bind((ObservableValue)this.buttonHeight);
        this.decrementButton.minHeightProperty().bind((ObservableValue)this.buttonHeight);
        this.decrementButton.setFocusTraversable(false);
        this.decrementButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                NumberSpinner.this.decrement();
                ae.consume();
            }
        });
        StackPane decPane = new StackPane();
        decPane.getChildren().addAll((Object[])new Node[]{this.decrementButton, arrowDown});
        decPane.setAlignment(Pos.CENTER);
        buttons.getChildren().addAll((Object[])new Node[]{incPane, decPane});
        this.getChildren().addAll((Object[])new Node[]{this.numberField, buttons});
    }

    private void increment() {
        BigDecimal value = this.numberField.getNumber();
        value = value.add((BigDecimal)this.stepWitdhProperty.get());
        this.numberField.setNumber(value);
    }

    private void decrement() {
        BigDecimal value = this.numberField.getNumber();
        value = value.subtract((BigDecimal)this.stepWitdhProperty.get());
        this.numberField.setNumber(value);
    }

    public final void setNumber(BigDecimal value) {
        this.numberField.setNumber(value);
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.numberField.numberProperty();
    }

    public final BigDecimal getNumber() {
        return this.numberField.getNumber();
    }

    public void dumpSizes() {
        System.out.println("numberField (layout)=" + this.numberField.getLayoutBounds());
        System.out.println("buttonInc (layout)=" + this.incrementButton.getLayoutBounds());
        System.out.println("buttonDec (layout)=" + this.decrementButton.getLayoutBounds());
        System.out.println("binding=" + this.buttonHeight.toString());
        System.out.println("spacing=" + this.spacing.toString());
    }
}

