/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarPicker
extends Control {
    private final ObjectProperty<Calendar> iCalendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar");
    private final ObservableList<Calendar> iCalendars = FXCollections.observableArrayList();
    public static final String CALENDARS_PROPERTY_ID = "calendars";
    private volatile ObjectProperty<Locale> iLocaleObjectProperty = new SimpleObjectProperty((Object)Locale.getDefault());
    public static final String LOCALE_PROPERTY_ID = "locale";
    private final SimpleObjectProperty<Mode> iModeObjectProperty = new SimpleObjectProperty((Object)this, "mode", (Object)Mode.SINGLE);
    public static final String MODE_PROPERTY_ID = "mode";

    public CalendarPicker() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
        this.constructCalendar();
        this.constructCalendars();
        this.constructLocale();
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.iCalendarObjectProperty;
    }

    private void constructCalendar() {
        this.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                if (oldValue != null) {
                    CalendarPicker.this.calendars().remove((Object)oldValue);
                }
                if (newValue != null && !CalendarPicker.this.calendars().contains((Object)newValue)) {
                    CalendarPicker.this.calendars().add((Object)newValue);
                }
            }
        });
    }

    public Calendar getCalendar() {
        return (Calendar)this.iCalendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.iCalendarObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObservableList<Calendar> calendars() {
        return this.iCalendars;
    }

    private void constructCalendars() {
        this.calendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> arg0) {
                if (!CalendarPicker.this.calendars().contains((Object)CalendarPicker.this.getCalendar())) {
                    if (CalendarPicker.this.calendars().size() > 0) {
                        CalendarPicker.this.setCalendar((Calendar)CalendarPicker.this.calendars().get(0));
                    } else {
                        CalendarPicker.this.setCalendar(null);
                    }
                }
            }
        });
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.iLocaleObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.iLocaleObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.iLocaleObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    private void constructLocale() {
        this.localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
            }
        });
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.iModeObjectProperty;
    }

    public Mode getMode() {
        return (Mode)((Object)this.iModeObjectProperty.getValue());
    }

    public void setMode(Mode value) {
        if (value == null) {
            throw new IllegalArgumentException("NULL not allowed");
        }
        this.iModeObjectProperty.setValue((Object)value);
        while (this.getMode() == Mode.SINGLE && this.calendars().size() > 1) {
            this.calendars().remove(this.calendars().size() - 1);
        }
    }

    public CalendarPicker withMode(Mode value) {
        this.setMode(value);
        return this;
    }

    public static String quickFormatCalendar(Calendar value) {
        if (value == null) {
            return "null";
        }
        SimpleDateFormat lSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1);
        lSimpleDateFormat.applyPattern("yyyy-MM-dd");
        return value == null ? "null" : lSimpleDateFormat.format(value.getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SINGLE,
        MULTIPLE;

    }
}

