/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.io.InputStream;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import jfxtras.labs.internal.scene.control.behavior.SplitFlapBehavior;
import jfxtras.labs.scene.control.gauge.SplitFlap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFlapSkin
extends SkinBase<SplitFlap, SplitFlapBehavior> {
    private SplitFlap control;
    private static double MIN_FLIP_TIME = 1.6666666666666666E7;
    private boolean isDirty;
    private boolean initialized;
    private Group fixture;
    private Group flip;
    private Color bright;
    private Color brighter;
    private Color dark;
    private Color darker;
    private Color textColor;
    private Path upper;
    private Text upperText;
    private Path upperNext;
    private Text upperNextText;
    private Path lower;
    private Text lowerText;
    private Text lowerNextText;
    private char currentChar;
    private char nextChar;
    private Rotate rotate;
    private Rotate lowerFlipVert;
    private double angleStep;
    private double currentAngle;
    private boolean flipping;
    private AnimationTimer timer;

    public SplitFlapSkin(SplitFlap CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SplitFlapBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.fixture = new Group();
        this.flip = new Group();
        this.bright = this.control.getColor().brighter();
        this.brighter = this.control.getColor().brighter().brighter();
        this.dark = this.control.getColor().darker();
        this.darker = this.control.getColor().darker().darker();
        this.textColor = this.control.getCharacterColor();
        this.upperText = new Text(Character.toString(this.control.getCharacter()));
        this.lowerText = new Text(Character.toString(this.control.getCharacter()));
        this.upperNextText = new Text(Character.toString((char)(this.control.getCharacter() + '\u0001')));
        this.lowerNextText = new Text(Character.toString((char)(this.control.getCharacter() + '\u0001')));
        this.currentChar = this.control.getCharacter();
        this.nextChar = (char)(this.control.getCharacter() + '\u0001');
        this.rotate = new Rotate();
        this.angleStep = 180.0 / ((double)(this.control.getFlipTimeInMs() * 1000000L) / MIN_FLIP_TIME);
        this.currentAngle = 0.0;
        this.flipping = false;
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                if (SplitFlapSkin.this.initialized) {
                    if (SplitFlapSkin.this.control.isCountdownMode()) {
                        SplitFlapSkin.this.flipBackward(SplitFlapSkin.this.angleStep);
                    } else {
                        SplitFlapSkin.this.flipForward(SplitFlapSkin.this.angleStep);
                    }
                }
            }
        };
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(112.0, 189.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SplitFlapSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SplitFlapSkin.this.isDirty = true;
            }
        });
        this.rotate.setAxis(Rotate.X_AXIS);
        this.rotate.setPivotY(this.control.getPrefHeight() / 2.0);
        this.lowerFlipVert = new Rotate();
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.characterColorProperty(), "CHARACTER_COLOR");
        this.registerChangeListener((ObservableValue)this.control.characterProperty(), "CHARACTER");
        this.registerChangeListener((ObservableValue)this.control.flipTimeInMsProperty(), "FLIP_TIME");
        this.initialized = true;
        this.paint();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawFixture();
        this.drawFlip();
        this.getChildren().addAll((Object[])new Node[]{this.fixture, this.flip});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "COLOR") {
            this.bright = this.control.getColor().brighter();
            this.brighter = this.control.getColor().brighter().brighter();
            this.dark = this.control.getColor().darker();
            this.darker = this.control.getColor().darker().darker();
            this.paint();
        } else if (PROPERTY == "CHARACTER_COLOR") {
            this.textColor = this.control.getCharacterColor();
            this.paint();
        } else if (PROPERTY == "CHARACTER") {
            if (this.control.getCharacter() != this.currentChar) {
                this.timer.stop();
                this.flipping = true;
                this.timer.start();
            }
        } else if (PROPERTY == "FLIP_TIME") {
            this.angleStep = 180.0 / ((double)(this.control.getFlipTimeInMs() * 1000000L) / MIN_FLIP_TIME);
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final SplitFlap getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 112.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 189.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void flipForward(double ANGLE) {
        this.currentAngle += ANGLE;
        if (Double.compare(this.currentAngle, 180.0) >= 0) {
            this.currentAngle = 0.0;
            this.upper.getTransforms().clear();
            this.upperText.getTransforms().clear();
            this.lowerNextText.getTransforms().clear();
            this.lowerNextText.setVisible(false);
            this.lowerFlipVert.setAxis(Rotate.X_AXIS);
            this.lowerFlipVert.setPivotY(this.control.getPrefHeight() * 0.07 + this.lowerNextText.getLayoutBounds().getHeight() / 2.0);
            this.lowerFlipVert.setAngle(180.0);
            this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
            this.upperText.setVisible(true);
            this.currentChar = (char)(this.currentChar + '\u0001');
            if (this.currentChar > this.control.getType().UPPER_BOUND || this.currentChar < this.control.getType().LOWER_BOUND) {
                this.currentChar = this.control.getCharacter() == ' ' ? (char)32 : (char)this.control.getType().LOWER_BOUND;
            }
            this.nextChar = (char)(this.currentChar + '\u0001');
            if (this.nextChar > this.control.getType().UPPER_BOUND || this.nextChar < this.control.getType().LOWER_BOUND) {
                this.nextChar = this.control.getCharacter() == ' ' ? (char)32 : (char)this.control.getType().LOWER_BOUND;
            }
            if (this.currentChar == this.control.getCharacter()) {
                this.timer.stop();
                this.flipping = false;
            }
            this.upperText.setText(Character.toString(this.currentChar));
            this.lowerText.setText(Character.toString(this.currentChar));
            this.upperNextText.setText(Character.toString(this.nextChar));
            this.lowerNextText.setText(Character.toString(this.nextChar));
        }
        if (this.currentAngle > 90.0) {
            this.upperText.setVisible(false);
            this.lowerNextText.setVisible(true);
        }
        if (this.flipping) {
            this.rotate.setAngle(ANGLE);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
        }
    }

    private void flipBackward(double ANGLE) {
        this.currentAngle += ANGLE;
        if (Double.compare(this.currentAngle, 180.0) >= 0) {
            this.currentAngle = 0.0;
            this.upper.getTransforms().clear();
            this.upperText.getTransforms().clear();
            this.lowerNextText.getTransforms().clear();
            this.lowerNextText.setVisible(false);
            this.lowerFlipVert.setAxis(Rotate.X_AXIS);
            this.lowerFlipVert.setPivotY(this.control.getPrefHeight() * 0.07 + this.lowerNextText.getLayoutBounds().getHeight() / 2.0);
            this.lowerFlipVert.setAngle(180.0);
            this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
            this.upperText.setVisible(true);
            this.currentChar = (char)(this.currentChar - '\u0001');
            if (this.currentChar < this.control.getType().LOWER_BOUND) {
                this.currentChar = this.control.getCharacter() == ' ' ? (char)32 : (char)this.control.getType().UPPER_BOUND;
            }
            this.nextChar = (char)(this.currentChar - '\u0001');
            if (this.nextChar < this.control.getType().LOWER_BOUND) {
                this.nextChar = this.control.getCharacter() == ' ' ? (char)32 : (char)this.control.getType().UPPER_BOUND;
            }
            if (this.currentChar == this.control.getCharacter()) {
                this.timer.stop();
                this.flipping = false;
            }
            this.upperText.setText(Character.toString(this.currentChar));
            this.lowerText.setText(Character.toString(this.currentChar));
            this.upperNextText.setText(Character.toString(this.nextChar));
            this.lowerNextText.setText(Character.toString(this.nextChar));
        }
        if (this.currentAngle > 90.0) {
            this.upperText.setVisible(false);
            this.lowerNextText.setVisible(true);
        }
        if (this.flipping) {
            this.rotate.setAngle(ANGLE);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
        }
    }

    public void drawFixture() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.fixture.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.fixture.getChildren().add((Object)IBOUNDS);
        Rectangle RIGHTFRAME = new Rectangle(0.9196428571428571 * WIDTH, 0.41798941798941797 * HEIGHT, 0.08035714285714286 * WIDTH, 0.164021164021164 * HEIGHT);
        LinearGradient RIGHTFRAME_FILL = new LinearGradient(0.9642857142857143 * WIDTH, 0.41798941798941797 * HEIGHT, 0.9642857142857143 * WIDTH, 0.582010582010582 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2196078431, (double)0.2196078431, (double)0.2196078431, (double)1.0)), new Stop(0.18, Color.color((double)0.6117647059, (double)0.6117647059, (double)0.6117647059, (double)1.0)), new Stop(0.65, Color.color((double)0.1843137255, (double)0.1843137255, (double)0.1843137255, (double)1.0)), new Stop(0.89, Color.color((double)0.3294117647, (double)0.337254902, (double)0.3333333333, (double)1.0)), new Stop(1.0, Color.color((double)0.2156862745, (double)0.2156862745, (double)0.2156862745, (double)1.0))});
        RIGHTFRAME.setFill((Paint)RIGHTFRAME_FILL);
        RIGHTFRAME.setStroke(null);
        Rectangle RIGHTMAIN = new Rectangle(0.9285714285714286 * WIDTH, 0.42328042328042326 * HEIGHT, 0.0625 * WIDTH, 0.15343915343915343 * HEIGHT);
        LinearGradient RIGHTMAIN_FILL = new LinearGradient(0.9642857142857143 * WIDTH, 0.42328042328042326 * HEIGHT, 0.9642857142857143 * WIDTH, 0.5767195767195767 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.4549019608, (double)0.4549019608, (double)0.4549019608, (double)1.0)), new Stop(0.13, Color.color((double)0.8352941176, (double)0.8352941176, (double)0.8352941176, (double)1.0)), new Stop(0.66, Color.color((double)0.2196078431, (double)0.2196078431, (double)0.2196078431, (double)1.0)), new Stop(0.73, Color.color((double)0.2509803922, (double)0.2509803922, (double)0.2509803922, (double)1.0)), new Stop(0.9, Color.color((double)0.4274509804, (double)0.4274509804, (double)0.4274509804, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0))});
        RIGHTMAIN.setFill((Paint)RIGHTMAIN_FILL);
        RIGHTMAIN.setStroke(null);
        Rectangle LEFTFRAME = new Rectangle(0.0, 0.41798941798941797 * HEIGHT, 0.08035714285714286 * WIDTH, 0.164021164021164 * HEIGHT);
        LinearGradient LEFTFRAME_FILL = new LinearGradient(0.044642857142857144 * WIDTH, 0.41798941798941797 * HEIGHT, 0.04464285714285716 * WIDTH, 0.582010582010582 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2196078431, (double)0.2196078431, (double)0.2196078431, (double)1.0)), new Stop(0.18, Color.color((double)0.6117647059, (double)0.6117647059, (double)0.6117647059, (double)1.0)), new Stop(0.65, Color.color((double)0.1843137255, (double)0.1843137255, (double)0.1843137255, (double)1.0)), new Stop(0.89, Color.color((double)0.3294117647, (double)0.337254902, (double)0.3333333333, (double)1.0)), new Stop(1.0, Color.color((double)0.2156862745, (double)0.2156862745, (double)0.2156862745, (double)1.0))});
        LEFTFRAME.setFill((Paint)LEFTFRAME_FILL);
        LEFTFRAME.setStroke(null);
        Rectangle LEFTMAIN = new Rectangle(0.008928571428571428 * WIDTH, 0.42328042328042326 * HEIGHT, 0.0625 * WIDTH, 0.15343915343915343 * HEIGHT);
        LinearGradient LEFTMAIN_FILL = new LinearGradient(0.044642857142857144 * WIDTH, 0.42328042328042326 * HEIGHT, 0.04464285714285716 * WIDTH, 0.5767195767195767 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.4549019608, (double)0.4549019608, (double)0.4549019608, (double)1.0)), new Stop(0.13, Color.color((double)0.8352941176, (double)0.8352941176, (double)0.8352941176, (double)1.0)), new Stop(0.66, Color.color((double)0.2196078431, (double)0.2196078431, (double)0.2196078431, (double)1.0)), new Stop(0.73, Color.color((double)0.2509803922, (double)0.2509803922, (double)0.2509803922, (double)1.0)), new Stop(0.9, Color.color((double)0.4274509804, (double)0.4274509804, (double)0.4274509804, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0))});
        LEFTMAIN.setFill((Paint)LEFTMAIN_FILL);
        LEFTMAIN.setStroke(null);
        this.fixture.getChildren().addAll((Object[])new Node[]{RIGHTFRAME, RIGHTMAIN, LEFTFRAME, LEFTMAIN});
    }

    public void drawFlip() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.flip.getChildren().clear();
        this.lower = new Path();
        this.lower.setFillRule(FillRule.EVEN_ODD);
        this.lower.getElements().add((Object)new MoveTo(0.9196428571428571 * WIDTH, HEIGHT));
        this.lower.getElements().add((Object)new CubicCurveTo(0.9642857142857143 * WIDTH, HEIGHT, WIDTH, 0.9735449735449735 * HEIGHT, WIDTH, 0.9523809523809523 * HEIGHT));
        this.lower.getElements().add((Object)new CubicCurveTo(WIDTH, 0.9523809523809523 * HEIGHT, WIDTH, 0.5925925925925926 * HEIGHT, WIDTH, 0.5925925925925926 * HEIGHT));
        this.lower.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.5925925925925926 * HEIGHT));
        this.lower.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.5079365079365079 * HEIGHT));
        this.lower.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.5079365079365079 * HEIGHT));
        this.lower.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.5925925925925926 * HEIGHT));
        this.lower.getElements().add((Object)new LineTo(0.0, 0.5925925925925926 * HEIGHT));
        this.lower.getElements().add((Object)new CubicCurveTo(0.0, 0.5925925925925926 * HEIGHT, 0.0, 0.9523809523809523 * HEIGHT, 0.0, 0.9523809523809523 * HEIGHT));
        this.lower.getElements().add((Object)new CubicCurveTo(0.0, 0.9735449735449735 * HEIGHT, 0.03571428571428571 * WIDTH, HEIGHT, 0.08035714285714286 * WIDTH, HEIGHT));
        this.lower.getElements().add((Object)new CubicCurveTo(0.08035714285714286 * WIDTH, HEIGHT, 0.9196428571428571 * WIDTH, HEIGHT, 0.9196428571428571 * WIDTH, HEIGHT));
        this.lower.getElements().add((Object)new ClosePath());
        LinearGradient LOWER_FILL = new LinearGradient(0.5342465753424658 * WIDTH, 0.5079365079365079 * HEIGHT, 0.5342465753424658 * WIDTH, 0.9947089947089947 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.brighter), new Stop(1.0, this.control.getColor())});
        this.lower.setFill((Paint)LOWER_FILL);
        this.lower.setStroke(null);
        InnerShadow LOWER_INNER_SHADOW = new InnerShadow();
        LOWER_INNER_SHADOW.setWidth(0.075 * this.lower.getLayoutBounds().getWidth());
        LOWER_INNER_SHADOW.setHeight(0.075 * this.lower.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setOffsetX(0.0);
        LOWER_INNER_SHADOW.setOffsetY(0.0);
        LOWER_INNER_SHADOW.setRadius(0.075 * this.lower.getLayoutBounds().getWidth());
        LOWER_INNER_SHADOW.setColor(Color.BLACK);
        LOWER_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow LOWER_LIGHT_EFFECT = new InnerShadow();
        LOWER_LIGHT_EFFECT.setWidth(0.05 * this.lower.getLayoutBounds().getWidth());
        LOWER_LIGHT_EFFECT.setHeight(0.05 * this.lower.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setOffsetX(0.0);
        LOWER_LIGHT_EFFECT.setOffsetY(0.018 * SIZE);
        LOWER_LIGHT_EFFECT.setRadius(0.05 * this.lower.getLayoutBounds().getWidth());
        LOWER_LIGHT_EFFECT.setColor(Color.WHITE);
        LOWER_LIGHT_EFFECT.setBlurType(BlurType.GAUSSIAN);
        LOWER_LIGHT_EFFECT.inputProperty().set((Object)LOWER_INNER_SHADOW);
        this.lower.setEffect((Effect)LOWER_LIGHT_EFFECT);
        this.lower.setCache(true);
        this.upper = new Path();
        this.upper.setFillRule(FillRule.EVEN_ODD);
        this.upper.getElements().add((Object)new MoveTo(0.9196428571428571 * WIDTH, 0.0));
        this.upper.getElements().add((Object)new CubicCurveTo(0.9642857142857143 * WIDTH, 0.0, WIDTH, 0.026455026455026454 * HEIGHT, WIDTH, 0.047619047619047616 * HEIGHT));
        this.upper.getElements().add((Object)new CubicCurveTo(WIDTH, 0.047619047619047616 * HEIGHT, WIDTH, 0.4074074074074074 * HEIGHT, WIDTH, 0.4074074074074074 * HEIGHT));
        this.upper.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.4074074074074074 * HEIGHT));
        this.upper.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.49206349206349204 * HEIGHT));
        this.upper.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.49206349206349204 * HEIGHT));
        this.upper.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.4074074074074074 * HEIGHT));
        this.upper.getElements().add((Object)new LineTo(0.0, 0.4074074074074074 * HEIGHT));
        this.upper.getElements().add((Object)new CubicCurveTo(0.0, 0.4074074074074074 * HEIGHT, 0.0, 0.047619047619047616 * HEIGHT, 0.0, 0.047619047619047616 * HEIGHT));
        this.upper.getElements().add((Object)new CubicCurveTo(0.0, 0.026455026455026454 * HEIGHT, 0.03571428571428571 * WIDTH, 0.0, 0.08035714285714286 * WIDTH, 0.0));
        this.upper.getElements().add((Object)new CubicCurveTo(0.08035714285714286 * WIDTH, 0.0, 0.9196428571428571 * WIDTH, 0.0, 0.9196428571428571 * WIDTH, 0.0));
        this.upper.getElements().add((Object)new ClosePath());
        LinearGradient UPPER_FILL = new LinearGradient(0.5205479452054794 * WIDTH, 0.0, 0.5205479452054794 * WIDTH, 0.49206349206349204 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.darker), new Stop(1.0, this.control.getColor())});
        this.upper.setFill((Paint)UPPER_FILL);
        this.upper.setStroke(null);
        InnerShadow UPPER_INNER_SHADOW = new InnerShadow();
        UPPER_INNER_SHADOW.setWidth(0.075 * this.upper.getLayoutBounds().getWidth());
        UPPER_INNER_SHADOW.setHeight(0.075 * this.upper.getLayoutBounds().getHeight());
        UPPER_INNER_SHADOW.setOffsetX(0.0);
        UPPER_INNER_SHADOW.setOffsetY(0.0);
        UPPER_INNER_SHADOW.setRadius(0.075 * this.upper.getLayoutBounds().getWidth());
        UPPER_INNER_SHADOW.setColor(Color.BLACK);
        UPPER_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow UPPER_LIGHT_EFFECT = new InnerShadow();
        UPPER_LIGHT_EFFECT.setWidth(0.05 * this.upper.getLayoutBounds().getWidth());
        UPPER_LIGHT_EFFECT.setHeight(0.05 * this.upper.getLayoutBounds().getHeight());
        UPPER_LIGHT_EFFECT.setOffsetX(0.0);
        UPPER_LIGHT_EFFECT.setOffsetY(0.018 * SIZE);
        UPPER_LIGHT_EFFECT.setRadius(0.05 * this.upper.getLayoutBounds().getWidth());
        UPPER_LIGHT_EFFECT.setColor(Color.WHITE);
        UPPER_LIGHT_EFFECT.setBlurType(BlurType.GAUSSIAN);
        UPPER_LIGHT_EFFECT.inputProperty().set((Object)UPPER_INNER_SHADOW);
        this.upper.setEffect((Effect)UPPER_LIGHT_EFFECT);
        Font font = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/droidsansmono.ttf"), (double)(0.74 * HEIGHT));
        Rectangle upperClip = new Rectangle(0.0, 0.0, WIDTH, this.upper.getLayoutBounds().getHeight());
        this.upperText.setTextOrigin(VPos.BOTTOM);
        this.upperText.setFont(font);
        this.upperText.setFontSmoothingType(FontSmoothingType.LCD);
        this.upperText.setText(Character.toString(this.control.getCharacter()));
        this.upperText.setX((WIDTH - this.upperText.getLayoutBounds().getWidth()) / 2.0);
        this.upperText.setY(HEIGHT * 0.07 + this.upperText.getLayoutBounds().getHeight());
        this.upperText.setClip((Node)upperClip);
        LinearGradient upperTextFill = new LinearGradient(0.0, this.upperText.getLayoutBounds().getMinY(), 0.0, this.upperText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.textColor.darker()), new Stop(0.5, this.textColor)});
        this.upperText.setFill((Paint)upperTextFill);
        this.upperText.setStroke(null);
        Rectangle lowerClip = new Rectangle(0.0, this.lower.getLayoutBounds().getMinY(), WIDTH, HEIGHT / 2.0);
        this.lowerText.setTextOrigin(VPos.BOTTOM);
        this.lowerText.setFont(font);
        this.lowerText.setFontSmoothingType(FontSmoothingType.LCD);
        this.lowerText.setText(Character.toString(this.control.getCharacter()));
        this.lowerText.setX((WIDTH - this.upperText.getLayoutBounds().getWidth()) / 2.0);
        this.lowerText.setY(HEIGHT * 0.07 + this.upperText.getLayoutBounds().getHeight());
        this.lowerText.setClip((Node)lowerClip);
        LinearGradient lowerTextFill = new LinearGradient(0.0, this.lowerText.getLayoutBounds().getMinY(), 0.0, this.lowerText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.5, this.textColor.brighter()), new Stop(1.0, this.textColor)});
        this.lowerText.setFill((Paint)lowerTextFill);
        this.lowerText.setStroke(null);
        this.upperNext = new Path();
        this.upperNext.setFillRule(FillRule.EVEN_ODD);
        this.upperNext.getElements().add((Object)new MoveTo(0.9196428571428571 * WIDTH, 0.0));
        this.upperNext.getElements().add((Object)new CubicCurveTo(0.9642857142857143 * WIDTH, 0.0, WIDTH, 0.026455026455026454 * HEIGHT, WIDTH, 0.047619047619047616 * HEIGHT));
        this.upperNext.getElements().add((Object)new CubicCurveTo(WIDTH, 0.047619047619047616 * HEIGHT, WIDTH, 0.4074074074074074 * HEIGHT, WIDTH, 0.4074074074074074 * HEIGHT));
        this.upperNext.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.4074074074074074 * HEIGHT));
        this.upperNext.getElements().add((Object)new LineTo(0.9017857142857143 * WIDTH, 0.49206349206349204 * HEIGHT));
        this.upperNext.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.49206349206349204 * HEIGHT));
        this.upperNext.getElements().add((Object)new LineTo(0.09821428571428571 * WIDTH, 0.4074074074074074 * HEIGHT));
        this.upperNext.getElements().add((Object)new LineTo(0.0, 0.4074074074074074 * HEIGHT));
        this.upperNext.getElements().add((Object)new CubicCurveTo(0.0, 0.4074074074074074 * HEIGHT, 0.0, 0.047619047619047616 * HEIGHT, 0.0, 0.047619047619047616 * HEIGHT));
        this.upperNext.getElements().add((Object)new CubicCurveTo(0.0, 0.026455026455026454 * HEIGHT, 0.03571428571428571 * WIDTH, 0.0, 0.08035714285714286 * WIDTH, 0.0));
        this.upperNext.getElements().add((Object)new CubicCurveTo(0.08035714285714286 * WIDTH, 0.0, 0.9196428571428571 * WIDTH, 0.0, 0.9196428571428571 * WIDTH, 0.0));
        this.upperNext.getElements().add((Object)new ClosePath());
        LinearGradient UPPER_NEXT_FILL = new LinearGradient(0.5205479452054794 * WIDTH, 0.0, 0.5205479452054794 * WIDTH, 0.49206349206349204 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.dark), new Stop(1.0, this.bright)});
        this.upperNext.setFill((Paint)UPPER_NEXT_FILL);
        this.upperNext.setStroke(null);
        this.upperNext.setEffect((Effect)UPPER_LIGHT_EFFECT);
        Rectangle upperNextClip = new Rectangle(0.0, 0.0, WIDTH, this.upper.getLayoutBounds().getHeight());
        this.upperNextText.setTextOrigin(VPos.BOTTOM);
        this.upperNextText.setFont(font);
        this.upperNextText.setFontSmoothingType(FontSmoothingType.LCD);
        this.upperNextText.setText(Character.toString((char)(this.control.getCharacter() + '\u0001')));
        this.upperNextText.setX((WIDTH - this.upperText.getLayoutBounds().getWidth()) / 2.0);
        this.upperNextText.setY(HEIGHT * 0.07 + this.upperText.getLayoutBounds().getHeight());
        this.upperNextText.setClip((Node)upperNextClip);
        LinearGradient upperNextTextFill = new LinearGradient(0.0, this.upperNextText.getLayoutBounds().getMinY(), 0.0, this.upperNextText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.textColor.darker()), new Stop(0.5, this.textColor)});
        this.upperNextText.setFill((Paint)upperNextTextFill);
        this.upperNextText.setStroke(null);
        Rectangle lowerNextClip = new Rectangle(0.0, this.lower.getLayoutBounds().getMinY(), WIDTH, HEIGHT / 2.0);
        this.lowerNextText.setTextOrigin(VPos.BOTTOM);
        this.lowerNextText.setFont(font);
        this.lowerNextText.setFontSmoothingType(FontSmoothingType.LCD);
        this.lowerNextText.setText(Character.toString((char)(this.control.getCharacter() + '\u0001')));
        this.lowerNextText.setX((WIDTH - this.lowerNextText.getLayoutBounds().getWidth()) / 2.0);
        this.lowerNextText.setY(HEIGHT * 0.07 + this.lowerNextText.getLayoutBounds().getHeight());
        this.lowerNextText.setClip((Node)lowerNextClip);
        LinearGradient lowerNextTextFill = new LinearGradient(0.0, this.lowerNextText.getLayoutBounds().getMinY(), 0.0, this.lowerNextText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.textColor.darker()), new Stop(0.5, this.textColor)});
        this.lowerNextText.setFill((Paint)lowerNextTextFill);
        this.lowerNextText.setStroke(null);
        this.lowerNextText.setVisible(false);
        this.lowerFlipVert = new Rotate();
        this.lowerFlipVert.setAxis(Rotate.X_AXIS);
        this.lowerFlipVert.setPivotY(HEIGHT * 0.07 + this.lowerNextText.getLayoutBounds().getHeight() / 2.0);
        this.lowerFlipVert.setAngle(180.0);
        this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
        this.flip.getChildren().addAll((Object[])new Node[]{this.lower, this.lowerText, this.upperNext, this.upperNextText, this.upper, this.upperText, this.lowerNextText});
    }
}

