/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import jfxtras.labs.internal.scene.control.behavior.GaugeBehaviorBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.LedColor;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.MarkerEvent;
import jfxtras.labs.scene.control.gauge.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GaugeSkinBase<C extends Gauge, B extends GaugeBehaviorBase<C>>
extends SkinBase<C, B> {
    public static final long BLINK_INTERVAL = 500000000L;

    public GaugeSkinBase(C CONTROL, B BEHAVIOR) {
        super(CONTROL, BEHAVIOR);
        this.registerChangeListener((ObservableValue)CONTROL.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)CONTROL.heightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).animationDurationProperty(), "ANIMATION_DURATION");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).radialRangeProperty(), "RADIAL_RANGE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).frameDesignProperty(), "FRAME_DESIGN");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).backgroundDesignProperty(), "BACKGROUND_DESIGN");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).knobDesignProperty(), "KNOB_DESIGN");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).knobColorProperty(), "KNOB_COLOR");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).pointerTypeProperty(), "POINTER_TYPE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).valueColorProperty(), "VALUE_COLOR");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).pointerGlowEnabledProperty(), "POINTER_GLOW");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).pointerShadowEnabledProperty(), "POINTER_SHADOW");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).thresholdColorProperty(), "THRESHOLD_COLOR");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).foregroundTypeProperty(), "FOREGROUND_TYPE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).lcdDesignProperty(), "LCD_DESIGN");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).lcdNumberSystemProperty(), "LCD_NUMBER_SYSTEM");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).userLedBlinkingProperty(), "USER_LED_BLINKING");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).ledBlinkingProperty(), "LED_BLINKING");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).tickmarkGlowEnabledProperty(), "TICKMARK_GLOW_VISIBILITY");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).glowColorProperty(), "GLOW_COLOR");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).glowVisibleProperty(), "GLOW_VISIBILITY");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).glowOnProperty(), "GLOW_ON");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).pulsatingGlowProperty(), "PULSATING_GLOW");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).rangeProperty(), "RANGE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).minMeasuredValueProperty(), "MIN_MEASURED_VALUE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).maxMeasuredValueProperty(), "MAX_MEASURED_VALUE");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).trendProperty(), "TREND");
        this.registerChangeListener((ObservableValue)((Gauge)((Object)CONTROL)).simpleGradientBaseColorProperty(), "SIMPLE_GRADIENT_BASE");
    }

    protected double computeMinWidth(double HEIGHT) {
        return ((Gauge)this.getSkinnable()).prefWidth(HEIGHT);
    }

    protected double computeMinHeight(double WIDTH) {
        return ((Gauge)this.getSkinnable()).prefHeight(WIDTH);
    }

    protected double computePrefWidth(double HEIGHT) {
        return ((Gauge)this.getSkinnable()).prefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return ((Gauge)this.getSkinnable()).prefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return ((Gauge)this.getSkinnable()).prefWidth(HEIGHT);
    }

    protected double computeMaxHeight(double WIDTH) {
        return ((Gauge)this.getSkinnable()).prefHeight(WIDTH);
    }

    protected void layoutChildren() {
        Insets padding = this.getInsets();
        double x = padding.getLeft();
        double y = padding.getTop();
        double w = this.getWidth() - (padding.getLeft() + padding.getRight());
        double h = this.getHeight() - (padding.getTop() + padding.getBottom());
    }

    protected void checkMarkers(Gauge CONTROL, double OLD_VALUE, double NEW_VALUE) {
        if (CONTROL.isMarkersVisible() && !CONTROL.getMarkers().isEmpty()) {
            for (Marker marker : CONTROL.getMarkers()) {
                if (OLD_VALUE < marker.getValue() && NEW_VALUE > marker.getValue()) {
                    marker.fireMarkerEvent(new MarkerEvent((Object)CONTROL, null, MarkerEvent.Type.OVER_RUN));
                    continue;
                }
                if (!(OLD_VALUE > marker.getValue()) || !(NEW_VALUE < marker.getValue())) continue;
                marker.fireMarkerEvent(new MarkerEvent((Object)CONTROL, null, MarkerEvent.Type.UNDER_RUN));
            }
        }
    }

    protected void drawCircularFrame(Gauge control, Group FRAME, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        FRAME.getChildren().clear();
        Circle SUBTRACT = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, WIDTH * 0.4158878326);
        Circle OUTER_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.5 * WIDTH);
        OUTER_FRAME.setFill((Paint)Color.color((double)0.5176470588, (double)0.5176470588, (double)0.5176470588, (double)1.0));
        OUTER_FRAME.setStroke(null);
        FRAME.getChildren().add((Object)OUTER_FRAME);
        Circle INNER_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4205607476635514 * WIDTH);
        INNER_FRAME.setFill((Paint)Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.8));
        INNER_FRAME.setStroke(null);
        Circle MAIN_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4953271028037383 * WIDTH);
        MAIN_FRAME.setStroke(null);
        switch (control.getFrameDesign()) {
            case GLOSSY_METAL: {
                MAIN_FRAME.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.5 * HEIGHT, 0.5 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8117647059, (double)0.8117647059, (double)0.8117647059, (double)1.0)), new Stop(0.96, Color.color((double)0.8039215686, (double)0.8, (double)0.8039215686, (double)1.0)), new Stop(1.0, Color.color((double)0.9568627451, (double)0.9568627451, (double)0.9568627451, (double)1.0))}));
                Circle GLOSSY2 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4859813084 * WIDTH);
                GLOSSY2.setFill((Paint)new LinearGradient(0.0, GLOSSY2.getLayoutBounds().getMinY(), 0.0, GLOSSY2.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.23, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.36, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.59, Color.color((double)0.1137254902, (double)0.1137254902, (double)0.1137254902, (double)1.0)), new Stop(0.76, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.7529411765, (double)1.0)), new Stop(1.0, Color.color((double)0.8196078431, (double)0.8196078431, (double)0.8196078431, (double)1.0))}));
                Circle GLOSSY3 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4345794393 * WIDTH);
                GLOSSY3.setFill((Paint)Color.web((String)"#F6F6F6"));
                Circle GLOSSY4 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4252336449 * WIDTH);
                GLOSSY4.setFill((Paint)Color.web((String)"#333333"));
                FRAME.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, GLOSSY2, GLOSSY3, GLOSSY4});
                break;
            }
            case DARK_GLOSSY: {
                MAIN_FRAME.setFill((Paint)new LinearGradient(0.8551401869158879 * WIDTH, 0.14953271028037382 * HEIGHT, 0.15794611761513314 * WIDTH, 0.8467267795811287 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.84, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0))}));
                Circle DARK_GLOSSY2 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.48598130841121495 * WIDTH);
                DARK_GLOSSY2.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.985981308411215 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(0.42, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(1.0, Color.color((double)0.0509803922, (double)0.0509803922, (double)0.0509803922, (double)1.0))}));
                DARK_GLOSSY2.setStroke(null);
                Path DARK_GLOSSY3 = new Path();
                DARK_GLOSSY3.setFillRule(FillRule.EVEN_ODD);
                DARK_GLOSSY3.getElements().add((Object)new MoveTo(0.014018691588785047 * WIDTH, 0.5 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.014018691588785047 * WIDTH, 0.514018691588785 * HEIGHT, 0.014018691588785047 * WIDTH, 0.5233644859813084 * HEIGHT, 0.014018691588785047 * WIDTH, 0.5373831775700935 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.07009345794392523 * WIDTH, 0.37383177570093457 * HEIGHT, 0.26635514018691586 * WIDTH, 0.2570093457943925 * HEIGHT, 0.5 * WIDTH, 0.2570093457943925 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.7336448598130841 * WIDTH, 0.2570093457943925 * HEIGHT, 0.9299065420560748 * WIDTH, 0.37383177570093457 * HEIGHT, 0.985981308411215 * WIDTH, 0.5373831775700935 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.985981308411215 * WIDTH, 0.5233644859813084 * HEIGHT, 0.985981308411215 * WIDTH, 0.514018691588785 * HEIGHT, 0.985981308411215 * WIDTH, 0.5 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.985981308411215 * WIDTH, 0.2336448598130841 * HEIGHT, 0.7663551401869159 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.014018691588785047 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.2336448598130841 * WIDTH, 0.014018691588785047 * HEIGHT, 0.014018691588785047 * WIDTH, 0.2336448598130841 * HEIGHT, 0.014018691588785047 * WIDTH, 0.5 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new ClosePath());
                DARK_GLOSSY3.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.5280373831775701 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26009998, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
                DARK_GLOSSY3.setStroke(null);
                Circle DARK_GLOSSY4 = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4392523364485981 * WIDTH);
                DARK_GLOSSY4.setFill((Paint)new LinearGradient(0.8037383177570093 * WIDTH, 0.1822429906542056 * HEIGHT, 0.18584594354259637 * WIDTH, 0.8001353648686187 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.6745098039, (double)0.6745098039, (double)0.6784313725, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.91, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0)), new Stop(1.0, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0))}));
                DARK_GLOSSY4.setStroke(null);
                FRAME.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, DARK_GLOSSY2, DARK_GLOSSY3, DARK_GLOSSY4});
                break;
            }
            default: {
                ImageView IMAGE_VIEW = new ImageView();
                IMAGE_VIEW.setVisible(false);
                MAIN_FRAME.setId(control.getFrameDesign().CSS);
                MAIN_FRAME.setStroke(null);
                FRAME.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
            }
        }
        FRAME.setCache(true);
    }

    protected void drawCircularBackground(Gauge CONTROL, Group BACKGROUND, Rectangle GAUGE_BOUNDS) {
        double SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        BACKGROUND.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        BACKGROUND.getChildren().add((Object)IBOUNDS);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.2 * SIZE);
        INNER_SHADOW.setHeight(0.2 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        Circle BACKGROUND_SHAPE = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.4158878504672897 * SIZE);
        BACKGROUND_SHAPE.setStroke(null);
        switch (CONTROL.getBackgroundDesign()) {
            default: 
        }
        BACKGROUND_SHAPE.setStyle(CONTROL.getSimpleGradientBaseColorString());
        BACKGROUND_SHAPE.setId(CONTROL.getBackgroundDesign().CSS_BACKGROUND);
        BACKGROUND_SHAPE.setEffect((Effect)INNER_SHADOW);
        BACKGROUND_SHAPE.setStroke(null);
        BACKGROUND.getChildren().addAll((Object[])new Node[]{BACKGROUND_SHAPE});
        BACKGROUND.setCache(true);
    }

    protected void drawCircularTrend(Gauge CONTROL, Group trend, Rectangle GAUGE_BOUNDS) {
        Color ledColor;
        Color ledPaint;
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        trend.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        trend.getChildren().add((Object)IBOUNDS);
        double RADIUS = 0.005 * WIDTH;
        double DIAMETER = 2.0 * RADIUS;
        double matrixOffsetX = 0.455 * WIDTH;
        double matrixOffsetY = 0.79 * WIDTH;
        switch (CONTROL.getRadialRange()) {
            case RADIAL_300: {
                matrixOffsetX = 0.455 * WIDTH;
                matrixOffsetY = 0.79 * WIDTH;
                break;
            }
            case RADIAL_270: {
                matrixOffsetX = 0.6 * WIDTH;
                matrixOffsetY = 0.72 * HEIGHT;
                break;
            }
            case RADIAL_180: {
                matrixOffsetX = 0.455 * WIDTH;
                matrixOffsetY = 0.79 * WIDTH;
                break;
            }
            case RADIAL_180N: {
                matrixOffsetX = 0.6 * WIDTH;
                matrixOffsetY = 0.45 * WIDTH;
                break;
            }
            case RADIAL_180S: {
                matrixOffsetX = 0.6 * WIDTH;
                matrixOffsetY = 0.11 * WIDTH;
                break;
            }
            case RADIAL_90: {
                matrixOffsetX = 0.455 * WIDTH;
                matrixOffsetY = 0.79 * WIDTH;
                break;
            }
            case RADIAL_90N: {
                matrixOffsetX = 0.6 * WIDTH;
                matrixOffsetY = 0.72 * WIDTH;
                break;
            }
            case RADIAL_90S: {
                matrixOffsetX = 0.6 * WIDTH;
                matrixOffsetY = 0.2 * WIDTH;
            }
        }
        Rectangle MATRIX_FRAME = new Rectangle(matrixOffsetX - 1.0, matrixOffsetY - 1.0, 0.1 * WIDTH, 0.1 * WIDTH);
        MATRIX_FRAME.setFill((Paint)new LinearGradient(0.0, matrixOffsetY - 1.0, 0.0, matrixOffsetY - 1.0 + MATRIX_FRAME.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1, (double)0.1, (double)0.1, (double)1.0)), new Stop(0.1, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(0.93, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(1.0, Color.color((double)0.86, (double)0.86, (double)0.86, (double)1.0))}));
        MATRIX_FRAME.setStroke(null);
        trend.getChildren().add((Object)MATRIX_FRAME);
        Rectangle MATRIX_BACKGROUND = new Rectangle(MATRIX_FRAME.getX() + 1.0, MATRIX_FRAME.getY() + 1.0, MATRIX_FRAME.getWidth() - 2.0, MATRIX_FRAME.getHeight() - 2.0);
        MATRIX_BACKGROUND.setFill((Paint)new LinearGradient(0.0, matrixOffsetY, 0.0, matrixOffsetY + MATRIX_FRAME.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(1.0, Color.color((double)0.1, (double)0.1, (double)0.1, (double)1.0))}));
        MATRIX_BACKGROUND.setStroke(null);
        trend.getChildren().add((Object)MATRIX_BACKGROUND);
        switch (CONTROL.getTrend()) {
            case UP: {
                ledPaint = CONTROL.getTrendUpColor();
                ledColor = CONTROL.getTrendUpColor();
                break;
            }
            case STEADY: {
                ledPaint = CONTROL.getTrendSteadyColor();
                ledColor = CONTROL.getTrendSteadyColor();
                break;
            }
            case DOWN: {
                ledPaint = CONTROL.getTrendDownColor();
                ledColor = CONTROL.getTrendDownColor();
                break;
            }
            default: {
                ledPaint = new RadialGradient(0.0, 0.0, matrixOffsetX + RADIUS, matrixOffsetY + RADIUS, RADIUS, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)102, (int)102, (int)102)), new Stop(1.0, Color.rgb((int)51, (int)51, (int)51))});
                ledColor = Color.rgb((int)75, (int)75, (int)75);
            }
        }
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.002 * WIDTH);
        INNER_SHADOW.setHeight(0.002 * WIDTH);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DropShadow GLOW_EFFECT = new DropShadow();
        GLOW_EFFECT.setInput((Effect)INNER_SHADOW);
        GLOW_EFFECT.setSpread(0.1);
        GLOW_EFFECT.setRadius(0.01 * WIDTH);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        GLOW_EFFECT.setColor(ledColor);
        double ledOffsetX = matrixOffsetX;
        double ledOffsetY = matrixOffsetY;
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                Circle led = new Circle(ledOffsetX + RADIUS, ledOffsetY + RADIUS, RADIUS);
                if (CONTROL.getTrend().ledMatrix.get(y)[x] == 1) {
                    led.setFill((Paint)new RadialGradient(0.0, 0.0, ledOffsetX + RADIUS, ledOffsetY + RADIUS, RADIUS, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ledPaint), new Stop(1.0, ledPaint.darker().darker())}));
                    led.setEffect((Effect)GLOW_EFFECT);
                } else {
                    led.setFill((Paint)new RadialGradient(0.0, 0.0, ledOffsetX + RADIUS, ledOffsetY + RADIUS, RADIUS, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)80, (int)80, (int)80)), new Stop(1.0, Color.rgb((int)50, (int)50, (int)50))}));
                    led.setEffect((Effect)INNER_SHADOW);
                }
                led.setSmooth(true);
                trend.getChildren().add((Object)led);
                ledOffsetX += DIAMETER;
            }
            ledOffsetX = matrixOffsetX;
            ledOffsetY += DIAMETER;
        }
        trend.setCache(true);
    }

    protected void drawCircularSections(Gauge CONTROL, Group SECTIONS, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        SECTIONS.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        SECTIONS.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        for (Section section : CONTROL.getSections()) {
            Shape currentSection = section.getSectionArea();
            currentSection.setFill((Paint)section.getTransparentColor());
            currentSection.setStroke(null);
            SECTIONS.getChildren().add((Object)currentSection);
        }
    }

    protected void drawCircularAreas(Gauge CONTROL, Group AREAS, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        AREAS.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        AREAS.getChildren().add((Object)IBOUNDS);
        for (Section area : CONTROL.getAreas()) {
            Shape currentArea = area.getFilledArea();
            currentArea.setFill((Paint)area.getTransparentColor());
            currentArea.setStroke(null);
            AREAS.getChildren().add((Object)currentArea);
        }
    }

    protected void drawCircularGlowOff(Group GLOW_OFF, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        GLOW_OFF.getChildren().clear();
        Path GLOW_RING = new Path();
        GLOW_RING.setFillRule(FillRule.EVEN_ODD);
        GLOW_RING.getElements().add((Object)new MoveTo(0.10747663551401869 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.10747663551401869 * WIDTH, 0.2850467289719626 * HEIGHT, 0.2850467289719626 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.10747663551401869 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.7149532710280374 * WIDTH, 0.10747663551401869 * HEIGHT, 0.8925233644859814 * WIDTH, 0.2850467289719626 * HEIGHT, 0.8925233644859814 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.8925233644859814 * WIDTH, 0.7149532710280374 * HEIGHT, 0.7149532710280374 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.8925233644859814 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.2850467289719626 * WIDTH, 0.8925233644859814 * HEIGHT, 0.10747663551401869 * WIDTH, 0.7149532710280374 * HEIGHT, 0.10747663551401869 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        GLOW_RING.getElements().add((Object)new MoveTo(0.08411214953271028 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.08411214953271028 * WIDTH, 0.7289719626168224 * HEIGHT, 0.27102803738317754 * WIDTH, 0.9158878504672897 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.7289719626168224 * WIDTH, 0.9158878504672897 * HEIGHT, 0.9158878504672897 * WIDTH, 0.7289719626168224 * HEIGHT, 0.9158878504672897 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.9158878504672897 * WIDTH, 0.27102803738317754 * HEIGHT, 0.7289719626168224 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.27102803738317754 * WIDTH, 0.08411214953271028 * HEIGHT, 0.08411214953271028 * WIDTH, 0.27102803738317754 * HEIGHT, 0.08411214953271028 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        LinearGradient GLOW_OFF_PAINT = new LinearGradient(0.5 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.9112149532710281 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.17, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(0.33, Color.color((double)0.9882352941, (double)0.9882352941, (double)0.9882352941, (double)0.4)), new Stop(0.34, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4)), new Stop(0.63, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.64, Color.color((double)0.7960784314, (double)0.7960784314, (double)0.7960784314, (double)0.4)), new Stop(0.83, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
        GLOW_RING.setFill((Paint)GLOW_OFF_PAINT);
        GLOW_RING.setStroke(null);
        Path HIGHLIGHT_LOWER_RIGHT = new Path();
        HIGHLIGHT_LOWER_RIGHT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new MoveTo(0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.794392523364486 * WIDTH, 0.8037383177570093 * HEIGHT, 0.6588785046728972 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.8925233644859814 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.6682242990654206 * WIDTH, 0.9158878504672897 * HEIGHT, 0.8084112149532711 * WIDTH, 0.822429906542056 * HEIGHT, 0.8785046728971962 * WIDTH, 0.6682242990654206 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.8785046728971962 * WIDTH, 0.6682242990654206 * HEIGHT, 0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT, 0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new ClosePath());
        HIGHLIGHT_LOWER_RIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.7336448598130841 * WIDTH, 0.8364485981308412 * HEIGHT, 0.23598130841121495 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.5490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        HIGHLIGHT_LOWER_RIGHT.setStroke(null);
        Path HIGHLIGHT_UPPER_LEFT = new Path();
        HIGHLIGHT_UPPER_LEFT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new MoveTo(0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.205607476635514 * WIDTH, 0.19626168224299065 * HEIGHT, 0.3411214953271028 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.10747663551401869 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.3317757009345794 * WIDTH, 0.08411214953271028 * HEIGHT, 0.18691588785046728 * WIDTH, 0.17757009345794392 * HEIGHT, 0.12149532710280374 * WIDTH, 0.3317757009345794 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.12149532710280374 * WIDTH, 0.3317757009345794 * HEIGHT, 0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT, 0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new ClosePath());
        HIGHLIGHT_UPPER_LEFT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.26635514018691586 * WIDTH, 0.16355140186915887 * HEIGHT, 0.23598130841121495 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        HIGHLIGHT_UPPER_LEFT.setStroke(null);
        GLOW_OFF.getChildren().addAll((Object[])new Node[]{GLOW_RING, HIGHLIGHT_LOWER_RIGHT, HIGHLIGHT_UPPER_LEFT});
        GLOW_OFF.setCache(true);
    }

    protected void drawCircularGlowOn(Gauge CONTROL, Group GLOW_ON, ArrayList<Color> GLOW_COLORS, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        GLOW_ON.getChildren().clear();
        Path GLOW_RING = new Path();
        GLOW_RING.setFillRule(FillRule.EVEN_ODD);
        GLOW_RING.getElements().add((Object)new MoveTo(0.10747663551401869 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.10747663551401869 * WIDTH, 0.2850467289719626 * HEIGHT, 0.2850467289719626 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.10747663551401869 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.7149532710280374 * WIDTH, 0.10747663551401869 * HEIGHT, 0.8925233644859814 * WIDTH, 0.2850467289719626 * HEIGHT, 0.8925233644859814 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.8925233644859814 * WIDTH, 0.7149532710280374 * HEIGHT, 0.7149532710280374 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.8925233644859814 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.2850467289719626 * WIDTH, 0.8925233644859814 * HEIGHT, 0.10747663551401869 * WIDTH, 0.7149532710280374 * HEIGHT, 0.10747663551401869 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        GLOW_RING.getElements().add((Object)new MoveTo(0.08411214953271028 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.08411214953271028 * WIDTH, 0.7289719626168224 * HEIGHT, 0.27102803738317754 * WIDTH, 0.9158878504672897 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.7289719626168224 * WIDTH, 0.9158878504672897 * HEIGHT, 0.9158878504672897 * WIDTH, 0.7289719626168224 * HEIGHT, 0.9158878504672897 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.9158878504672897 * WIDTH, 0.27102803738317754 * HEIGHT, 0.7289719626168224 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.27102803738317754 * WIDTH, 0.08411214953271028 * HEIGHT, 0.08411214953271028 * WIDTH, 0.27102803738317754 * HEIGHT, 0.08411214953271028 * WIDTH, 0.5 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        RadialGradient GLOW_ON_PAINT = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.5 * HEIGHT, 0.4158878504672897 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, GLOW_COLORS.get(0)), new Stop(0.91, GLOW_COLORS.get(1)), new Stop(0.96, GLOW_COLORS.get(2)), new Stop(1.0, GLOW_COLORS.get(3))});
        GLOW_RING.setFill((Paint)GLOW_ON_PAINT);
        GLOW_RING.setStroke(null);
        DropShadow GLOW_EFFECT = new DropShadow();
        GLOW_EFFECT.setRadius(0.15 * WIDTH);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        if (GLOW_EFFECT.colorProperty().isBound()) {
            GLOW_EFFECT.colorProperty().unbind();
        }
        GLOW_EFFECT.colorProperty().bind(CONTROL.glowColorProperty());
        GLOW_RING.setEffect((Effect)GLOW_EFFECT);
        Path HIGHLIGHT_LOWER_RIGHT = new Path();
        HIGHLIGHT_LOWER_RIGHT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new MoveTo(0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.794392523364486 * WIDTH, 0.8037383177570093 * HEIGHT, 0.6588785046728972 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.8925233644859814 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.8925233644859814 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT, 0.5 * WIDTH, 0.9158878504672897 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.6682242990654206 * WIDTH, 0.9158878504672897 * HEIGHT, 0.8084112149532711 * WIDTH, 0.822429906542056 * HEIGHT, 0.8785046728971962 * WIDTH, 0.6682242990654206 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.8785046728971962 * WIDTH, 0.6682242990654206 * HEIGHT, 0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT, 0.8598130841121495 * WIDTH, 0.6588785046728972 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new ClosePath());
        HIGHLIGHT_LOWER_RIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.7336448598130841 * WIDTH, 0.8364485981308412 * HEIGHT, 0.23598130841121495 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.5490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        HIGHLIGHT_LOWER_RIGHT.setStroke(null);
        Path HIGHLIGHT_UPPER_LEFT = new Path();
        HIGHLIGHT_UPPER_LEFT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new MoveTo(0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.205607476635514 * WIDTH, 0.19626168224299065 * HEIGHT, 0.3411214953271028 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.10747663551401869 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.10747663551401869 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.08411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.3317757009345794 * WIDTH, 0.08411214953271028 * HEIGHT, 0.18691588785046728 * WIDTH, 0.17757009345794392 * HEIGHT, 0.12149532710280374 * WIDTH, 0.3317757009345794 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new CubicCurveTo(0.12149532710280374 * WIDTH, 0.3317757009345794 * HEIGHT, 0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT, 0.14018691588785046 * WIDTH, 0.3411214953271028 * HEIGHT));
        HIGHLIGHT_UPPER_LEFT.getElements().add((Object)new ClosePath());
        HIGHLIGHT_UPPER_LEFT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.26635514018691586 * WIDTH, 0.16355140186915887 * HEIGHT, 0.23598130841121495 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        HIGHLIGHT_UPPER_LEFT.setStroke(null);
        GLOW_ON.getChildren().addAll((Object[])new Node[]{GLOW_RING, HIGHLIGHT_LOWER_RIGHT, HIGHLIGHT_UPPER_LEFT});
        GLOW_ON.setCache(true);
    }

    protected void drawCircularIndicators(Gauge CONTROL, Group INDICATORS, Point2D CENTER, Rectangle GAUGE_BOUNDS) {
        double SIZE;
        double WIDTH = SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double HEIGHT = SIZE;
        INDICATORS.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        INDICATORS.getChildren().add((Object)IBOUNDS);
        INDICATORS.getTransforms().clear();
        INDICATORS.getTransforms().add((Object)Transform.rotate((double)CONTROL.getRadialRange().ROTATION_OFFSET, (double)CENTER.getX(), (double)CENTER.getY()));
        INDICATORS.getTransforms().add((Object)Transform.rotate((double)(-CONTROL.getMinValue() * CONTROL.getAngleStep()), (double)CENTER.getX(), (double)CENTER.getY()));
        for (Marker marker : CONTROL.getMarkers()) {
            if (Double.compare(marker.getValue(), CONTROL.getMinValue()) < 0 || Double.compare(marker.getValue(), CONTROL.getMaxValue()) > 0) continue;
            Group ARROW = this.createIndicator(SIZE, marker, new Point2D(SIZE * 0.4813084112, SIZE * 0.0841121495));
            ARROW.getTransforms().add((Object)Transform.rotate((double)(marker.getValue() * CONTROL.getAngleStep()), (double)CENTER.getX(), (double)CENTER.getY()));
            INDICATORS.getChildren().add((Object)ARROW);
        }
    }

    protected void drawCircularKnobs(Gauge CONTROL, Group KNOBS, Point2D CENTER, Rectangle GAUGE_BOUNDS) {
        Point2D MAX_OFFSET;
        Point2D MIN_OFFSET;
        Group CENTER_KNOB;
        double KNOB_SIZE;
        double SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        KNOBS.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        KNOBS.getChildren().add((Object)IBOUNDS);
        DropShadow SHADOW = new DropShadow();
        SHADOW.setBlurType(BlurType.GAUSSIAN);
        SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        DropShadow POST_SHADOW = new DropShadow();
        POST_SHADOW.setBlurType(BlurType.GAUSSIAN);
        POST_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.35));
        switch (CONTROL.getKnobDesign()) {
            case BIG: {
                KNOB_SIZE = Math.ceil(WIDTH * 0.1214953271);
                CENTER_KNOB = this.createBigKnob(KNOB_SIZE, CONTROL.getKnobColor());
                break;
            }
            case METAL: {
                KNOB_SIZE = Math.ceil(WIDTH * 0.0841121495);
                CENTER_KNOB = this.createMetalKnob(KNOB_SIZE, CONTROL.getKnobColor());
                break;
            }
            case PLAIN: {
                KNOB_SIZE = Math.ceil(WIDTH * 0.0841121495);
                CENTER_KNOB = this.createPlainKnob(KNOB_SIZE, CONTROL.getKnobColor());
                break;
            }
            default: {
                KNOB_SIZE = Math.ceil(WIDTH * 0.0841121495);
                CENTER_KNOB = this.createStandardKnob(KNOB_SIZE, CONTROL.getKnobColor());
            }
        }
        Point2D CENTER_OFFSET = new Point2D(CENTER.getX() - KNOB_SIZE / 2.0, CENTER.getY() - KNOB_SIZE / 2.0);
        CENTER_KNOB.effectProperty().set((Object)SHADOW);
        CENTER_KNOB.setTranslateX(CENTER_OFFSET.getX());
        CENTER_KNOB.setTranslateY(CENTER_OFFSET.getY());
        if (CONTROL.isPointerGlowEnabled() && CONTROL.getPointerType() != Gauge.PointerType.TYPE9) {
            DropShadow GLOW = new DropShadow();
            GLOW.setWidth(0.1 * SIZE);
            GLOW.setHeight(0.1 * SIZE);
            GLOW.setOffsetX(0.0);
            GLOW.setOffsetY(0.0);
            GLOW.setRadius(0.1 * SIZE);
            GLOW.setColor(CONTROL.getValueColor().COLOR);
            GLOW.setBlurType(BlurType.GAUSSIAN);
            CENTER_KNOB.setEffect((Effect)GLOW);
        }
        Group MIN_POST = this.createStandardKnob(Math.ceil(WIDTH * 0.03738316893577576), CONTROL.getKnobColor());
        Group MAX_POST = this.createStandardKnob(Math.ceil(WIDTH * 0.03738316893577576), CONTROL.getKnobColor());
        switch (CONTROL.getRadialRange()) {
            case RADIAL_90N: {
                MIN_OFFSET = new Point2D(0.12, 0.4);
                MAX_OFFSET = new Point2D(0.845, 0.4);
                break;
            }
            case RADIAL_90W: {
                MIN_OFFSET = new Point2D(0.4, 0.845);
                MAX_OFFSET = new Point2D(0.4, 0.12);
                break;
            }
            case RADIAL_90S: {
                MIN_OFFSET = new Point2D(0.12, 0.56);
                MAX_OFFSET = new Point2D(0.845, 0.56);
                break;
            }
            case RADIAL_90E: {
                MIN_OFFSET = new Point2D(0.56, 0.845);
                MAX_OFFSET = new Point2D(0.56, 0.12);
                break;
            }
            case RADIAL_90: {
                MIN_OFFSET = new Point2D(0.13084112107753754, 0.514018714427948);
                MAX_OFFSET = new Point2D(0.5233644843101501, 0.13084112107753754);
                break;
            }
            case RADIAL_180: {
                MIN_OFFSET = new Point2D(0.13084112107753754, 0.514018714427948);
                MAX_OFFSET = new Point2D(0.8317757248878479, 0.514018714427948);
                break;
            }
            case RADIAL_180N: {
                MIN_OFFSET = new Point2D(0.13084112107753754, 0.514018714427948);
                MAX_OFFSET = new Point2D(0.8317757248878479, 0.514018714427948);
                break;
            }
            case RADIAL_180S: {
                MIN_OFFSET = new Point2D(0.13084112107753754, 0.1);
                MAX_OFFSET = new Point2D(0.8317757248878479, 0.1);
                break;
            }
            case RADIAL_270: {
                MIN_OFFSET = new Point2D(0.5233644843101501, 0.8317757248878479);
                MAX_OFFSET = new Point2D(0.8317757248878479, 0.514018714427948);
                break;
            }
            default: {
                MIN_OFFSET = new Point2D(0.336448609828949, 0.8037382960319519);
                MAX_OFFSET = new Point2D(0.6261682510375977, 0.8037382960319519);
            }
        }
        MIN_POST.setEffect((Effect)POST_SHADOW);
        MAX_POST.setEffect((Effect)POST_SHADOW);
        MIN_POST.setTranslateX(WIDTH * MIN_OFFSET.getX());
        MIN_POST.setTranslateY(WIDTH * MIN_OFFSET.getY());
        MAX_POST.setTranslateX(WIDTH * MAX_OFFSET.getX());
        MAX_POST.setTranslateY(WIDTH * MAX_OFFSET.getY());
        if (MIN_POST.visibleProperty().isBound()) {
            MIN_POST.visibleProperty().unbind();
        }
        MIN_POST.visibleProperty().bind((ObservableValue)CONTROL.postsVisibleProperty());
        if (MAX_POST.visibleProperty().isBound()) {
            MAX_POST.visibleProperty().unbind();
        }
        MAX_POST.visibleProperty().bind((ObservableValue)CONTROL.postsVisibleProperty());
        KNOBS.getChildren().addAll((Object[])new Node[]{CENTER_KNOB, MIN_POST, MAX_POST});
    }

    protected void drawCircularLed(Gauge CONTROL, Group LED_OFF, Group LED_ON, Rectangle GAUGE_BOUNDS) {
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        LED_OFF.getChildren().clear();
        Rectangle IBOUNDS_OFF = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_OFF.setOpacity(0.0);
        IBOUNDS_OFF.setStroke(null);
        Group LED_OFF_GROUP = this.createLed(WIDTH * 0.1, CONTROL.getLedColor(), false);
        LED_OFF_GROUP.setLayoutX(WIDTH * CONTROL.getLedPosition().getX());
        LED_OFF_GROUP.setLayoutY(WIDTH * CONTROL.getLedPosition().getY());
        LED_OFF.getChildren().addAll((Object[])new Node[]{IBOUNDS_OFF, LED_OFF_GROUP});
        LED_OFF.setCache(true);
        LED_ON.getChildren().clear();
        Rectangle IBOUNDS_ON = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_ON.setOpacity(0.0);
        IBOUNDS_ON.setStroke(null);
        Group LED_ON_GROUP = this.createLed(WIDTH * 0.1, CONTROL.getLedColor(), true);
        LED_ON_GROUP.setLayoutX(WIDTH * CONTROL.getLedPosition().getX());
        LED_ON_GROUP.setLayoutY(WIDTH * CONTROL.getLedPosition().getY());
        LED_ON.getChildren().addAll((Object[])new Node[]{IBOUNDS_ON, LED_ON_GROUP});
        LED_ON.setCache(true);
    }

    protected void drawCircularUserLed(Gauge CONTROL, Group USER_LED_OFF, Group USER_LED_ON, Rectangle GAUGE_BOUNDS) {
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        USER_LED_OFF.getChildren().clear();
        Rectangle IBOUNDS_OFF = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_OFF.setOpacity(0.0);
        IBOUNDS_OFF.setStroke(null);
        Group LED_OFF_GROUP = this.createLed(WIDTH * 0.1, CONTROL.getUserLedColor(), false);
        LED_OFF_GROUP.setLayoutX(WIDTH * CONTROL.getUserLedPosition().getX());
        LED_OFF_GROUP.setLayoutY(WIDTH * CONTROL.getUserLedPosition().getY());
        USER_LED_OFF.getChildren().addAll((Object[])new Node[]{IBOUNDS_OFF, LED_OFF_GROUP});
        USER_LED_ON.getChildren().clear();
        Rectangle IBOUNDS_ON = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_ON.setOpacity(0.0);
        IBOUNDS_ON.setStroke(null);
        Group LED_ON_GROUP = this.createLed(WIDTH * 0.1, CONTROL.getUserLedColor(), true);
        LED_ON_GROUP.setLayoutX(WIDTH * CONTROL.getUserLedPosition().getX());
        LED_ON_GROUP.setLayoutY(WIDTH * CONTROL.getUserLedPosition().getY());
        USER_LED_ON.getChildren().addAll((Object[])new Node[]{IBOUNDS_ON, LED_ON_GROUP});
    }

    protected void drawCircularLcd(Gauge CONTROL, Group LCD, Rectangle GAUGE_BOUNDS) {
        double SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        LCD.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        LCD.getChildren().add((Object)IBOUNDS);
        Rectangle LCD_FRAME = new Rectangle((SIZE - SIZE * CONTROL.getRadialRange().LCD_FACTORS.getX()) / 2.0, SIZE * CONTROL.getRadialRange().LCD_FACTORS.getY(), SIZE * CONTROL.getRadialRange().LCD_FACTORS.getWidth(), SIZE * CONTROL.getRadialRange().LCD_FACTORS.getHeight());
        double LCD_FRAME_CORNER_RADIUS = LCD_FRAME.getWidth() > LCD_FRAME.getHeight() ? LCD_FRAME.getHeight() * 0.15 : LCD_FRAME.getWidth() * 0.15;
        LCD_FRAME.arcWidthProperty().set(LCD_FRAME_CORNER_RADIUS);
        LCD_FRAME.arcHeightProperty().set(LCD_FRAME_CORNER_RADIUS);
        LinearGradient LCD_FRAME_FILL = new LinearGradient(0.0, LCD_FRAME.getLayoutBounds().getMinY(), 0.0, LCD_FRAME.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1, (double)0.1, (double)0.1, (double)1.0)), new Stop(0.1, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(0.93, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(1.0, Color.color((double)0.86, (double)0.86, (double)0.86, (double)1.0))});
        LCD_FRAME.setFill((Paint)LCD_FRAME_FILL);
        LCD_FRAME.setStroke(null);
        Rectangle LCD_MAIN = new Rectangle(LCD_FRAME.getX() + 1.0, LCD_FRAME.getY() + 1.0, LCD_FRAME.getWidth() - 2.0, LCD_FRAME.getHeight() - 2.0);
        double LCD_MAIN_CORNER_RADIUS = LCD_FRAME.getArcWidth() - 1.0;
        LCD_MAIN.setArcWidth(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.setArcHeight(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.getStyleClass().add((Object)"lcd");
        LCD_MAIN.setStyle(CONTROL.getLcdDesign().CSS);
        LCD_MAIN.setId("lcd-main");
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setWidth(0.25 * LCD_FRAME.getHeight());
        INNER_GLOW.setHeight(0.25 * LCD_FRAME.getHeight());
        INNER_GLOW.setOffsetY(-0.05 * LCD_FRAME.getHeight());
        INNER_GLOW.setOffsetX(0.0);
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2));
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setInput((Effect)INNER_GLOW);
        INNER_SHADOW.setWidth(0.15 * LCD_FRAME.getHeight());
        INNER_SHADOW.setHeight(0.15 * LCD_FRAME.getHeight());
        INNER_SHADOW.setOffsetY(0.025 * LCD_FRAME.getHeight());
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        LCD_MAIN.setEffect((Effect)INNER_SHADOW);
        LCD.getChildren().addAll((Object[])new Node[]{LCD_FRAME, LCD_MAIN});
    }

    protected void drawCircularBargraph(Gauge CONTROL, Group BARGRAPH, int NO_OF_LEDS, ArrayList<Shape> LEDS, boolean ON, boolean VISIBLE, Point2D CENTER, Rectangle GAUGE_BOUNDS) {
        double ADDITIONAL_OFFSET;
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        BARGRAPH.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        BARGRAPH.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        switch (CONTROL.getRadialRange()) {
            case RADIAL_90: {
                ADDITIONAL_OFFSET = 180.0;
                break;
            }
            case RADIAL_180: {
                ADDITIONAL_OFFSET = 90.0;
                break;
            }
            case RADIAL_180N: {
                ADDITIONAL_OFFSET = 90.0;
                break;
            }
            case RADIAL_180S: {
                ADDITIONAL_OFFSET = -90.0;
                break;
            }
            case RADIAL_270: {
                ADDITIONAL_OFFSET = 180.0;
                break;
            }
            default: {
                ADDITIONAL_OFFSET = 90.0;
            }
        }
        LEDS.clear();
        for (int i = 0; i < NO_OF_LEDS; ++i) {
            Shape LED = this.createBargraphLed(GAUGE_BOUNDS, CONTROL, ON);
            LED.getTransforms().add((Object)Transform.rotate((double)(CONTROL.getRadialRange().SECTIONS_OFFSET - ADDITIONAL_OFFSET - 2.5 - (double)(5 * i)), (double)CENTER.getX(), (double)CENTER.getY()));
            LED.setVisible(VISIBLE);
            LEDS.add(LED);
            BARGRAPH.getChildren().add((Object)LED);
        }
        BARGRAPH.setCache(true);
    }

    protected void drawCircularForeground(Gauge CONTROL, Group FOREGROUND, Rectangle GAUGE_BOUNDS) {
        double SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        FOREGROUND.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        FOREGROUND.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        Path FOREGROUND_SHAPE = new Path();
        switch (CONTROL.getForegroundType()) {
            case TYPE2: {
                FOREGROUND_SHAPE.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND_SHAPE.getElements().add((Object)new MoveTo(0.13551401869158877 * SIZE, 0.6962616822429907 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.21495327102803738 * SIZE, 0.5887850467289719 * SIZE, 0.3177570093457944 * SIZE, 0.5 * SIZE, 0.46261682242990654 * SIZE, 0.4252336448598131 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.6121495327102804 * SIZE, 0.34579439252336447 * SIZE, 0.7336448598130841 * SIZE, 0.3177570093457944 * SIZE, 0.8738317757009346 * SIZE, 0.32242990654205606 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.7663551401869159 * SIZE, 0.11214953271028037 * SIZE, 0.5280373831775701 * SIZE, 0.02336448598130841 * SIZE, 0.3130841121495327 * SIZE, 0.1308411214953271 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.09813084112149532 * SIZE, 0.2383177570093458 * SIZE, 0.028037383177570093 * SIZE, 0.48598130841121495 * SIZE, 0.13551401869158877 * SIZE, 0.6962616822429907 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setId("foreground-type2");
                FOREGROUND_SHAPE.setStroke(null);
                FOREGROUND.getChildren().addAll((Object[])new Node[]{FOREGROUND_SHAPE});
                break;
            }
            case TYPE3: {
                FOREGROUND_SHAPE.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND_SHAPE.getElements().add((Object)new MoveTo(0.08411214953271028 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.2102803738317757 * SIZE, 0.5560747663551402 * SIZE, 0.46261682242990654 * SIZE, 0.5607476635514018 * SIZE, 0.5 * SIZE, 0.5607476635514018 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.5373831775700935 * SIZE, 0.5607476635514018 * SIZE, 0.794392523364486 * SIZE, 0.5607476635514018 * SIZE, 0.9158878504672897 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.9158878504672897 * SIZE, 0.2757009345794392 * SIZE, 0.7383177570093458 * SIZE, 0.08411214953271028 * SIZE, 0.5 * SIZE, 0.08411214953271028 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.2616822429906542 * SIZE, 0.08411214953271028 * SIZE, 0.08411214953271028 * SIZE, 0.2757009345794392 * SIZE, 0.08411214953271028 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setId("foreground-type3");
                FOREGROUND_SHAPE.setStroke(null);
                FOREGROUND.getChildren().addAll((Object[])new Node[]{FOREGROUND_SHAPE});
                break;
            }
            case TYPE4: {
                FOREGROUND_SHAPE.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND_SHAPE.getElements().add((Object)new MoveTo(0.677570093457944 * SIZE, 0.24299065420560748 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.7710280373831776 * SIZE, 0.308411214953271 * SIZE, 0.822429906542056 * SIZE, 0.411214953271028 * SIZE, 0.8130841121495327 * SIZE, 0.5280373831775701 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.7990654205607477 * SIZE, 0.6542056074766355 * SIZE, 0.719626168224299 * SIZE, 0.7570093457943925 * SIZE, 0.5934579439252337 * SIZE, 0.7990654205607477 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.48598130841121495 * SIZE, 0.8317757009345794 * SIZE, 0.3691588785046729 * SIZE, 0.8084112149532711 * SIZE, 0.2850467289719626 * SIZE, 0.7289719626168224 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.2757009345794392 * SIZE, 0.719626168224299 * SIZE, 0.2523364485981308 * SIZE, 0.7149532710280374 * SIZE, 0.2336448598130841 * SIZE, 0.7289719626168224 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.21495327102803738 * SIZE, 0.7476635514018691 * SIZE, 0.21962616822429906 * SIZE, 0.7710280373831776 * SIZE, 0.22897196261682243 * SIZE, 0.7757009345794392 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.3317757009345794 * SIZE, 0.8785046728971962 * SIZE, 0.4766355140186916 * SIZE, 0.9158878504672897 * SIZE, 0.616822429906542 * SIZE, 0.8691588785046729 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.7710280373831776 * SIZE, 0.822429906542056 * SIZE, 0.8738317757009346 * SIZE, 0.6915887850467289 * SIZE, 0.8878504672897196 * SIZE, 0.5327102803738317 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.897196261682243 * SIZE, 0.3878504672897196 * SIZE, 0.8364485981308412 * SIZE, 0.2570093457943925 * SIZE, 0.719626168224299 * SIZE, 0.1822429906542056 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.705607476635514 * SIZE, 0.17289719626168223 * SIZE, 0.6822429906542056 * SIZE, 0.16355140186915887 * SIZE, 0.6635514018691588 * SIZE, 0.18691588785046728 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.6542056074766355 * SIZE, 0.205607476635514 * SIZE, 0.6682242990654206 * SIZE, 0.2383177570093458 * SIZE, 0.677570093457944 * SIZE, 0.24299065420560748 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * SIZE, 0.5 * SIZE, 0.3878504672897196 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.83, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157))}));
                FOREGROUND_SHAPE.setStroke(null);
                Path FOREGROUND1_PATH = new Path();
                FOREGROUND1_PATH.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND1_PATH.getElements().add((Object)new MoveTo(0.2616822429906542 * SIZE, 0.22429906542056074 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.2850467289719626 * SIZE, 0.2383177570093458 * SIZE, 0.2523364485981308 * SIZE, 0.2850467289719626 * SIZE, 0.24299065420560748 * SIZE, 0.3177570093457944 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.24299065420560748 * SIZE, 0.35046728971962615 * SIZE, 0.27102803738317754 * SIZE, 0.38317757009345793 * SIZE, 0.27102803738317754 * SIZE, 0.397196261682243 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.2757009345794392 * SIZE, 0.4158878504672897 * SIZE, 0.2616822429906542 * SIZE, 0.45794392523364486 * SIZE, 0.2383177570093458 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.22429906542056074 * SIZE, 0.5420560747663551 * SIZE, 0.17757009345794392 * SIZE, 0.6121495327102804 * SIZE, 0.1588785046728972 * SIZE, 0.6121495327102804 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.14485981308411214 * SIZE, 0.6121495327102804 * SIZE, 0.08878504672897196 * SIZE, 0.5467289719626168 * SIZE, 0.1308411214953271 * SIZE, 0.3691588785046729 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new CubicCurveTo(0.14018691588785046 * SIZE, 0.3364485981308411 * SIZE, 0.21495327102803738 * SIZE, 0.20093457943925233 * SIZE, 0.2616822429906542 * SIZE, 0.22429906542056074 * SIZE));
                FOREGROUND1_PATH.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setId("foreground-type4");
                FOREGROUND1_PATH.setStroke(null);
                FOREGROUND.getChildren().addAll((Object[])new Node[]{FOREGROUND_SHAPE, FOREGROUND1_PATH});
                break;
            }
            case TYPE5: {
                FOREGROUND_SHAPE.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND_SHAPE.getElements().add((Object)new MoveTo(0.08411214953271028 * SIZE, 0.5 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.08411214953271028 * SIZE, 0.27102803738317754 * SIZE, 0.27102803738317754 * SIZE, 0.08411214953271028 * SIZE, 0.5 * SIZE, 0.08411214953271028 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.7009345794392523 * SIZE, 0.08411214953271028 * SIZE, 0.8644859813084113 * SIZE, 0.22429906542056074 * SIZE, 0.9065420560747663 * SIZE, 0.411214953271028 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.9112149532710281 * SIZE, 0.4392523364485981 * SIZE, 0.9112149532710281 * SIZE, 0.5186915887850467 * SIZE, 0.8457943925233645 * SIZE, 0.5373831775700935 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.794392523364486 * SIZE, 0.5467289719626168 * SIZE, 0.5514018691588785 * SIZE, 0.411214953271028 * SIZE, 0.3925233644859813 * SIZE, 0.45794392523364486 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.16822429906542055 * SIZE, 0.5093457943925234 * SIZE, 0.13551401869158877 * SIZE, 0.7757009345794392 * SIZE, 0.09345794392523364 * SIZE, 0.5934579439252337 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.08878504672897196 * SIZE, 0.5607476635514018 * SIZE, 0.08411214953271028 * SIZE, 0.5327102803738317 * SIZE, 0.08411214953271028 * SIZE, 0.5 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setId("foreground-type5");
                FOREGROUND_SHAPE.setStroke(null);
                FOREGROUND.getChildren().addAll((Object[])new Node[]{FOREGROUND_SHAPE});
                break;
            }
            default: {
                FOREGROUND_SHAPE.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND_SHAPE.getElements().add((Object)new MoveTo(0.08411214953271028 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.205607476635514 * SIZE, 0.4485981308411215 * SIZE, 0.3364485981308411 * SIZE, 0.4158878504672897 * SIZE, 0.5 * SIZE, 0.4158878504672897 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.6728971962616822 * SIZE, 0.4158878504672897 * SIZE, 0.7897196261682243 * SIZE, 0.4439252336448598 * SIZE, 0.9158878504672897 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.9158878504672897 * SIZE, 0.2757009345794392 * SIZE, 0.7383177570093458 * SIZE, 0.08411214953271028 * SIZE, 0.5 * SIZE, 0.08411214953271028 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new CubicCurveTo(0.2616822429906542 * SIZE, 0.08411214953271028 * SIZE, 0.08411214953271028 * SIZE, 0.2757009345794392 * SIZE, 0.08411214953271028 * SIZE, 0.5093457943925234 * SIZE));
                FOREGROUND_SHAPE.getElements().add((Object)new ClosePath());
                FOREGROUND_SHAPE.setId("foreground-type1");
                FOREGROUND_SHAPE.setStroke(null);
                FOREGROUND.getChildren().addAll((Object[])new Node[]{FOREGROUND_SHAPE});
            }
        }
        FOREGROUND.setCache(true);
    }

    protected void drawCircularTickmarks(Gauge CONTROL, Group TICKMARKS, Point2D CENTER, Rectangle GAUGE_BOUNDS) {
        double TEXT_BAR_GRAPH_OFFSET;
        double TEXT_DISTANCE_FACTOR;
        double SIZE = GAUGE_BOUNDS.getWidth() <= GAUGE_BOUNDS.getHeight() ? GAUGE_BOUNDS.getWidth() : GAUGE_BOUNDS.getHeight();
        double WIDTH = GAUGE_BOUNDS.getWidth();
        double HEIGHT = GAUGE_BOUNDS.getHeight();
        double RADIUS_FACTOR = CONTROL.getRadialRange().RADIUS_FACTOR;
        switch (CONTROL.getTickLabelOrientation()) {
            case TANGENT: {
                TEXT_DISTANCE_FACTOR = 0.07;
                break;
            }
            case HORIZONTAL: {
                TEXT_DISTANCE_FACTOR = 0.08;
                break;
            }
            default: {
                TEXT_DISTANCE_FACTOR = 0.09;
            }
        }
        TICKMARKS.getTransforms().clear();
        TICKMARKS.getChildren().clear();
        TICKMARKS.setId(CONTROL.getBackgroundDesign().CSS_BACKGROUND);
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        TICKMARKS.getChildren().add((Object)IBOUNDS);
        Path MAJOR_TICK_MARKS_PATH = new Path();
        MAJOR_TICK_MARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MAJOR_TICK_MARKS_PATH.setSmooth(true);
        MAJOR_TICK_MARKS_PATH.setStrokeType(StrokeType.CENTERED);
        MAJOR_TICK_MARKS_PATH.setStrokeLineCap(StrokeLineCap.ROUND);
        MAJOR_TICK_MARKS_PATH.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        MAJOR_TICK_MARKS_PATH.setStrokeWidth(0.0046728972 * WIDTH);
        switch (CONTROL.getMajorTickmarkType()) {
            case TRIANGLE: {
                MAJOR_TICK_MARKS_PATH.setId(CONTROL.getBackgroundDesign().CSS_TEXT);
                break;
            }
            default: {
                MAJOR_TICK_MARKS_PATH.setId(CONTROL.getBackgroundDesign().CSS_BACKGROUND);
            }
        }
        Path MEDIUM_TICK_MARKS_PATH = new Path();
        MEDIUM_TICK_MARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MEDIUM_TICK_MARKS_PATH.setSmooth(true);
        MEDIUM_TICK_MARKS_PATH.setStrokeType(StrokeType.CENTERED);
        MEDIUM_TICK_MARKS_PATH.setStrokeLineCap(StrokeLineCap.ROUND);
        MEDIUM_TICK_MARKS_PATH.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        MEDIUM_TICK_MARKS_PATH.setStrokeWidth(0.0023364486 * WIDTH);
        MEDIUM_TICK_MARKS_PATH.setId(CONTROL.getBackgroundDesign().CSS_BACKGROUND);
        Path MINOR_TICK_MARKS_PATH = new Path();
        MINOR_TICK_MARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MINOR_TICK_MARKS_PATH.setSmooth(true);
        MINOR_TICK_MARKS_PATH.setStrokeType(StrokeType.CENTERED);
        MINOR_TICK_MARKS_PATH.setStrokeLineCap(StrokeLineCap.ROUND);
        MINOR_TICK_MARKS_PATH.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        MINOR_TICK_MARKS_PATH.setStrokeWidth(0.0014018692 * WIDTH);
        MINOR_TICK_MARKS_PATH.setId(CONTROL.getBackgroundDesign().CSS_BACKGROUND);
        if (CONTROL.isBargraph()) {
            MAJOR_TICK_MARKS_PATH.setVisible(false);
            MEDIUM_TICK_MARKS_PATH.setVisible(false);
            MINOR_TICK_MARKS_PATH.setVisible(false);
            TEXT_BAR_GRAPH_OFFSET = 0.03;
        } else {
            MAJOR_TICK_MARKS_PATH.setVisible(true);
            MEDIUM_TICK_MARKS_PATH.setVisible(true);
            MINOR_TICK_MARKS_PATH.setVisible(true);
            TEXT_BAR_GRAPH_OFFSET = 0.0;
        }
        ArrayList<Text> tickMarkLabel = new ArrayList<Text>();
        Gauge.NumberFormat numberFormat = CONTROL.getTickLabelNumberFormat() == Gauge.NumberFormat.AUTO ? (Math.abs(CONTROL.getMajorTickSpacing()) > 1000 ? Gauge.NumberFormat.SCIENTIFIC : ((double)CONTROL.getMajorTickSpacing() % 1.0 != 0.0 ? Gauge.NumberFormat.FRACTIONAL : Gauge.NumberFormat.STANDARD)) : CONTROL.getTickLabelNumberFormat();
        Font STD_FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.035 * WIDTH));
        double TEXT_DISTANCE = (TEXT_DISTANCE_FACTOR + TEXT_BAR_GRAPH_OFFSET) * WIDTH;
        double ticklabelRotationOffset = 0.0;
        double MINOR_TICK_LENGTH = 0.0133333333 * WIDTH;
        double MEDIUM_TICK_LENGTH = 0.02 * WIDTH;
        double MAJOR_TICK_LENGTH = 0.03 * WIDTH;
        double ROTATION_OFFSET = CONTROL.getRadialRange().ROTATION_OFFSET;
        double RADIUS = WIDTH * RADIUS_FACTOR;
        double ANGLE_STEP = CONTROL.getRadialRange().ANGLE_RANGE / ((CONTROL.getMaxValue() - CONTROL.getMinValue()) / (double)CONTROL.getMinorTickSpacing()) * CONTROL.getRadialRange().ANGLE_STEP_SIGN;
        double valueCounter = CONTROL.getMinValue();
        int majorTickCounter = CONTROL.getMaxNoOfMinorTicks() - 1;
        if (CONTROL.getTickmarksOffset() != null) {
            TICKMARKS.translateXProperty().set(CONTROL.getTickmarksOffset().getX());
            TICKMARKS.translateYProperty().set(CONTROL.getTickmarksOffset().getY());
        }
        Rotate transform = Transform.rotate((double)(ROTATION_OFFSET - 180.0), (double)CENTER.getX(), (double)CENTER.getY());
        TICKMARKS.getTransforms().add((Object)transform);
        double alpha = 0.0;
        double counter = CONTROL.getMinValue();
        while (Double.compare(counter, CONTROL.getMaxValue()) <= 0) {
            Point2D outerPoint;
            Point2D innerPoint;
            double sinValue = Math.sin(Math.toRadians(alpha));
            double cosValue = Math.cos(Math.toRadians(alpha));
            if (++majorTickCounter == CONTROL.getMaxNoOfMinorTicks()) {
                innerPoint = new Point2D(CENTER.getX() + (RADIUS - MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (RADIUS - MAJOR_TICK_LENGTH) * cosValue);
                outerPoint = new Point2D(CENTER.getX() + RADIUS * sinValue, CENTER.getY() + RADIUS * cosValue);
                Point2D textPoint = new Point2D(CENTER.getX() + (RADIUS - TEXT_DISTANCE) * sinValue, CENTER.getY() + (RADIUS - TEXT_DISTANCE) * cosValue);
                if (CONTROL.isTickmarksVisible() && CONTROL.isMajorTicksVisible()) {
                    switch (CONTROL.getMajorTickmarkType()) {
                        case TRIANGLE: {
                            Point2D outerPointLeft = new Point2D(CENTER.getX() + RADIUS * Math.sin(Math.toRadians(alpha - 1.2)), CENTER.getY() + RADIUS * Math.cos(Math.toRadians(alpha - 1.2)));
                            Point2D outerPointRight = new Point2D(CENTER.getX() + RADIUS * Math.sin(Math.toRadians(alpha + 1.2)), CENTER.getY() + RADIUS * Math.cos(Math.toRadians(alpha + 1.2)));
                            MAJOR_TICK_MARKS_PATH.getElements().add((Object)new MoveTo(innerPoint.getX(), innerPoint.getY()));
                            MAJOR_TICK_MARKS_PATH.getElements().add((Object)new LineTo(outerPointLeft.getX(), outerPointLeft.getY()));
                            MAJOR_TICK_MARKS_PATH.getElements().add((Object)new LineTo(outerPointRight.getX(), outerPointRight.getY()));
                            MAJOR_TICK_MARKS_PATH.getElements().add((Object)new ClosePath());
                            break;
                        }
                        default: {
                            GaugeSkinBase.drawRadialTicks(MAJOR_TICK_MARKS_PATH, innerPoint, outerPoint);
                        }
                    }
                }
                if (CONTROL.isTickLabelsVisible()) {
                    Text tickLabel = new Text(numberFormat.format(valueCounter));
                    tickLabel.setFontSmoothingType(FontSmoothingType.LCD);
                    tickLabel.setTextOrigin(VPos.BOTTOM);
                    tickLabel.setBoundsType(TextBoundsType.LOGICAL);
                    tickLabel.setId(CONTROL.getBackgroundDesign().CSS_TEXT);
                    tickLabel.setStroke(null);
                    tickLabel.setFont(STD_FONT);
                    tickLabel.setX(textPoint.getX() - tickLabel.getLayoutBounds().getHeight() / 2.0);
                    tickLabel.setY(textPoint.getY() + tickLabel.getLayoutBounds().getHeight() / 2.0);
                    switch (CONTROL.getTickLabelOrientation()) {
                        case NORMAL: {
                            if (Double.compare(alpha, -CONTROL.getRadialRange().TICKLABEL_ORIENATION_CHANGE_ANGLE) > 0) {
                                tickLabel.rotateProperty().set(-90.0 - alpha);
                                break;
                            }
                            tickLabel.rotateProperty().set(90.0 - alpha);
                            break;
                        }
                        case HORIZONTAL: {
                            tickLabel.rotateProperty().set(180.0 - CONTROL.getRadialRange().ROTATION_OFFSET);
                            break;
                        }
                        default: {
                            tickLabel.rotateProperty().set(180.0 - alpha + 0.0);
                        }
                    }
                    tickMarkLabel.add(tickLabel);
                }
                valueCounter += (double)CONTROL.getMajorTickSpacing();
                majorTickCounter = 0;
            } else {
                innerPoint = new Point2D(CENTER.getX() + (RADIUS - MINOR_TICK_LENGTH) * sinValue, CENTER.getY() + (RADIUS - MINOR_TICK_LENGTH) * cosValue);
                outerPoint = new Point2D(CENTER.getX() + RADIUS * sinValue, CENTER.getY() + RADIUS * cosValue);
                if (CONTROL.getMaxNoOfMinorTicks() % 2 == 0 && majorTickCounter == CONTROL.getMaxNoOfMinorTicks() / 2) {
                    innerPoint = new Point2D(CENTER.getX() + (RADIUS - MEDIUM_TICK_LENGTH) * sinValue, CENTER.getY() + (RADIUS - MEDIUM_TICK_LENGTH) * cosValue);
                    outerPoint = new Point2D(CENTER.getX() + RADIUS * sinValue, CENTER.getY() + RADIUS * cosValue);
                    if (CONTROL.isTickmarksVisible() && CONTROL.isMinorTicksVisible()) {
                        GaugeSkinBase.drawRadialTicks(MEDIUM_TICK_MARKS_PATH, innerPoint, outerPoint);
                    }
                } else if (CONTROL.isTickmarksVisible() && CONTROL.isMinorTicksVisible()) {
                    GaugeSkinBase.drawRadialTicks(MINOR_TICK_MARKS_PATH, innerPoint, outerPoint);
                }
            }
            alpha -= ANGLE_STEP;
            counter += (double)CONTROL.getMinorTickSpacing();
        }
        if (CONTROL.isTickmarkGlowEnabled()) {
            InnerShadow INNER_GLOW = new InnerShadow();
            INNER_GLOW.setWidth(0.005 * SIZE);
            INNER_GLOW.setHeight(0.005 * SIZE);
            INNER_GLOW.setOffsetX(0.0);
            INNER_GLOW.setOffsetY(0.0);
            INNER_GLOW.setRadius(0.005 * SIZE);
            INNER_GLOW.setColor(CONTROL.getTickmarkGlowColor());
            INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
            DropShadow OUTER_GLOW = new DropShadow();
            OUTER_GLOW.setWidth(0.02 * SIZE);
            OUTER_GLOW.setHeight(0.02 * SIZE);
            OUTER_GLOW.setOffsetX(0.0);
            OUTER_GLOW.setOffsetY(0.0);
            OUTER_GLOW.setRadius(0.02 * SIZE);
            OUTER_GLOW.setColor(CONTROL.getTickmarkGlowColor());
            OUTER_GLOW.setBlurType(BlurType.GAUSSIAN);
            OUTER_GLOW.inputProperty().set((Object)INNER_GLOW);
            MAJOR_TICK_MARKS_PATH.setEffect((Effect)OUTER_GLOW);
            MEDIUM_TICK_MARKS_PATH.setEffect((Effect)OUTER_GLOW);
            MINOR_TICK_MARKS_PATH.setEffect((Effect)OUTER_GLOW);
            for (Text text : tickMarkLabel) {
                text.setEffect((Effect)OUTER_GLOW);
            }
        }
        TICKMARKS.getChildren().addAll((Object[])new Node[]{MAJOR_TICK_MARKS_PATH, MEDIUM_TICK_MARKS_PATH, MINOR_TICK_MARKS_PATH});
        TICKMARKS.getChildren().addAll(tickMarkLabel);
        TICKMARKS.setCache(true);
    }

    private static void drawRadialTicks(Path TICKMARKS_PATH, Point2D INNER_POINT, Point2D OUTER_POINT) {
        TICKMARKS_PATH.getElements().add((Object)new MoveTo(INNER_POINT.getX(), INNER_POINT.getY()));
        TICKMARKS_PATH.getElements().add((Object)new LineTo(OUTER_POINT.getX(), OUTER_POINT.getY()));
    }

    protected Group createLed(double SIZE, LedColor LED_COLOR, boolean isOn) {
        Group LED = new Group();
        Circle LED_BACKGROUND = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.25 * SIZE);
        LED_BACKGROUND.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.9)), new Stop(0.4, Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.96)), new Stop(1.0, Color.color((double)0.6, (double)0.6, (double)0.6, (double)1.0))}));
        LED_BACKGROUND.setStroke(null);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.blurTypeProperty().set((Object)BlurType.GAUSSIAN);
        INNER_SHADOW.setRadius(10.0);
        INNER_SHADOW.setWidth(0.2 * SIZE);
        INNER_SHADOW.setHeight(0.2 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        DropShadow GLOW_EFFECT = new DropShadow();
        GLOW_EFFECT.setInput((Effect)INNER_SHADOW);
        GLOW_EFFECT.setSpread(0.6);
        GLOW_EFFECT.setWidth(2.0 * SIZE);
        GLOW_EFFECT.setHeight(2.0 * SIZE);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        GLOW_EFFECT.setColor(LED_COLOR.GLOW_COLOR);
        Circle MAIN_LED = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.2261904762 * SIZE);
        if (isOn) {
            MAIN_LED.getStyleClass().add((Object)"root");
            MAIN_LED.setStyle(LED_COLOR.CSS);
            MAIN_LED.setId("led-on-gradient");
            MAIN_LED.setStroke(null);
            MAIN_LED.setEffect((Effect)GLOW_EFFECT);
        } else {
            MAIN_LED.getStyleClass().add((Object)"root");
            MAIN_LED.setStyle(LED_COLOR.CSS);
            MAIN_LED.setId("led-off-gradient");
            MAIN_LED.setStroke(null);
            MAIN_LED.effectProperty().set((Object)INNER_SHADOW);
        }
        Circle LED_INNER_SHADOW = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.2261904762 * SIZE);
        LED_INNER_SHADOW.setFill((Paint)new RadialGradient(0.0, 0.0, 0.47619047619047616 * SIZE, 0.47619047619047616 * SIZE, 0.4523809523809524 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(0.86, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.3450980392)), new Stop(1.0, new Color(0.0, 0.0, 0.0, 0.4))}));
        LED_INNER_SHADOW.setStroke(null);
        Ellipse LED_HIGHLIGHT = new Ellipse(0.5 * SIZE, 0.4 * SIZE, 0.1 * SIZE, 0.06 * SIZE);
        LED_HIGHLIGHT.setFill((Paint)new LinearGradient(0.0, 0.3 * SIZE, 0.0, 0.5 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, new Color(1.0, 1.0, 1.0, 0.4)), new Stop(1.0, new Color(1.0, 1.0, 1.0, 0.0))}));
        LED_HIGHLIGHT.setStroke(null);
        LED.getChildren().addAll((Object[])new Node[]{LED_BACKGROUND, MAIN_LED, LED_HIGHLIGHT});
        return LED;
    }

    protected Group createIndicator(double SIZE, Marker MARKER, Point2D OFFSET) {
        Group INDICATOR_GROUP = new Group();
        double WIDTH = SIZE * 0.04;
        double HEIGHT = SIZE * 0.1;
        INDICATOR_GROUP.getChildren().add((Object)this.createIndicatorShape(WIDTH, HEIGHT, MARKER, OFFSET));
        return INDICATOR_GROUP;
    }

    protected Shape createIndicatorShape(double WIDTH, double HEIGHT, Marker INDICATOR, Point2D OFFSET) {
        Path MARKER = new Path();
        MARKER.setFillRule(FillRule.EVEN_ODD);
        MARKER.getElements().add((Object)new MoveTo(WIDTH * 0.1111111111111111, HEIGHT * 0.047619047619047616));
        MARKER.getElements().add((Object)new LineTo(WIDTH * 0.8888888888888888, HEIGHT * 0.047619047619047616));
        MARKER.getElements().add((Object)new LineTo(WIDTH * 0.8888888888888888, HEIGHT * 0.3333333333333333));
        MARKER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.5714285714285714));
        MARKER.getElements().add((Object)new LineTo(WIDTH * 0.1111111111111111, HEIGHT * 0.3333333333333333));
        MARKER.getElements().add((Object)new ClosePath());
        MARKER.setStroke((Paint)Color.WHITE);
        MARKER.setStrokeType(StrokeType.CENTERED);
        MARKER.setStrokeLineCap(StrokeLineCap.ROUND);
        MARKER.setStrokeLineJoin(StrokeLineJoin.ROUND);
        MARKER.setStrokeWidth(0.02 * HEIGHT);
        LinearGradient HL_GRADIENT = new LinearGradient(MARKER.getLayoutX(), 0.0, MARKER.getLayoutX() + MARKER.getLayoutBounds().getWidth(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, INDICATOR.getColor().brighter()), new Stop(0.55, INDICATOR.getColor().brighter()), new Stop(0.55, INDICATOR.getColor().darker()), new Stop(1.0, INDICATOR.getColor().darker())});
        MARKER.setFill((Paint)HL_GRADIENT);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.4));
        DropShadow SHADOW = new DropShadow();
        SHADOW.setHeight(0.325 * HEIGHT);
        SHADOW.setWidth(0.325 * HEIGHT);
        SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        SHADOW.setInput((Effect)INNER_SHADOW);
        MARKER.setEffect((Effect)SHADOW);
        MARKER.setLayoutX(OFFSET.getX());
        MARKER.setLayoutY(OFFSET.getY());
        return MARKER;
    }

    protected Group createStandardKnob(double SIZE, Gauge.KnobColor KNOB_COLOR) {
        Stop[] KNOB_MAIN_STOPS;
        Group KNOB = new Group();
        switch (KNOB_COLOR) {
            case BLACK: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#BFBFBF")), new Stop(0.5, Color.web((String)"#2B2A2F")), new Stop(1.0, Color.web((String)"#7D7E80"))};
                break;
            }
            case BRASS: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#DFD0AE")), new Stop(0.5, Color.web((String)"#7A5E3E")), new Stop(1.0, Color.web((String)"#CFBE9D"))};
                break;
            }
            default: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#D7D7D7")), new Stop(0.5, Color.web((String)"#747474")), new Stop(1.0, Color.web((String)"#D7D7D7"))};
            }
        }
        Circle KNOB_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.5 * SIZE);
        KNOB_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.0, 0.5 * SIZE, SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, new Color(0.7058823529, 0.7058823529, 0.7058823529, 1.0)), new Stop(0.46, new Color(0.2470588235, 0.2470588235, 0.2470588235, 1.0)), new Stop(1.0, new Color(0.1568627451, 0.1568627451, 0.1568627451, 1.0))}));
        KNOB_FRAME.setStroke(null);
        Circle KNOB_MAIN = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.3888888888888889 * SIZE);
        KNOB_MAIN.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.1111111111111111 * SIZE, 0.5 * SIZE, 0.8888888888888888 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_MAIN_STOPS));
        KNOB_MAIN.setStroke(null);
        KNOB.getChildren().addAll((Object[])new Node[]{KNOB_FRAME, KNOB_MAIN});
        return KNOB;
    }

    protected Group createMetalKnob(double SIZE, Gauge.KnobColor KNOB_COLOR) {
        Stop[] KNOB_MAIN_STOPS;
        Group KNOB = new Group();
        Circle KNOB_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.5 * SIZE);
        KNOB_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.0, 0.5 * SIZE, SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3607843137, (double)0.3725490196, (double)0.3960784314, (double)1.0)), new Stop(0.47, Color.color((double)0.1803921569, (double)0.1921568627, (double)0.2078431373, (double)1.0)), new Stop(1.0, Color.color((double)0.0862745098, (double)0.0901960784, (double)0.1019607843, (double)1.0))}));
        KNOB_FRAME.setStroke(null);
        switch (KNOB_COLOR) {
            case BLACK: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#2B2A2F")), new Stop(1.0, Color.web((String)"#1A1B20"))};
                break;
            }
            case BRASS: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#966E36")), new Stop(1.0, Color.web((String)"#7C5F3D"))};
                break;
            }
            default: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)1.0)), new Stop(1.0, Color.color((double)0.3411764706, (double)0.3607843137, (double)0.3843137255, (double)1.0))};
            }
        }
        Circle KNOB_MAIN = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.4444444444444444 * SIZE);
        KNOB_MAIN.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.05555555555555555 * SIZE, 0.5 * SIZE, 0.9444444444444444 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_MAIN_STOPS));
        KNOB_MAIN.setStroke(null);
        Path KNOB_LOWER_HIGHLIGHT = new Path();
        KNOB_LOWER_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new MoveTo(0.7777777777777778 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.7222222222222222 * SIZE, 0.7222222222222222 * SIZE, 0.6111111111111112 * SIZE, 0.6666666666666666 * SIZE, 0.5 * SIZE, 0.6666666666666666 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3888888888888889 * SIZE, 0.6666666666666666 * SIZE, 0.2777777777777778 * SIZE, 0.7222222222222222 * SIZE, 0.2222222222222222 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.2777777777777778 * SIZE, 0.8888888888888888 * SIZE, 0.3888888888888889 * SIZE, 0.9444444444444444 * SIZE, 0.5 * SIZE, 0.9444444444444444 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.6111111111111112 * SIZE, 0.9444444444444444 * SIZE, 0.7222222222222222 * SIZE, 0.8888888888888888 * SIZE, 0.7777777777777778 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new ClosePath());
        KNOB_LOWER_HIGHLIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5555555555555556 * SIZE, 0.9444444444444444 * SIZE, 0.3888888888888889 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        KNOB_LOWER_HIGHLIGHT.setStroke(null);
        Path KNOB_UPPER_HIGHLIGHT = new Path();
        KNOB_UPPER_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new MoveTo(0.9444444444444444 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.8333333333333334 * SIZE, 0.1111111111111111 * SIZE, 0.6666666666666666 * SIZE, 0.0, 0.5 * SIZE, 0.0));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3333333333333333 * SIZE, 0.0, 0.16666666666666666 * SIZE, 0.1111111111111111 * SIZE, 0.05555555555555555 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.16666666666666666 * SIZE, 0.3333333333333333 * SIZE, 0.3333333333333333 * SIZE, 0.3888888888888889 * SIZE, 0.5 * SIZE, 0.3888888888888889 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.6666666666666666 * SIZE, 0.3888888888888889 * SIZE, 0.8333333333333334 * SIZE, 0.3333333333333333 * SIZE, 0.9444444444444444 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new ClosePath());
        KNOB_UPPER_HIGHLIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * SIZE, 0.0, 0.5833333333333334 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.7490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        KNOB_UPPER_HIGHLIGHT.setStroke(null);
        Circle KNOB_INNER_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.2777777777777778 * SIZE);
        KNOB_INNER_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.2222222222222222 * SIZE, 0.5 * SIZE, 0.7777777777777778 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(1.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)1.0))}));
        KNOB_INNER_FRAME.setStroke(null);
        Circle KNOB_INNER_BACKGROUND = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.2222222222222222 * SIZE);
        KNOB_INNER_BACKGROUND.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.2777777777777778 * SIZE, 0.5 * SIZE, 0.7222222222222222 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0039215686, (double)0.0235294118, (double)0.0431372549, (double)1.0)), new Stop(1.0, Color.color((double)0.1960784314, (double)0.2039215686, (double)0.2196078431, (double)1.0))}));
        KNOB_INNER_BACKGROUND.setStroke(null);
        KNOB.getChildren().addAll((Object[])new Node[]{KNOB_FRAME, KNOB_MAIN, KNOB_LOWER_HIGHLIGHT, KNOB_UPPER_HIGHLIGHT, KNOB_INNER_FRAME, KNOB_INNER_BACKGROUND});
        return KNOB;
    }

    protected Group createPlainKnob(double SIZE, Gauge.KnobColor KNOB_COLOR) {
        Stop[] KNOB_MAIN_STOPS;
        Group KNOB = new Group();
        Circle KNOB_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.5 * SIZE);
        KNOB_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.0, 0.5 * SIZE, SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3607843137, (double)0.3725490196, (double)0.3960784314, (double)1.0)), new Stop(0.47, Color.color((double)0.1803921569, (double)0.1921568627, (double)0.2078431373, (double)1.0)), new Stop(1.0, Color.color((double)0.0862745098, (double)0.0901960784, (double)0.1019607843, (double)1.0))}));
        KNOB_FRAME.setStroke(null);
        switch (KNOB_COLOR) {
            case BLACK: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#2B2A2F")), new Stop(1.0, Color.web((String)"#1A1B20"))};
                break;
            }
            case BRASS: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.web((String)"#966E36")), new Stop(1.0, Color.web((String)"#7C5F3D"))};
                break;
            }
            default: {
                KNOB_MAIN_STOPS = new Stop[]{new Stop(0.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)1.0)), new Stop(1.0, Color.color((double)0.3411764706, (double)0.3607843137, (double)0.3843137255, (double)1.0))};
            }
        }
        Circle KNOB_MAIN = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.4444444444444444 * SIZE);
        KNOB_MAIN.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.05555555555555555 * SIZE, 0.5 * SIZE, 0.9444444444444444 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_MAIN_STOPS));
        KNOB_MAIN.setStroke(null);
        Path KNOB_LOWER_HIGHLIGHT = new Path();
        KNOB_LOWER_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new MoveTo(0.7777777777777778 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.7222222222222222 * SIZE, 0.7222222222222222 * SIZE, 0.6111111111111112 * SIZE, 0.6666666666666666 * SIZE, 0.5 * SIZE, 0.6666666666666666 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3888888888888889 * SIZE, 0.6666666666666666 * SIZE, 0.2777777777777778 * SIZE, 0.7222222222222222 * SIZE, 0.2222222222222222 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.2777777777777778 * SIZE, 0.8888888888888888 * SIZE, 0.3888888888888889 * SIZE, 0.9444444444444444 * SIZE, 0.5 * SIZE, 0.9444444444444444 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.6111111111111112 * SIZE, 0.9444444444444444 * SIZE, 0.7222222222222222 * SIZE, 0.8888888888888888 * SIZE, 0.7777777777777778 * SIZE, 0.8333333333333334 * SIZE));
        KNOB_LOWER_HIGHLIGHT.getElements().add((Object)new ClosePath());
        KNOB_LOWER_HIGHLIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5555555555555556 * SIZE, 0.9444444444444444 * SIZE, 0.3888888888888889 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        KNOB_LOWER_HIGHLIGHT.setStroke(null);
        Path KNOB_UPPER_HIGHLIGHT = new Path();
        KNOB_UPPER_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new MoveTo(0.9444444444444444 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.8333333333333334 * SIZE, 0.1111111111111111 * SIZE, 0.6666666666666666 * SIZE, 0.0, 0.5 * SIZE, 0.0));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.3333333333333333 * SIZE, 0.0, 0.16666666666666666 * SIZE, 0.1111111111111111 * SIZE, 0.05555555555555555 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.16666666666666666 * SIZE, 0.3333333333333333 * SIZE, 0.3333333333333333 * SIZE, 0.3888888888888889 * SIZE, 0.5 * SIZE, 0.3888888888888889 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.6666666666666666 * SIZE, 0.3888888888888889 * SIZE, 0.8333333333333334 * SIZE, 0.3333333333333333 * SIZE, 0.9444444444444444 * SIZE, 0.2777777777777778 * SIZE));
        KNOB_UPPER_HIGHLIGHT.getElements().add((Object)new ClosePath());
        KNOB_UPPER_HIGHLIGHT.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * SIZE, 0.0, 0.5833333333333334 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.35)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
        KNOB_UPPER_HIGHLIGHT.setStroke(null);
        KNOB.getChildren().addAll((Object[])new Node[]{KNOB_FRAME, KNOB_MAIN, KNOB_LOWER_HIGHLIGHT, KNOB_UPPER_HIGHLIGHT});
        return KNOB;
    }

    protected Group createBigKnob(double SIZE, Gauge.KnobColor KNOB_COLOR) {
        Stop[] KNOB_FOREGROUND_STOPS;
        Stop[] KNOB_FOREGROUND_FRAME_STOPS;
        Stop[] KNOB_BACKGROUND_STOPS;
        Stop[] KNOB_FRAME_STOPS;
        Group KNOB = new Group();
        switch (KNOB_COLOR) {
            case BLACK: {
                KNOB_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)129, (int)133, (int)136)), new Stop(1.0, Color.rgb((int)61, (int)61, (int)73))};
                KNOB_BACKGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)27, (int)32)), new Stop(1.0, Color.rgb((int)96, (int)97, (int)102))};
                KNOB_FOREGROUND_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)191, (int)191, (int)191)), new Stop(0.47, Color.rgb((int)56, (int)57, (int)61)), new Stop(1.0, Color.rgb((int)143, (int)144, (int)146))};
                KNOB_FOREGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)191, (int)191, (int)191)), new Stop(0.21, Color.rgb((int)94, (int)93, (int)99)), new Stop(0.5, Color.rgb((int)43, (int)42, (int)47)), new Stop(0.78, Color.rgb((int)78, (int)79, (int)81)), new Stop(1.0, Color.rgb((int)143, (int)144, (int)146))};
                break;
            }
            case BRASS: {
                KNOB_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)143, (int)117, (int)80)), new Stop(1.0, Color.rgb((int)100, (int)76, (int)49))};
                KNOB_BACKGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)98, (int)75, (int)49)), new Stop(1.0, Color.rgb((int)149, (int)109, (int)54))};
                KNOB_FOREGROUND_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)147, (int)108, (int)54)), new Stop(0.47, Color.rgb((int)82, (int)66, (int)50)), new Stop(1.0, Color.rgb((int)147, (int)108, (int)54))};
                KNOB_FOREGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)223, (int)208, (int)174)), new Stop(0.21, Color.rgb((int)159, (int)136, (int)104)), new Stop(0.5, Color.rgb((int)122, (int)94, (int)62)), new Stop(0.78, Color.rgb((int)159, (int)136, (int)104)), new Stop(1.0, Color.rgb((int)223, (int)208, (int)174))};
                break;
            }
            default: {
                KNOB_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)152, (int)152, (int)152)), new Stop(1.0, Color.rgb((int)118, (int)121, (int)126))};
                KNOB_BACKGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)118, (int)121, (int)126)), new Stop(1.0, Color.rgb((int)191, (int)191, (int)191))};
                KNOB_FOREGROUND_FRAME_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)191, (int)191, (int)191)), new Stop(0.47, Color.rgb((int)116, (int)116, (int)116)), new Stop(1.0, Color.rgb((int)143, (int)144, (int)146))};
                KNOB_FOREGROUND_STOPS = new Stop[]{new Stop(0.0, Color.rgb((int)215, (int)215, (int)215)), new Stop(0.21, Color.rgb((int)139, (int)142, (int)145)), new Stop(0.5, Color.rgb((int)100, (int)100, (int)100)), new Stop(0.78, Color.rgb((int)139, (int)142, (int)145)), new Stop(1.0, Color.rgb((int)215, (int)215, (int)215))};
            }
        }
        Circle KNOB_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.5 * SIZE);
        KNOB_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.0, 0.5 * SIZE, SIZE, false, CycleMethod.NO_CYCLE, KNOB_FRAME_STOPS));
        KNOB_FRAME.setStroke(null);
        Circle KNOB_BACKGROUND = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.46153846153846156 * SIZE);
        KNOB_BACKGROUND.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.038461538461538464 * SIZE, 0.5 * SIZE, 0.9615384615384616 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_BACKGROUND_STOPS));
        KNOB_BACKGROUND.setStroke(null);
        Circle KNOB_FOREGROUND_FRAME = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.38461538461538464 * SIZE);
        KNOB_FOREGROUND_FRAME.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.11538461538461539 * SIZE, 0.5 * SIZE, 0.8846153846153846 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_FOREGROUND_FRAME_STOPS));
        KNOB_FOREGROUND_FRAME.setStroke(null);
        Circle KNOB_FOREGROUND = new Circle(0.5 * SIZE, 0.5 * SIZE, 0.34615384615384615 * SIZE);
        KNOB_FOREGROUND.setFill((Paint)new LinearGradient(0.5 * SIZE, 0.15384615384615385 * SIZE, 0.5 * SIZE, 0.8461538461538461 * SIZE, false, CycleMethod.NO_CYCLE, KNOB_FOREGROUND_STOPS));
        KNOB_FOREGROUND.setStroke(null);
        KNOB.getChildren().addAll((Object[])new Node[]{KNOB_FRAME, KNOB_BACKGROUND, KNOB_FOREGROUND_FRAME, KNOB_FOREGROUND});
        return KNOB;
    }

    protected Path createTriangleShape(double WIDTH, double HEIGHT, boolean TOP_DOWN) {
        Path SHAPE = new Path();
        SHAPE.setFillRule(FillRule.EVEN_ODD);
        if (TOP_DOWN) {
            SHAPE.getElements().add((Object)new MoveTo(0.0, 0.0));
            SHAPE.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT));
            SHAPE.getElements().add((Object)new LineTo(WIDTH, 0.0));
        } else {
            SHAPE.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.0));
            SHAPE.getElements().add((Object)new LineTo(0.0, HEIGHT));
            SHAPE.getElements().add((Object)new LineTo(WIDTH, HEIGHT));
        }
        SHAPE.getElements().add((Object)new ClosePath());
        return SHAPE;
    }

    protected Shape createBargraphLed(Rectangle GAUGE_BOUNDS, Gauge CONTROL, boolean ON) {
        double WIDTH = GAUGE_BOUNDS.getWidth();
        Path LED = new Path();
        LED.setFillRule(FillRule.EVEN_ODD);
        LED.getElements().add((Object)new MoveTo(0.485 * WIDTH, 0.185 * WIDTH));
        LED.getElements().add((Object)new CubicCurveTo(0.495 * WIDTH, 0.185 * WIDTH, 0.505 * WIDTH, 0.185 * WIDTH, 0.515 * WIDTH, 0.185 * WIDTH));
        LED.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.185 * WIDTH, 0.515 * WIDTH, 0.11 * WIDTH, 0.515 * WIDTH, 0.11 * WIDTH));
        LED.getElements().add((Object)new CubicCurveTo(0.505 * WIDTH, 0.11 * WIDTH, 0.495 * WIDTH, 0.11 * WIDTH, 0.485 * WIDTH, 0.11 * WIDTH));
        LED.getElements().add((Object)new CubicCurveTo(0.485 * WIDTH, 0.11 * WIDTH, 0.485 * WIDTH, 0.185 * WIDTH, 0.485 * WIDTH, 0.185 * WIDTH));
        LED.getElements().add((Object)new ClosePath());
        InnerShadow LED_INNER_SHADOW = new InnerShadow();
        LED_INNER_SHADOW.setRadius(0.02 * WIDTH);
        LED_INNER_SHADOW.setColor(Color.BLACK);
        LED.setEffect((Effect)LED_INNER_SHADOW);
        LED.setStyle("-fx-value: " + CONTROL.getValueColor().CSS);
        if (ON) {
            LED.setId("bargraph-on");
        } else {
            LED.setId("bargraph-off");
        }
        LED.setStroke(null);
        return LED;
    }

    protected Group createLcdThresholdIndicator(double WIDTH, double HEIGHT, String CSS_STYLE) {
        Group LCD_THRESHOLD_INDICATOR = new Group();
        LCD_THRESHOLD_INDICATOR.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        LCD_THRESHOLD_INDICATOR.getChildren().add((Object)IBOUNDS);
        Path INDICATOR = new Path();
        INDICATOR.setFillRule(FillRule.EVEN_ODD);
        INDICATOR.getElements().add((Object)new MoveTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7777777777777778));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.7777777777777778));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.8888888888888888));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.8888888888888888));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7777777777777778));
        INDICATOR.getElements().add((Object)new ClosePath());
        INDICATOR.getElements().add((Object)new MoveTo(WIDTH * 0.4444444444444444, HEIGHT * 0.3333333333333333));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.3333333333333333));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.7222222222222222));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7222222222222222));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.3333333333333333));
        INDICATOR.getElements().add((Object)new ClosePath());
        INDICATOR.getElements().add((Object)new MoveTo(0.0, HEIGHT));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH, HEIGHT));
        INDICATOR.getElements().add((Object)new LineTo(WIDTH * 0.5, 0.0));
        INDICATOR.getElements().add((Object)new LineTo(0.0, HEIGHT));
        INDICATOR.getElements().add((Object)new ClosePath());
        INDICATOR.getStyleClass().add((Object)"lcd");
        INDICATOR.setStyle(CSS_STYLE);
        INDICATOR.setId("lcd-foreground");
        INDICATOR.setStroke(null);
        LCD_THRESHOLD_INDICATOR.getChildren().addAll((Object[])new Node[]{INDICATOR});
        return LCD_THRESHOLD_INDICATOR;
    }
}

