/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.labs.internal.scene.control.behavior.CalendarTextFieldBehavior;
import jfxtras.labs.scene.control.CalendarPicker;
import jfxtras.labs.scene.control.CalendarTextField;
import jfxtras.labs.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarTextFieldCaspianSkin
extends SkinBase<CalendarTextField, CalendarTextFieldBehavior> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private CalendarPicker calendarPickerX = null;
    private Popup popup = null;

    public CalendarTextFieldCaspianSkin(CalendarTextField control) {
        super((Control)control, (BehaviorBase)new CalendarTextFieldBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                CalendarTextFieldCaspianSkin.this.refreshValue();
            }
        });
        this.refreshValue();
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getValue();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (!CalendarTextFieldCaspianSkin.this.textField.isFocused()) {
                    CalendarTextFieldCaspianSkin.this.parse();
                }
            }
        });
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                CalendarTextFieldCaspianSkin.this.parse();
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                    CalendarTextFieldCaspianSkin.this.parse();
                    Calendar lCalendar = (Calendar)((CalendarTextField)CalendarTextFieldCaspianSkin.this.getSkinnable()).getValue().clone();
                    int lField = 5;
                    if (keyEvent.isControlDown()) {
                        lField = 2;
                    }
                    if (keyEvent.isAltDown()) {
                        lField = 1;
                    }
                    if (keyEvent.isShiftDown()) {
                        lField = 3;
                    }
                    lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                    ((CalendarTextField)CalendarTextFieldCaspianSkin.this.getSkinnable()).setValue(lCalendar);
                }
            }
        });
        Bindings.bindBidirectional((Property)this.textField.tooltipProperty(), (Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        this.textField.setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        Image lImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + "Icon.png"));
        this.imageView = new ImageView(lImage);
        this.imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (CalendarTextFieldCaspianSkin.this.textField.focusedProperty().get()) {
                    CalendarTextFieldCaspianSkin.this.parse();
                }
                CalendarTextFieldCaspianSkin.this.showPopup(evt);
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(10.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    CalendarTextFieldCaspianSkin.this.textField.requestFocus();
                }
            }
        });
        this.calendarPickerX = new CalendarPicker();
        this.calendarPickerX.setMode(CalendarPicker.Mode.SINGLE);
        Bindings.bindBidirectional(this.calendarPickerX.localeProperty(), ((CalendarTextField)this.getSkinnable()).localeProperty());
        Bindings.bindBidirectional(this.calendarPickerX.calendarProperty(), ((CalendarTextField)this.getSkinnable()).valueProperty());
        this.calendarPickerX.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> arg0, Calendar arg1, Calendar arg2) {
                if (CalendarTextFieldCaspianSkin.this.popup != null) {
                    CalendarTextFieldCaspianSkin.this.popup.hide();
                }
            }
        });
    }

    private void parse() {
        try {
            String lText = this.textField.getText();
            lText = lText.trim();
            if (lText.length() == 0) {
                return;
            }
            if (lText.startsWith("-") || lText.startsWith("+")) {
                if (lText.startsWith("+")) {
                    lText = lText.substring(1);
                }
                int lUnit = 5;
                if (lText.toLowerCase().endsWith("d")) {
                    lText = lText.substring(0, lText.length() - 1);
                    lUnit = 5;
                }
                if (lText.toLowerCase().endsWith("w")) {
                    lText = lText.substring(0, lText.length() - 1);
                    lUnit = 3;
                }
                if (lText.toLowerCase().endsWith("m")) {
                    lText = lText.substring(0, lText.length() - 1);
                    lUnit = 2;
                }
                if (lText.toLowerCase().endsWith("y")) {
                    lText = lText.substring(0, lText.length() - 1);
                    lUnit = 1;
                }
                int lDelta = Integer.parseInt(lText);
                Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getValue().clone();
                lCalendar.add(lUnit, lDelta);
                ((CalendarTextField)this.getSkinnable()).setValue(lCalendar);
            } else if (lText.equals("#")) {
                ((CalendarTextField)this.getSkinnable()).setValue(Calendar.getInstance());
            } else {
                Date lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                Calendar lCalendar = Calendar.getInstance();
                lCalendar.setTime(lDate);
                ((CalendarTextField)this.getSkinnable()).setValue(lCalendar);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void showPopup(MouseEvent evt) {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoFix(true);
            this.popup.setAutoHide(true);
            this.popup.setHideOnEscape(true);
            BorderPane lBorderPane = new BorderPane();
            lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
            lBorderPane.setCenter((Node)this.calendarPickerX);
            this.popup.getContent().add((Object)lBorderPane);
        }
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
        this.calendarPickerX.requestFocus();
    }
}

