/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import jfxtras.labs.scene.control.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerBehavior<T>
extends BehaviorBase<Spinner<T>> {
    private static final String EVENT_PREVIOUS = "PreviousPressed";
    private static final String EVENT_NEXT = "NextPressed";
    protected static final List<KeyBinding> KEY_BINDINGS = new ArrayList<KeyBinding>();

    public SpinnerBehavior(Spinner<T> control) {
        super(control);
        this.construct();
    }

    private void construct() {
    }

    public void parse(String text) {
        Integer lIndex;
        Object lValue = ((Spinner)this.getControl()).getStringConverter().fromString(text);
        if (((Spinner)this.getControl()).getItems().indexOf(lValue) >= 0) {
            ((Spinner)this.getControl()).setValue(lValue);
            return;
        }
        Callback lAddCallback = ((Spinner)this.getControl()).getAddCallback();
        if (lAddCallback != null && (lIndex = (Integer)lAddCallback.call(lValue)) != null) {
            ((Spinner)this.getControl()).setIndex(lIndex);
            return;
        }
    }

    public void mousePressed(MouseEvent evt) {
        Spinner lControl = (Spinner)this.getControl();
        if (!lControl.isFocused() && lControl.isFocusTraversable()) {
            lControl.requestFocus();
        }
    }

    protected List<KeyBinding> createKeyBindings() {
        return KEY_BINDINGS;
    }

    protected void callAction(String name) {
        if (EVENT_PREVIOUS.equals(name)) {
            ((Spinner)this.getControl()).decrement();
        } else if (EVENT_NEXT.equals(name)) {
            ((Spinner)this.getControl()).increment();
        } else {
            super.callAction(name);
        }
    }

    static {
        KEY_BINDINGS.add(new KeyBinding(KeyCode.MINUS, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.PLUS, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.SUBTRACT, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.ADD, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.UP, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.DOWN, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.LEFT, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, EVENT_NEXT));
        KEY_BINDINGS.addAll(TRAVERSAL_BINDINGS);
    }
}

