/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.support;

import griffon.util.GriffonNameUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import jline.Terminal;
import org.apache.commons.lang.WordUtils;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.felix.gogo.commands.converter.GenericType;
import org.apache.felix.gogo.commands.converter.GriffonDefaultConverter;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.NameScoping;
import org.codehaus.griffon.cli.shell.Argument;
import org.codehaus.griffon.cli.shell.Command;
import org.codehaus.griffon.cli.shell.GantAwareAction;
import org.codehaus.griffon.cli.shell.GriffonCommand;
import org.codehaus.griffon.cli.shell.Option;
import org.codehaus.griffon.cli.shell.support.CommandArguments;
import org.codehaus.griffon.cli.shell.support.CommandUtils;
import org.fusesource.jansi.Ansi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GriffonCommandPreparator
extends DefaultActionPreparator {
    private final String name;
    private final String scope;
    private final File scriptFile;
    public static final Option HELP = new Option(){

        public String name() {
            return "--help";
        }

        public String[] aliases() {
            return new String[0];
        }

        public String description() {
            return "Display this help message";
        }

        public boolean required() {
            return false;
        }

        public boolean multiValued() {
            return false;
        }

        public String valueToShowInHelp() {
            return "DEFAULT";
        }

        public Class<? extends Annotation> annotationType() {
            return Option.class;
        }
    };

    public GriffonCommandPreparator(String scope, String name, File scriptFile) {
        this.scope = scope;
        this.name = name;
        this.scriptFile = scriptFile;
    }

    public boolean prepare(Action action, CommandSession session, List<Object> params, CommandArguments args) throws Exception {
        GantAwareAction gantAction = (GantAwareAction)action;
        GriffonCommand delegateAction = CommandUtils.getDelegateAction(gantAction.getScope() + ":" + gantAction.getName());
        if (delegateAction != null) {
            gantAction.setDelegateCommand(delegateAction);
            return this.prepareDelegate(delegateAction, session, params, args);
        }
        return this.prepareDelegate(gantAction, session, params, args);
    }

    public boolean prepareDelegate(Object subject, CommandSession session, List<Object> params, CommandArguments args) throws Exception {
        args.subject = subject;
        args.params.clear();
        args.params.addAll(params);
        for (Class<?> type = subject.getClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    args.options.put(option, field);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                if ("##default".equals(argument.name())) {
                    final Argument delegate = argument;
                    final String name = field.getName();
                    argument = new Argument(){

                        public String name() {
                            return name;
                        }

                        public String description() {
                            return delegate.description();
                        }

                        public boolean required() {
                            return delegate.required();
                        }

                        public int index() {
                            return delegate.index();
                        }

                        public boolean multiValued() {
                            return delegate.multiValued();
                        }

                        public String valueToShowInHelp() {
                            return delegate.valueToShowInHelp();
                        }

                        public Class<? extends Annotation> annotationType() {
                            return delegate.annotationType();
                        }
                    };
                }
                args.arguments.put(argument, field);
                int index = argument.index();
                while (args.orderedArguments.size() <= index) {
                    args.orderedArguments.add(null);
                }
                if (args.orderedArguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index);
                }
                args.orderedArguments.set(index, argument);
            }
        }
        for (int i = 0; i < args.orderedArguments.size(); ++i) {
            if (args.orderedArguments.get(i) != null) continue;
            throw new IllegalArgumentException("Missing argument for index: " + i);
        }
        TreeMap<Option, Object> optionValues = new TreeMap<Option, Object>(CommandArguments.OPTION_COMPARATOR);
        HashMap<Argument, Object> argumentValues = new HashMap<Argument, Object>();
        boolean processOptions = true;
        int argIndex = 0;
        Iterator<Object> it = params.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (HELP.name().equals(object) || Arrays.asList(HELP.aliases()).contains(object)) {
                this.printUsageDelegate(session, subject, args.options, args.arguments, System.out);
                return false;
            }
            if (processOptions && object instanceof String && ((String)object).startsWith("-")) {
                String name;
                boolean isKeyValuePair = ((String)object).indexOf(61) != -1;
                Object value = null;
                if (isKeyValuePair) {
                    name = ((String)object).substring(0, ((String)object).indexOf(61));
                    value = ((String)object).substring(((String)object).indexOf(61) + 1);
                } else {
                    name = (String)object;
                }
                Option option = null;
                for (Option opt : args.options.keySet()) {
                    if (!name.equals(opt.name()) && !Arrays.asList(opt.aliases()).contains(name)) continue;
                    option = opt;
                    break;
                }
                if (option == null) {
                    throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" undefined option ").a(Ansi.Attribute.INTENSITY_BOLD).a(object).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString(), "Undefined option: " + object);
                }
                Field field = args.options.get(option);
                if (value == null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class)) {
                    value = Boolean.TRUE;
                }
                if (value == null && it.hasNext()) {
                    value = it.next();
                }
                if (value == null) {
                    throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" missing value for option ").a(Ansi.Attribute.INTENSITY_BOLD).a(object).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString(), "Missing value for option: " + object);
                }
                if (option.multiValued()) {
                    ArrayList<Object> l = (ArrayList<Object>)optionValues.get(option);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        optionValues.put(option, l);
                    }
                    l.add(value);
                    continue;
                }
                optionValues.put(option, value);
                continue;
            }
            processOptions = false;
            if (argIndex >= args.orderedArguments.size()) {
                throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(": too many arguments specified").fg(Ansi.Color.DEFAULT).toString(), "Too many arguments specified");
            }
            Argument argument = args.orderedArguments.get(argIndex);
            if (!argument.multiValued()) {
                ++argIndex;
            }
            if (argument.multiValued()) {
                ArrayList<Object> l = (ArrayList<Object>)argumentValues.get(argument);
                if (l == null) {
                    l = new ArrayList<Object>();
                    argumentValues.put(argument, l);
                }
                l.add(object);
                continue;
            }
            argumentValues.put(argument, object);
        }
        for (Option option : args.options.keySet()) {
            if (!option.required() || optionValues.get(option) != null) continue;
            throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(": option ").a(Ansi.Attribute.INTENSITY_BOLD).a(option.name()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" is required").fg(Ansi.Color.DEFAULT).toString(), "Option " + option.name() + " is required");
        }
        for (Argument argument : args.arguments.keySet()) {
            if (!argument.required() || argumentValues.get(argument) != null) continue;
            throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(": argument ").a(Ansi.Attribute.INTENSITY_BOLD).a(argument.name()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" is required").fg(Ansi.Color.DEFAULT).toString(), "Argument " + argument.name() + " is required");
        }
        for (Map.Entry entry : optionValues.entrySet()) {
            Object value;
            Field field = args.options.get(entry.getKey());
            try {
                value = this.convert(subject, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(": unable to convert option ").a(Ansi.Attribute.INTENSITY_BOLD).a(((Option)entry.getKey()).name()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" with value '").a(entry.getValue()).a("' to type ").a(new GenericType(field.getGenericType()).toString()).fg(Ansi.Color.DEFAULT).toString(), "Unable to convert option " + ((Option)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), (Throwable)e);
            }
            field.setAccessible(true);
            field.set(subject, value);
        }
        for (Map.Entry entry : argumentValues.entrySet()) {
            Object value;
            Field field = args.arguments.get(entry.getKey());
            try {
                value = this.convert(subject, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                throw new CommandException(Ansi.ansi().fg(Ansi.Color.RED).a("Error executing command ").a(this.scope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(this.name).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(": unable to convert argument ").a(Ansi.Attribute.INTENSITY_BOLD).a(((Argument)entry.getKey()).name()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).a(" with value '").a(entry.getValue()).a("' to type ").a(new GenericType(field.getGenericType()).toString()).fg(Ansi.Color.DEFAULT).toString(), "Unable to convert argument " + ((Argument)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), (Throwable)e);
            }
            field.setAccessible(true);
            field.set(subject, value);
        }
        return true;
    }

    protected void printUsageDelegate(CommandSession session, Object action, Map<Option, Field> optionsMap, Map<Argument, Field> argsMap, PrintStream out) {
        String description;
        Command command = action.getClass().getAnnotation(Command.class);
        Terminal term = session != null ? (Terminal)session.get(".jline.terminal") : null;
        ArrayList<Argument> arguments = new ArrayList<Argument>(argsMap.keySet());
        Collections.sort(arguments, new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                return Integer.valueOf(o1.index()).compareTo(o2.index());
            }
        });
        String commandName = command != null ? command.name() : this.name;
        String commandScope = command != null ? command.scope() : this.scope;
        String commandDescription = command != null ? command.description() : "No description available for " + this.name + ".";
        String commandDetailedDescription = command != null ? command.detailedDescription() : "";
        TreeSet<Option> options = new TreeSet<Option>(CommandArguments.OPTION_COMPARATOR);
        options.addAll(optionsMap.keySet());
        options.add(HELP);
        boolean globalScope = NameScoping.isGlobalScope((CommandSession)session, (String)this.scope);
        out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DESCRIPTION").a(Ansi.Attribute.RESET));
        out.print("        ");
        if (commandName != null) {
            if (globalScope) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(commandName).a(Ansi.Attribute.RESET));
            } else {
                out.println(Ansi.ansi().a(commandScope).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(commandName).a(Ansi.Attribute.RESET));
            }
            out.println();
        }
        if (GriffonNameUtils.isBlank((String)(description = commandDescription))) {
            description = "No description available for " + this.name + ".";
        }
        out.print("\t");
        out.println(description);
        out.println();
        out.println("\tLoaded from");
        out.println("\t" + this.scriptFile);
        out.println();
        StringBuffer syntax = new StringBuffer();
        if (globalScope) {
            syntax.append(commandName);
        } else {
            syntax.append(String.format("%s:%s", commandScope, commandName));
        }
        if (options.size() > 0) {
            syntax.append(" [options]");
        }
        if (arguments.size() > 0) {
            syntax.append(' ');
            for (Argument argument : arguments) {
                if (!argument.required()) {
                    syntax.append(String.format("[%s] ", argument.name()));
                    continue;
                }
                syntax.append(String.format("%s ", argument.name()));
            }
        }
        out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("SYNTAX").a(Ansi.Attribute.RESET));
        out.print("        ");
        out.println(syntax.toString());
        out.println();
        if (arguments.size() > 0) {
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("ARGUMENTS").a(Ansi.Attribute.RESET));
            for (Argument argument : arguments) {
                out.print("        ");
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(argument.name()).a(Ansi.Attribute.RESET));
                GriffonCommandPreparator.printFormatted((String)"                ", (String)argument.description(), (int)(term != null ? term.getWidth() : 80), (PrintStream)out);
                if (argument.required() || argument.valueToShowInHelp() == null || argument.valueToShowInHelp().length() == 0) continue;
                try {
                    if ("DEFAULT".equals(argument.valueToShowInHelp())) {
                        argsMap.get(argument).setAccessible(true);
                        Object o = argsMap.get(argument).get(action);
                        this.printObjectDefaultsTo(out, o);
                        continue;
                    }
                    this.printDefaultsTo(out, argument.valueToShowInHelp());
                }
                catch (Throwable t) {}
            }
            out.println();
        }
        if (options.size() > 0) {
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("OPTIONS").a(Ansi.Attribute.RESET));
            for (Option option : options) {
                String opt = option.name();
                for (String alias : option.aliases()) {
                    opt = opt + ", " + alias;
                }
                out.print("        ");
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(opt).a(Ansi.Attribute.RESET));
                GriffonCommandPreparator.printFormatted((String)"                ", (String)option.description(), (int)(term != null ? term.getWidth() : 80), (PrintStream)out);
                if (option.valueToShowInHelp() == null || option.valueToShowInHelp().length() == 0) continue;
                try {
                    if ("DEFAULT".equals(option.valueToShowInHelp())) {
                        optionsMap.get(option).setAccessible(true);
                        Object o = optionsMap.get(option).get(action);
                        this.printObjectDefaultsTo(out, o);
                        continue;
                    }
                    this.printDefaultsTo(out, option.valueToShowInHelp());
                }
                catch (Throwable t) {}
            }
            out.println();
        }
        if (commandDetailedDescription.length() > 0) {
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DETAILS").a(Ansi.Attribute.RESET));
            String desc = this.loadDescription(action.getClass(), commandDetailedDescription);
            GriffonCommandPreparator.printFormattedFixed("        ", desc, term != null ? term.getWidth() : 80, out);
        }
    }

    public static void printFormattedFixed(String prefix, String str, int termWidth, PrintStream out) {
        int pfxLen = GriffonCommandPreparator.length((String)prefix);
        int maxwidth = termWidth - pfxLen;
        BufferedReader reader = new BufferedReader(new StringReader(str));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                out.println(prefix + WordUtils.wrap((String)line, (int)maxwidth, (String)('\n' + prefix), (boolean)true));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void printObjectDefaultsTo(PrintStream out, Object o) {
        if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
            this.printDefaultsTo(out, o.toString());
        }
    }

    private void printDefaultsTo(PrintStream out, String value) {
        out.print("                (defaults to ");
        out.print(value);
        out.println(")");
    }

    private Object convert(Object action, Object value, Type toType) throws Exception {
        if (toType == String.class) {
            return value != null ? value.toString() : null;
        }
        return new GriffonDefaultConverter(action.getClass().getClassLoader()).convert(value, toType);
    }
}

