/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.command;

import griffon.util.GriffonExceptionHandler;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jline.Terminal;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.karaf.shell.console.NameScoping;
import org.codehaus.griffon.cli.shell.Command;
import org.codehaus.griffon.cli.shell.GriffonShellCommand;
import org.codehaus.griffon.cli.shell.command.ResolveDependenciesCommand;
import org.codehaus.griffon.cli.shell.support.CommandUtils;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@org.apache.felix.gogo.commands.Command(scope="shell", name="help", description="Displays this help or help about a command")
public class HelpCommand
extends AbstractAction {
    @Argument(name="command", required=false, description="The command to get help for")
    private String command;
    @Option(name="--resolve-dependencies", required=false, description="Resolve plugin dependencies before collecting help information")
    private boolean resolveDependencies;

    /*
     * WARNING - void declaration
     */
    public Object doExecute() throws Exception {
        if (this.resolveDependencies) {
            ResolveDependenciesCommand.resolveDependencies(this.session);
        }
        if (this.command == null) {
            Set names = (Set)this.session.get(".commands");
            if (!names.isEmpty()) {
                Terminal term = (Terminal)this.session.get(".jline.terminal");
                PrintStream out = System.out;
                TreeMap<void, String> commands = new TreeMap<void, String>();
                for (String string : names) {
                    void var6_6;
                    String description = null;
                    Function function = (Function)this.session.get(string);
                    if (!((function = this.unProxy(function)) instanceof AbstractCommand)) continue;
                    try {
                        org.apache.felix.gogo.commands.Command ann;
                        Method mth = AbstractCommand.class.getDeclaredMethod("createNewAction", new Class[0]);
                        mth.setAccessible(true);
                        Object action = mth.invoke((Object)function, new Object[0]);
                        Class<?> clazz = action.getClass();
                        if (GriffonShellCommand.class.isAssignableFrom(clazz)) {
                            action = CommandUtils.getDelegateAction(string);
                            if (action != null) {
                                ann = action.getClass().getAnnotation(Command.class);
                                description = ann.description();
                            }
                        } else {
                            ann = clazz.getAnnotation(org.apache.felix.gogo.commands.Command.class);
                            description = ann.description();
                        }
                    }
                    catch (Throwable e) {
                        GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
                    }
                    if (string.startsWith("*:")) {
                        String string2 = string.substring(2);
                    }
                    commands.put(var6_6, description);
                }
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("COMMANDS").a(Ansi.Attribute.RESET));
                for (Map.Entry entry : commands.entrySet()) {
                    out.print("        ");
                    String key = NameScoping.getCommandNameWithoutGlobalPrefix((CommandSession)this.session, (String)((String)entry.getKey()));
                    out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(key).a(Ansi.Attribute.RESET));
                    if (entry.getValue() == null) continue;
                    DefaultActionPreparator.printFormatted((String)"                ", (String)((String)entry.getValue()), (int)(term != null ? term.getWidth() : 80), (PrintStream)out);
                }
                out.println();
            }
            return null;
        }
        return this.session.execute((CharSequence)(this.command + " --help"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function unProxy(Function function) {
        block6: {
            try {
                if (!function.getClass().getName().contains("CommandProxy")) break block6;
                Field contextField = function.getClass().getDeclaredField("context");
                Field referenceField = function.getClass().getDeclaredField("reference");
                contextField.setAccessible(true);
                referenceField.setAccessible(true);
                BundleContext context = (BundleContext)contextField.get(function);
                ServiceReference reference = (ServiceReference)referenceField.get(function);
                Object target = context.getService(reference);
                try {
                    if (target instanceof Function) {
                        function = (Function)target;
                    }
                }
                finally {
                    context.ungetService(reference);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return function;
    }
}

