/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.resources.NoSuchResourceException;
import griffon.core.resources.ResourceResolver;
import java.util.List;
import java.util.Locale;
import org.codehaus.griffon.runtime.core.resources.AbstractResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeResourceResolver
extends AbstractResourceResolver {
    private final ResourceResolver[] resourceResolvers;

    public CompositeResourceResolver(List<ResourceResolver> resourceResolvers) {
        this(CompositeResourceResolver.toResourceResolverArray(resourceResolvers));
    }

    public CompositeResourceResolver(ResourceResolver[] resourceResolvers) {
        this.resourceResolvers = resourceResolvers;
    }

    private static ResourceResolver[] toResourceResolverArray(List<ResourceResolver> resourceResolvers) {
        if (null == resourceResolvers || resourceResolvers.isEmpty()) {
            return new ResourceResolver[0];
        }
        return resourceResolvers.toArray(new ResourceResolver[resourceResolvers.size()]);
    }

    @Override
    public Object resolveResource(String key, Object defaultValue) {
        return this.resolveResourceInternal(key, EMPTY_OBJECT_ARGS, defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Object defaultValue, Locale locale) {
        return this.resolveResourceInternal(key, EMPTY_OBJECT_ARGS, defaultValue, locale);
    }

    @Override
    public Object resolveResource(String key, Object[] args, Object defaultValue) {
        return this.resolveResourceInternal(key, args, defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Object[] args, Object defaultValue, Locale locale) {
        return this.resolveResourceInternal(key, args, defaultValue, locale);
    }

    @Override
    public Object resolveResource(String key, List args, Object defaultValue) {
        return this.resolveResourceInternal(key, this.toObjectArray(args), defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, List args, Object defaultValue, Locale locale) {
        return this.resolveResourceInternal(key, this.toObjectArray(args), defaultValue, locale);
    }

    @Override
    public Object resolveResourceInternal(String key, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                if (resourceResolver instanceof AbstractResourceResolver) {
                    return ((AbstractResourceResolver)resourceResolver).resolveResourceInternal(key, locale);
                }
                return resourceResolver.resolveResource(key, locale);
            }
            catch (NoSuchResourceException nsme) {
            }
        }
        throw new NoSuchResourceException(key, locale);
    }

    private Object resolveResourceInternal(String key, Object[] args, Locale locale) throws NoSuchResourceException {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                return resourceResolver.resolveResource(key, args, locale);
            }
            catch (NoSuchResourceException nsme) {
            }
        }
        throw new NoSuchResourceException(key, locale);
    }

    private Object resolveResourceInternal(String key, Object[] args, Object defaultValue, Locale locale) {
        try {
            return this.resolveResourceInternal(key, args, locale);
        }
        catch (NoSuchResourceException nsme) {
            return defaultValue;
        }
    }
}

