/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.i18n;

import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import java.util.List;
import java.util.Locale;
import org.codehaus.griffon.runtime.core.i18n.AbstractMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMessageSource
extends AbstractMessageSource {
    private final MessageSource[] messageSources;

    public CompositeMessageSource(List<MessageSource> messageSources) {
        this(CompositeMessageSource.toMessageSourceArray(messageSources));
    }

    public CompositeMessageSource(MessageSource[] messageSources) {
        this.messageSources = messageSources;
    }

    private static MessageSource[] toMessageSourceArray(List<MessageSource> messageSources) {
        if (null == messageSources || messageSources.isEmpty()) {
            return new MessageSource[0];
        }
        return messageSources.toArray(new MessageSource[messageSources.size()]);
    }

    @Override
    public String getMessage(String key, String defaultMessage) {
        return this.getMessageInternal(key, EMPTY_OBJECT_ARGS, defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, String defaultMessage, Locale locale) {
        return this.getMessageInternal(key, EMPTY_OBJECT_ARGS, defaultMessage, locale);
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage) {
        return this.getMessageInternal(key, args, defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageInternal(key, args, defaultMessage, locale);
    }

    @Override
    public String getMessage(String key, List args, String defaultMessage) {
        return this.getMessageInternal(key, this.toObjectArray(args), defaultMessage, Locale.getDefault());
    }

    @Override
    public String getMessage(String key, List args, String defaultMessage, Locale locale) {
        return this.getMessageInternal(key, this.toObjectArray(args), defaultMessage, locale);
    }

    @Override
    public String resolveMessage(String key, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        for (MessageSource messageSource : this.messageSources) {
            try {
                if (messageSource instanceof AbstractMessageSource) {
                    return ((AbstractMessageSource)messageSource).resolveMessage(key, locale);
                }
                return messageSource.getMessage(key, locale);
            }
            catch (NoSuchMessageException nsme) {
            }
        }
        throw new NoSuchMessageException(key, locale);
    }

    private String getMessageInternal(String key, Object[] args, Locale locale) throws NoSuchMessageException {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        for (MessageSource messageSource : this.messageSources) {
            try {
                return messageSource.getMessage(key, args, locale);
            }
            catch (NoSuchMessageException nsme) {
            }
        }
        throw new NoSuchMessageException(key, locale);
    }

    private String getMessageInternal(String key, Object[] args, String defaultMessage, Locale locale) {
        try {
            return this.getMessageInternal(key, args, locale);
        }
        catch (NoSuchMessageException nsme) {
            return null == defaultMessage ? key : defaultMessage;
        }
    }
}

