/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.GriffonModel;
import griffon.core.GriffonMvcArtifact;
import griffon.core.GriffonView;
import griffon.core.MVCClosure;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupConfiguration;
import griffon.core.MVCGroupManager;
import griffon.exceptions.MVCGroupConfigurationException;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.util.FactoryBuilderSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMVCGroupManager
implements MVCGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMVCGroupManager.class);
    private final GriffonApplication app;
    private final Map<String, MVCGroupConfiguration> configurations = new LinkedHashMap<String, MVCGroupConfiguration>();
    private final Map<String, MVCGroup> groups = new LinkedHashMap<String, MVCGroup>();
    private final Object lock = new Object();
    private boolean initialized;

    public AbstractMVCGroupManager(GriffonApplication app) {
        this.app = app;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MVCGroupConfiguration> getConfigurations() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.configurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MVCGroup> getGroups() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MVCGroupConfiguration findConfiguration(String mvcType) {
        MVCGroupConfiguration configuration = null;
        Object object = this.lock;
        synchronized (object) {
            configuration = this.configurations.get(mvcType);
        }
        if (configuration == null) {
            throw new MVCGroupConfigurationException("Unknown MVC type '" + mvcType + "'. Known types are " + this.configurations.keySet(), mvcType);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MVCGroup findGroup(String mvcId) {
        Object object = this.lock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching group " + mvcId);
            }
            return this.groups.get(mvcId);
        }
    }

    @Override
    public MVCGroup getAt(String mvcId) {
        return this.findGroup(mvcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize(Map<String, MVCGroupConfiguration> configurations) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.doInitialize(configurations);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfiguration(MVCGroupConfiguration configuration) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized && this.configurations.get(configuration.getMvcType()) != null) {
                return;
            }
            this.configurations.put(configuration.getMvcType(), configuration);
        }
    }

    @Override
    public void removeConfiguration(MVCGroupConfiguration configuration) {
        if (configuration != null) {
            this.removeConfiguration(configuration.getMvcType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(String name) {
        if (!GriffonNameUtils.isBlank(name)) {
            Object object = this.lock;
            synchronized (object) {
                this.configurations.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGroup(MVCGroup group) {
        Object object = this.lock;
        synchronized (object) {
            if (group != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding group " + group.getMvcId() + ":" + group);
                }
                this.groups.put(group.getMvcId(), group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(MVCGroup group) {
        Object object = this.lock;
        synchronized (object) {
            if (group != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing group " + group.getMvcId() + ":" + group);
                }
                this.groups.remove(group.getMvcId());
            }
        }
    }

    @Override
    public MVCGroupConfiguration cloneMVCGroupConfiguration(String mvcType, Map<String, Object> config) {
        MVCGroupConfiguration configuration = this.findConfiguration(mvcType);
        LinkedHashMap<String, Object> configCopy = new LinkedHashMap<String, Object>();
        configCopy.putAll(configuration.getConfig());
        if (config != null) {
            configCopy.putAll(config);
        }
        return this.newMVCGroupConfiguration(mvcType, configuration.getMembers(), configCopy);
    }

    protected abstract void doInitialize(Map<String, MVCGroupConfiguration> var1);

    @Override
    public MVCGroup buildMVCGroup(String mvcType) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), null, Collections.<String, Object>emptyMap());
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, String mvcName) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), mvcName, Collections.<String, Object>emptyMap());
    }

    @Override
    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), null, args);
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, Map<String, Object> args) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), null, args);
    }

    @Override
    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), mvcName, args);
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.buildMVCGroup(this.findConfiguration(mvcType), mvcName, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType) {
        return this.createMVCGroup(this.findConfiguration(mvcType), null, Collections.<String, Object>emptyMap());
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType) {
        return this.createMVCGroup(this.findConfiguration(mvcType), null, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, Map<String, Object> args) {
        return this.createMVCGroup(this.findConfiguration(mvcType), null, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName) {
        return this.createMVCGroup(this.findConfiguration(mvcType), mvcName, Collections.<String, Object>emptyMap());
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.createMVCGroup(this.findConfiguration(mvcType), mvcName, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.createMVCGroup(this.findConfiguration(mvcType), mvcName, args);
    }

    @Override
    public void withMVCGroup(String mvcType, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public void withMVCGroup(String mvcType, String mvcName, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public void withMVCGroup(String mvcType, Map<String, Object> args, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, args, handler);
    }

    @Override
    public void withMVCGroup(Map<String, Object> args, String mvcType, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, args, handler);
    }

    @Override
    public void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, args, handler);
    }

    @Override
    public void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, Closure handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), null, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.withMVCGroup(this.findConfiguration(mvcType), mvcName, args, handler);
    }

    protected List<? extends GriffonMvcArtifact> createMVCGroup(MVCGroupConfiguration configuration, String mvcName, Map<String, Object> args) {
        MVCGroup group = this.buildMVCGroup(this.findConfiguration(configuration.getMvcType()), mvcName, args);
        return Arrays.asList(group.getModel(), group.getView(), group.getController());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withMVCGroup(MVCGroupConfiguration configuration, String mvcId, Map<String, Object> args, Closure handler) {
        MVCGroup group = null;
        try {
            group = this.buildMVCGroup(configuration, mvcId, args);
            handler.call(new Object[]{group.getModel(), group.getView(), group.getController()});
        }
        finally {
            block9: {
                try {
                    if (group != null) {
                        this.destroyMVCGroup(group.getMvcId());
                    }
                }
                catch (Exception x) {
                    if (!this.app.getLog().isWarnEnabled()) break block9;
                    this.app.getLog().warn("Could not destroy group [" + mvcId + "] of type " + configuration.getMvcType() + ".", GriffonExceptionHandler.sanitize(x));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(MVCGroupConfiguration configuration, String mvcId, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        MVCGroup group = null;
        try {
            group = this.buildMVCGroup(configuration, mvcId, args);
            handler.call(group.getModel(), group.getView(), group.getController());
        }
        finally {
            block9: {
                try {
                    if (group != null) {
                        this.destroyMVCGroup(group.getMvcId());
                    }
                }
                catch (Exception x) {
                    if (!this.app.getLog().isWarnEnabled()) break block9;
                    this.app.getLog().warn("Could not destroy group [" + mvcId + "] of type " + configuration.getMvcType() + ".", GriffonExceptionHandler.sanitize(x));
                }
            }
        }
    }

    protected abstract MVCGroup buildMVCGroup(MVCGroupConfiguration var1, String var2, Map<String, Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, ? extends FactoryBuilderSupport> getBuilders() {
        LinkedHashMap<String, FactoryBuilderSupport> builders = new LinkedHashMap<String, FactoryBuilderSupport>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup group : this.groups.values()) {
                FactoryBuilderSupport builder = group.getBuilder();
                if (builder == null) continue;
                builders.put(group.getMvcId(), builder);
            }
        }
        return Collections.unmodifiableMap(builders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, ? extends GriffonModel> getModels() {
        LinkedHashMap<String, GriffonModel> models = new LinkedHashMap<String, GriffonModel>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup group : this.groups.values()) {
                GriffonModel model = group.getModel();
                if (model == null) continue;
                models.put(group.getMvcId(), model);
            }
        }
        return Collections.unmodifiableMap(models);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, ? extends GriffonView> getViews() {
        LinkedHashMap<String, GriffonView> views = new LinkedHashMap<String, GriffonView>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup group : this.groups.values()) {
                GriffonView view = group.getView();
                if (view == null) continue;
                views.put(group.getMvcId(), view);
            }
        }
        return Collections.unmodifiableMap(views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, ? extends GriffonController> getControllers() {
        LinkedHashMap<String, GriffonController> controllers = new LinkedHashMap<String, GriffonController>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup group : this.groups.values()) {
                GriffonController controller = group.getController();
                if (controller == null) continue;
                controllers.put(group.getMvcId(), controller);
            }
        }
        return Collections.unmodifiableMap(controllers);
    }
}

