/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ArtifactHandler;
import griffon.core.ArtifactInfo;
import griffon.core.ArtifactManager;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.util.CallableWithArgs;
import griffon.util.CallableWithArgsClosure;
import griffon.util.GriffonNameUtils;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifactManager
implements ArtifactManager {
    private final GriffonApplication app;
    private final Map<String, ArtifactInfo[]> artifacts = new LinkedHashMap<String, ArtifactInfo[]>();
    private final Map<String, ArtifactHandler> artifactHandlers = new LinkedHashMap<String, ArtifactHandler>();
    private final Object lock = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractArtifactManager.class);
    private static final Pattern GET_METHOD_PATTERN = Pattern.compile("^get(\\w+)Classes$");
    private static final Pattern IS_METHOD_PATTERN = Pattern.compile("^is(\\w+)Class$");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^(\\w+)Classes$");

    public AbstractArtifactManager(GriffonApplication app) {
        this.app = app;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    protected Map<String, ArtifactInfo[]> getArtifacts() {
        return this.artifacts;
    }

    protected Map<String, ArtifactHandler> getArtifactHandlers() {
        return this.artifactHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadArtifactMetadata() {
        Map<String, List<ArtifactInfo>> loadedArtifacts = this.doLoadArtifactMetadata();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, List<ArtifactInfo>> artifactsEntry : loadedArtifacts.entrySet()) {
                String type = artifactsEntry.getKey();
                List<ArtifactInfo> list = artifactsEntry.getValue();
                this.artifacts.put(type, list.toArray(new ArtifactInfo[list.size()]));
                ArtifactHandler handler = this.artifactHandlers.get(type);
                if (handler == null) continue;
                handler.initialize(this.artifacts.get(type));
            }
        }
    }

    protected abstract Map<String, List<ArtifactInfo>> doLoadArtifactMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerArtifactHandler(ArtifactHandler handler) {
        if (handler == null) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Registering artifact handler for type '" + handler.getType() + "': " + handler);
        }
        Object object = this.lock;
        synchronized (object) {
            this.artifactHandlers.put(handler.getType(), handler);
            if (this.artifacts.get(handler.getType()) != null) {
                handler.initialize(this.artifacts.get(handler.getType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterArtifactHandler(ArtifactHandler handler) {
        if (handler == null) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Removing artifact handler for type '" + handler.getType() + "': " + handler);
        }
        Object object = this.lock;
        synchronized (object) {
            this.artifactHandlers.remove(handler.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GriffonClass findGriffonClass(String name, String type) {
        if (GriffonNameUtils.isBlank(name) || GriffonNameUtils.isBlank(type)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for griffonClass of " + type + ":" + name);
        }
        Object object = this.lock;
        synchronized (object) {
            ArtifactHandler handler = this.artifactHandlers.get(type);
            return handler != null ? handler.findClassFor(name) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GriffonClass findGriffonClass(Class clazz, String type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for griffonClass of " + type + ":" + clazz.getName());
        }
        Object object = this.lock;
        synchronized (object) {
            ArtifactHandler handler = this.artifactHandlers.get(type);
            return handler != null ? handler.getClassFor(clazz) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GriffonClass findGriffonClass(Object obj) {
        if (obj == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for griffonClass of " + obj);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.findGriffonClass(obj.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GriffonClass findGriffonClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for griffonClass of " + clazz.getName());
        }
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler handler : this.artifactHandlers.values()) {
                GriffonClass griffonClass = handler.getClassFor(clazz);
                if (griffonClass == null) continue;
                return griffonClass;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GriffonClass findGriffonClass(String fqnClassName) {
        if (GriffonNameUtils.isBlank(fqnClassName)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for griffonClass of " + fqnClassName);
        }
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler handler : this.artifactHandlers.values()) {
                GriffonClass griffonClass = handler.getClassFor(fqnClassName);
                if (griffonClass == null) continue;
                return griffonClass;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GriffonClass> getClassesOfType(String type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.artifacts.containsKey(type)) {
                return DefaultGroovyMethods.toList((Object[])this.artifactHandlers.get(type).getClasses());
            }
        }
        return EMPTY_GRIFFON_CLASS_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GriffonClass> getAllClasses() {
        ArrayList all = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler handler : this.artifactHandlers.values()) {
                all.addAll(DefaultGroovyMethods.toList((Object[])handler.getClasses()));
            }
        }
        return Collections.unmodifiableList(all);
    }

    public Object methodMissing(final String methodName, Object args) {
        Object[] arguments = new Object[]{};
        arguments = args != null && args.getClass().isArray() ? (Object[])args : new Object[]{args};
        Matcher matcher = GET_METHOD_PATTERN.matcher(methodName);
        if (matcher.matches()) {
            final String artifactType = GriffonNameUtils.uncapitalize(matcher.group(1));
            if (arguments.length == 0 && this.artifacts.containsKey(artifactType)) {
                MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(ArtifactManager.class);
                if (mc instanceof ExpandoMetaClass) {
                    ExpandoMetaClass emc = (ExpandoMetaClass)mc;
                    CallableWithArgs<List<GriffonClass>> callable = new CallableWithArgs<List<GriffonClass>>(){

                        @Override
                        public List<GriffonClass> call(Object[] params) {
                            if (params != null) {
                                throw new MissingMethodException(methodName, ArtifactManager.class, params);
                            }
                            return AbstractArtifactManager.this.getClassesOfType(artifactType);
                        }
                    };
                    emc.registerInstanceMethod(methodName, new CallableWithArgsClosure<List<GriffonClass>>(this, callable));
                }
                return this.getClassesOfType(artifactType);
            }
            return EMPTY_GRIFFON_CLASS_ARRAY;
        }
        matcher = IS_METHOD_PATTERN.matcher(methodName);
        if (matcher.matches()) {
            final String artifactType = GriffonNameUtils.uncapitalize(matcher.group(1));
            if (arguments.length == 1 && this.artifacts.containsKey(artifactType)) {
                MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(ArtifactManager.class);
                if (mc instanceof ExpandoMetaClass) {
                    ExpandoMetaClass emc = (ExpandoMetaClass)mc;
                    CallableWithArgs<Boolean> callable = new CallableWithArgs<Boolean>(){

                        @Override
                        public Boolean call(Object[] params) {
                            if (params == null || params.length != 1 || !(params[0] instanceof Class)) {
                                throw new MissingMethodException(methodName, ArtifactManager.class, params);
                            }
                            Class klass = (Class)params[0];
                            return AbstractArtifactManager.this.isClassOfType(artifactType, klass);
                        }
                    };
                    emc.registerInstanceMethod(methodName, new CallableWithArgsClosure<Boolean>(this, callable));
                }
                return this.isClassOfType(artifactType, (Class)arguments[0]);
            }
            return false;
        }
        throw new MissingMethodException(methodName, ArtifactManager.class, arguments);
    }

    public Object propertyMissing(String propertyName) {
        Matcher matcher = PROPERTY_PATTERN.matcher(propertyName);
        if (matcher.matches()) {
            String artifactType = GriffonNameUtils.uncapitalize(matcher.group(1));
            if (this.artifacts.containsKey(artifactType)) {
                List<GriffonClass> griffonClasses = this.getClassesOfType(artifactType);
                MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(ArtifactManager.class);
                if (mc instanceof ExpandoMetaClass) {
                    ExpandoMetaClass emc = (ExpandoMetaClass)mc;
                    emc.registerBeanProperty(propertyName, griffonClasses);
                }
                return griffonClasses;
            }
            return EMPTY_GRIFFON_CLASS_ARRAY;
        }
        throw new MissingPropertyException(propertyName, Object.class);
    }

    protected boolean isClassOfType(String type, Class clazz) {
        for (ArtifactInfo artifactInfo : this.artifacts.get(type)) {
            if (!artifactInfo.getClazz().getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

