/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.ApplicationClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata
extends Properties {
    public static final String FILE = "application.properties";
    public static final String APPLICATION_VERSION = "app.version";
    public static final String APPLICATION_NAME = "app.name";
    public static final String APPLICATION_GRIFFON_VERSION = "app.griffon.version";
    public static final String GRIFFON_START_DIR = "griffon.start.dir";
    public static final String GRIFFON_WORKING_DIR = "griffon.working.dir";
    public static final String APPLICATION_TOOLKIT = "app.toolkit";
    private static final Pattern SKIP_PATTERN = Pattern.compile("^.*\\/griffon-.*.jar!\\/application.properties$");
    private static Reference<Metadata> metadata = new SoftReference<Metadata>(new Metadata());
    private boolean initialized;
    private File metadataFile;
    private boolean dirty;

    private Metadata() {
    }

    private Metadata(File f) {
        this.metadataFile = f;
    }

    public static void reset() {
        Metadata m = metadata.get();
        if (m != null) {
            m.clear();
            m.initialized = false;
            m.dirty = false;
        }
    }

    public static Metadata getCurrent() {
        Metadata m = metadata.get();
        if (m == null) {
            metadata = new SoftReference<Metadata>(new Metadata());
            m = metadata.get();
        }
        if (!m.initialized) {
            InputStream input = null;
            try {
                input = Metadata.fetchApplicationProperties(ApplicationClassLoader.get());
                if (input == null) {
                    input = Metadata.fetchApplicationProperties(Metadata.class.getClassLoader());
                }
                if (input != null) {
                    m.load(input);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
            }
            finally {
                Metadata.closeQuietly(input);
                m.initialized = true;
            }
        }
        return m;
    }

    public static Metadata getInstance(InputStream inputStream) {
        Metadata m = new Metadata();
        metadata = new FinalReference<Metadata>(m);
        try {
            m.load(inputStream);
            m.initialized = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
        }
        return m;
    }

    public static Metadata getInstance(File file) {
        Metadata m = new Metadata(file);
        metadata = new FinalReference<Metadata>(m);
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                m.load(input);
                m.initialized = true;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(input);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(input);
        }
        return m;
    }

    public static Metadata reload() {
        File f = Metadata.getCurrent().metadataFile;
        if (f != null) {
            return Metadata.getInstance(f);
        }
        return Metadata.getCurrent();
    }

    public String getApplicationVersion() {
        return (String)this.get(APPLICATION_VERSION);
    }

    public String getGriffonVersion() {
        return (String)this.get(APPLICATION_GRIFFON_VERSION);
    }

    public String getEnvironment() {
        return (String)this.get("griffon.env");
    }

    public String getApplicationName() {
        return (String)this.get(APPLICATION_NAME);
    }

    public String getApplicationToolkit() {
        return (String)this.get(APPLICATION_TOOLKIT);
    }

    public Map<String, String> getInstalledPlugins() {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            if (!key.startsWith("plugins.") || val == null) continue;
            newMap.put(key.substring(8), val.toString());
        }
        return newMap;
    }

    public Map<String, String> getArchetype() {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            if (!key.startsWith("archetype.") || val == null) continue;
            newMap.put("name", key.substring(10));
            newMap.put("version", val.toString());
            break;
        }
        return newMap;
    }

    public String getGriffonStartDir() {
        String griffonStartDir = (String)this.get(GRIFFON_START_DIR);
        if (griffonStartDir == null) {
            griffonStartDir = System.getProperty(GRIFFON_START_DIR);
            if (griffonStartDir != null && griffonStartDir.length() > 1 && griffonStartDir.startsWith("\"") && griffonStartDir.endsWith("\"")) {
                griffonStartDir = griffonStartDir.substring(1, griffonStartDir.length() - 1);
                System.setProperty(GRIFFON_START_DIR, griffonStartDir);
            }
            if (griffonStartDir != null && griffonStartDir.length() > 1 && griffonStartDir.startsWith("'") && griffonStartDir.endsWith("'")) {
                griffonStartDir = griffonStartDir.substring(1, griffonStartDir.length() - 1);
                System.setProperty(GRIFFON_START_DIR, griffonStartDir);
            }
            if (griffonStartDir != null) {
                this.put(GRIFFON_START_DIR, griffonStartDir);
            }
        }
        return griffonStartDir;
    }

    public String getGriffonStartDirSafe() {
        String griffonStartDir = this.getGriffonStartDir();
        if (griffonStartDir == null) {
            File path = new File(".");
            if (path.canWrite()) {
                return path.getAbsolutePath();
            }
            return System.getProperty("user.dir");
        }
        return griffonStartDir;
    }

    public File getGriffonWorkingDir() {
        String griffonWorkingDir = (String)this.get(GRIFFON_WORKING_DIR);
        if (griffonWorkingDir == null) {
            String griffonStartDir = this.getGriffonStartDirSafe();
            File workDir = new File(griffonStartDir);
            if (workDir.canWrite()) {
                this.put(GRIFFON_WORKING_DIR, griffonStartDir);
                return workDir;
            }
            try {
                File temp = File.createTempFile("griffon", ".tmp");
                temp.deleteOnExit();
                workDir = new File(temp.getParent(), this.getApplicationName());
                this.put(GRIFFON_WORKING_DIR, workDir.getAbsolutePath());
                return workDir;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return new File(griffonWorkingDir);
    }

    public void persist() {
        if (this.dirty && this.metadataFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.metadataFile);
                this.store(out, "Griffon Metadata file");
                this.dirty = false;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Error persisting metadata to file [" + this.metadataFile + "]: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(out);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(out);
        }
    }

    public boolean propertiesHaveNotChanged() {
        return this.dirty;
    }

    @Override
    public synchronized Object setProperty(String name, String value) {
        String oldValue;
        this.dirty = this.containsKey(name) ? (oldValue = this.getProperty(name)) != null && !oldValue.equals(value) : true;
        return super.setProperty(name, value);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object oldValue;
        this.dirty = this.containsKey(key) ? (oldValue = this.get(key)) != null && !oldValue.equals(value) : true;
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
        this.dirty = true;
        super.putAll(map);
    }

    @Override
    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static InputStream fetchApplicationProperties(ClassLoader classLoader) {
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(FILE);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        while (urls.hasMoreElements()) {
            try {
                URL url = urls.nextElement();
                if (SKIP_PATTERN.matcher(url.toString()).matches()) continue;
                return url.openStream();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FinalReference<T>
    extends SoftReference<T> {
        private T ref;

        public FinalReference(T t) {
            super(t);
            this.ref = t;
        }

        @Override
        public T get() {
            return this.ref;
        }
    }
}

