/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Status {
    SUCCESS(100, 399),
    FAILURE(400, 999);

    private final int min;
    private final int max;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public boolean matches(int code) {
        return this.min <= code && code <= this.max;
    }

    public static Status find(int code) {
        Status[] statusArray = Status.values();
        int n = statusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Status s = statusArray[n2];
            if (s.matches(code)) {
                return s;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown status: " + code);
    }

    private Status(int min, int max) {
        this.min = min;
        this.max = max;
    }
}

