/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util.i18n;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceManager {
    private static Log log = LogFactory.getLog(ResourceManager.class);
    private static ThreadLocal instance = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ResourceManager();
        }
    };
    private Locale locale = null;
    private Enumeration fallback = null;
    private Map resourceBundles = new HashMap();

    public static ResourceManager forceGet() {
        instance.set(null);
        return ResourceManager.get();
    }

    public static ResourceManager get() {
        ResourceManager resourceManager = (ResourceManager)instance.get();
        if (null == resourceManager) {
            resourceManager = new ResourceManager();
            instance.set(resourceManager);
        }
        return resourceManager;
    }

    public static ResourceBundle getBundle(String string) {
        return ResourceManager.get().getResourceBundle(string);
    }

    public static Locale getLocale(String string) {
        return ResourceManager.get().getResourceBundle(string).getLocale();
    }

    public static String getString(String string, String string2) {
        try {
            ResourceBundle resourceBundle = ResourceManager.getBundle(string);
            return resourceBundle.getString(string2);
        }
        catch (Exception exception) {
            log.warn((Object)("missing resource for bundle '" + string + "', key '" + string2 + "'"), (Throwable)exception);
            return "???" + string2 + "???";
        }
    }

    public void setLocale(Locale locale, Enumeration enumeration) {
        this.locale = locale;
        this.fallback = enumeration;
    }

    public ResourceBundle getResourceBundle(String string) {
        ResourceBundle resourceBundle = (ResourceBundle)this.resourceBundles.get(string);
        if (null == resourceBundle) {
            resourceBundle = this.findBundle(string);
            this.resourceBundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    private ResourceBundle findBundle(String string) {
        ResourceBundle resourceBundle = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null != this.locale) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, this.locale, classLoader);
            }
            catch (Exception exception) {
                log.fatal((Object)("unable to load a default bundle: " + string + "_" + this.locale));
            }
            if (!resourceBundle.getLocale().equals(this.locale)) {
                resourceBundle = null;
            }
        }
        if (null == resourceBundle) {
            if (null != this.fallback) {
                while (this.fallback.hasMoreElements()) {
                    Locale locale = (Locale)this.fallback.nextElement();
                    log.debug((Object)("looking up locale " + locale));
                    ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string, locale, classLoader);
                    String string2 = resourceBundle2.getLocale().getLanguage();
                    String string3 = resourceBundle2.getLocale().getCountry();
                    if (resourceBundle2.getLocale().equals(locale)) {
                        resourceBundle = resourceBundle2;
                        log.debug((Object)("found bundle for locale " + string + "_" + resourceBundle2.getLocale()));
                        break;
                    }
                    if (!locale.getLanguage().equals(string2)) continue;
                    if (locale.getCountry().equals(string3)) {
                        resourceBundle = resourceBundle2;
                        log.debug((Object)("potential bundle: " + string + "_" + resourceBundle2.getLocale()));
                        continue;
                    }
                    if (null != resourceBundle) continue;
                    resourceBundle = resourceBundle2;
                    log.debug((Object)("potential bundle: " + string + "_" + resourceBundle2.getLocale()));
                }
            }
            if (null == resourceBundle && null != (resourceBundle = ResourceBundle.getBundle(string))) {
                log.debug((Object)("system locale bundle taken: " + string + "_" + resourceBundle.getLocale()));
            }
        }
        return resourceBundle;
    }
}

