/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.xref;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XrefMapper {
    private static Log log = LogFactory.getLog(XrefMapper.class);
    private static final String FILENAME = "conf/xref.txt";
    private static XrefMapper instance;
    private Map xrefMap = new HashMap();

    public static synchronized XrefMapper getInstance() {
        if (null == instance) {
            instance = new XrefMapper();
        }
        return instance;
    }

    public XrefMapper() {
        BufferedReader bufferedReader;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(FILENAME)));
            this.addXref(bufferedReader);
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to read conf/xref.txt");
            bl = true;
        }
        if (bl) {
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(XrefMapper.class.getResourceAsStream("/conf/xref.txt")));
                this.addXref(bufferedReader);
            }
            catch (Exception exception) {
                log.warn((Object)"Unable to read conf/xref.txt");
            }
        }
    }

    public void addXref(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.xrefMap.put(string2.toLowerCase(), string3);
        }
    }

    public boolean contains(String string) {
        return this.xrefMap.containsKey(string);
    }

    public Writer expand(Writer writer, String string, String string2, int n) throws IOException {
        if (this.xrefMap.containsKey(string2 = string2.toLowerCase())) {
            writer.write("<a href=\"");
            writer.write((String)this.xrefMap.get(string2));
            writer.write("/");
            writer.write(string.replace('.', '/'));
            writer.write(".html");
            if (n > 0) {
                writer.write("#");
                writer.write("" + n);
            }
            writer.write("\">");
            writer.write(string);
            writer.write("</a>");
        } else {
            log.debug((Object)("Xrefs : " + this.xrefMap));
            log.warn((Object)(string2 + " not found"));
        }
        return writer;
    }

    public Writer appendTo(Writer writer) throws IOException {
        writer.write("{table}\n");
        writer.write("Binding|Site\n");
        for (Map.Entry entry : this.xrefMap.entrySet()) {
            writer.write((String)entry.getKey());
            writer.write("|");
            writer.write((String)entry.getValue());
            writer.write("\n");
        }
        writer.write("{table}");
        return writer;
    }
}

