/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.code;

import org.radeox.macro.code.DefaultRegexCodeFormatter;
import org.radeox.macro.code.SourceCodeFormatter;

public class SqlCodeFilter
extends DefaultRegexCodeFormatter
implements SourceCodeFormatter {
    private static final String KEYWORDS = "\\b(SELECT|INSERT INTO|DELETE|UPDATE|CREATE|DROP|IF EXISTS|TABLE|TEMPORARY|WHERE|LEFT JOIN|ON|FROM|GROUP|BY|HAVING|AND|OR|ORDER)\\b";
    private static final String OBJECTS = "\\b(VARCHAR)\\b";
    private static final String QUOTES = "\"(([^\"\\\\]|\\.)*)\"";
    private static final String COMMENTS = "^#(.*)$";
    private static final String EMPTYLINES = "^\\s*$";

    public SqlCodeFilter() {
        super(QUOTES, "<span class='sql-quote'>\"$1\"</span>");
        this.addRegex(OBJECTS, "<span class='sql-object'>$1</span>");
        this.addRegex(KEYWORDS, "<span class='sql-keyword'>$1</span>");
        this.addRegex(COMMENTS, "<span class='sql-comment'>&#35;$1</span>");
        this.addRegex(EMPTYLINES, "");
    }

    @Override
    public String getName() {
        return "sql";
    }
}

