/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.book;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.book.UrlMapper;
import org.radeox.util.Encoder;

public abstract class TextFileUrlMapper
implements UrlMapper {
    private static Log log = LogFactory.getLog(TextFileUrlMapper.class);
    private Map services = new HashMap();

    public abstract String getFileName();

    public abstract String getKeyName();

    public TextFileUrlMapper(Class clazz) {
        BufferedReader bufferedReader;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.getFileName())));
            this.addMapping(bufferedReader);
        }
        catch (IOException iOException) {
            log.warn((Object)("Unable to read " + this.getFileName()));
            bl = true;
        }
        if (bl) {
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream("/" + this.getFileName())));
                this.addMapping(bufferedReader);
            }
            catch (Exception exception) {
                log.warn((Object)("Unable to read /" + this.getFileName() + " from jar"));
            }
        }
    }

    public void addMapping(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            int n = string.indexOf(" ");
            this.services.put(string.substring(0, n), Encoder.escape(string.substring(n + 1)));
        }
    }

    @Override
    public Writer appendTo(Writer writer) throws IOException {
        Iterator iterator = this.services.entrySet().iterator();
        writer.write("{table}\n");
        writer.write("Service|Url\n");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            writer.write((String)entry.getKey());
            writer.write("|");
            writer.write((String)entry.getValue());
            writer.write("\n");
        }
        writer.write("{table}");
        return writer;
    }

    public boolean contains(String string) {
        return this.services.containsKey(string);
    }

    @Override
    public Writer appendUrl(Writer writer, String string) throws IOException {
        if (this.services.size() == 0) {
            writer.write(this.getKeyName());
            writer.write(":");
            writer.write(string);
        } else {
            writer.write("(");
            Iterator iterator = this.services.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                writer.write("<a href=\"");
                writer.write((String)entry.getValue());
                writer.write(string);
                writer.write("\">");
                writer.write((String)entry.getKey());
                writer.write("</a>");
                if (!iterator.hasNext()) continue;
                writer.write(" &#x7c; ");
            }
            writer.write(")");
        }
        return writer;
    }
}

