/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.LocalePreserved;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.util.i18n.ResourceManager;

public class QuoteMacro
extends LocalePreserved {
    private static Log log = LogFactory.getLog(QuoteMacro.class);

    @Override
    public String getLocaleKey() {
        return "macro.quote";
    }

    @Override
    public void execute(Writer writer, MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        String string;
        writer.write("<blockquote class=\"quote\">");
        writer.write(macroParameter.getContent());
        try {
            string = ResourceManager.getString((String)this.initialContext.get("RenderContext.language_bundle_name"), this.getLocaleKey() + ".source");
        }
        catch (Exception exception) {
            log.warn((Object)("missing value for " + this.getLocaleKey() + ".source"));
            string = "Source";
        }
        if (macroParameter.getLength() > 0) {
            String string2 = macroParameter.get(0);
            boolean bl = string2.toLowerCase().startsWith("http://");
            if (macroParameter.getLength() == 2) {
                string = macroParameter.get(1);
            }
            if (bl) {
                writer.write("<br><a href=\"" + string2 + "\">");
                writer.write(string);
                writer.write("</a>");
            } else {
                writer.write("<br><b>" + string2 + "</b>");
            }
        }
        writer.write("</blockquote>");
    }
}

