/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.Repository;
import org.radeox.util.Service;

public abstract class PluginLoader {
    private static Log log = LogFactory.getLog(PluginLoader.class);
    protected Repository repository;

    public Repository loadPlugins(Repository repository) {
        return this.loadPlugins(repository, this.getLoadClass());
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Iterator getPlugins(Class clazz) {
        return Service.providers(clazz);
    }

    public Repository loadPlugins(Repository repository, Class clazz) {
        if (null != repository) {
            Iterator iterator = this.getPlugins(clazz);
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    this.add(repository, e);
                    log.debug((Object)("PluginLoader: Loaded plugin: " + e.getClass()));
                }
                catch (Exception exception) {
                    log.warn((Object)"PluginLoader: unable to load plugin", (Throwable)exception);
                }
            }
        }
        return repository;
    }

    public abstract void add(Repository var1, Object var2);

    public abstract Class getLoadClass();
}

