/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.Macro;
import org.radeox.macro.MacroLoader;
import org.radeox.macro.PluginRepository;

public class MacroRepository
extends PluginRepository {
    private static Log log = LogFactory.getLog(MacroRepository.class);
    protected static MacroRepository instance;
    protected List loaders = new ArrayList();

    public static synchronized MacroRepository getInstance() {
        if (null == instance) {
            instance = new MacroRepository();
        }
        return instance;
    }

    private void initialize(InitialRenderContext initialRenderContext) {
        for (Macro macro : this.list) {
            macro.setInitialContext(initialRenderContext);
        }
        this.init();
    }

    public void setInitialContext(InitialRenderContext initialRenderContext) {
        this.initialize(initialRenderContext);
    }

    private void init() {
        HashMap<String, Macro> hashMap = new HashMap<String, Macro>();
        for (Macro macro : this.list) {
            hashMap.put(macro.getName(), macro);
        }
        this.plugins = hashMap;
    }

    private void load() {
        for (MacroLoader macroLoader : this.loaders) {
            macroLoader.setRepository(this);
            log.debug((Object)("Loading from: " + macroLoader.getClass()));
            macroLoader.loadPlugins(this);
        }
    }

    public void addLoader(MacroLoader macroLoader) {
        macroLoader.setRepository(this);
        this.loaders.add(macroLoader);
        this.plugins = new HashMap();
        this.list = new ArrayList();
        this.load();
    }

    private MacroRepository() {
        this.loaders.add(new MacroLoader());
        this.load();
    }
}

