/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;

public class ListFilter
extends LocaleRegexTokenFilter
implements CacheFilter {
    private static Log log = LogFactory.getLog(ListFilter.class);
    private static final Map openList = new HashMap();
    private static final Map closeList = new HashMap();
    private static final String UL_CLOSE = "</ul>";
    private static final String OL_CLOSE = "</ol>";

    @Override
    protected String getLocaleKey() {
        return "filter.list";
    }

    @Override
    protected boolean isSingleLine() {
        return false;
    }

    public ListFilter() {
        openList.put(new Character('-'), "<ul class=\"minus\">");
        openList.put(new Character('*'), "<ul class=\"star\">");
        openList.put(new Character('#'), "<ol>");
        openList.put(new Character('i'), "<ol class=\"roman\">");
        openList.put(new Character('I'), "<ol class=\"ROMAN\">");
        openList.put(new Character('a'), "<ol class=\"alpha\">");
        openList.put(new Character('A'), "<ol class=\"ALPHA\">");
        openList.put(new Character('g'), "<ol class=\"greek\">");
        openList.put(new Character('h'), "<ol class=\"hiragana\">");
        openList.put(new Character('H'), "<ol class=\"HIRAGANA\">");
        openList.put(new Character('k'), "<ol class=\"katakana\">");
        openList.put(new Character('K'), "<ol class=\"KATAKANA\">");
        openList.put(new Character('j'), "<ol class=\"HEBREW\">");
        openList.put(new Character('1'), "<ol>");
        closeList.put(new Character('-'), UL_CLOSE);
        closeList.put(new Character('*'), UL_CLOSE);
        closeList.put(new Character('#'), OL_CLOSE);
        closeList.put(new Character('i'), OL_CLOSE);
        closeList.put(new Character('I'), OL_CLOSE);
        closeList.put(new Character('a'), OL_CLOSE);
        closeList.put(new Character('A'), OL_CLOSE);
        closeList.put(new Character('1'), OL_CLOSE);
        closeList.put(new Character('g'), OL_CLOSE);
        closeList.put(new Character('G'), OL_CLOSE);
        closeList.put(new Character('h'), OL_CLOSE);
        closeList.put(new Character('H'), OL_CLOSE);
        closeList.put(new Character('k'), OL_CLOSE);
        closeList.put(new Character('K'), OL_CLOSE);
        closeList.put(new Character('j'), OL_CLOSE);
    }

    @Override
    public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult, FilterContext filterContext) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(matchResult.group(0)));
            this.addList(stringBuffer, bufferedReader);
        }
        catch (Exception exception) {
            log.warn((Object)"ListFilter: unable get list content", (Throwable)exception);
        }
    }

    private void addList(StringBuffer stringBuffer, BufferedReader bufferedReader) throws IOException {
        int n;
        char[] cArray = new char[]{};
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            if ((string = string.trim()).length() == 0 || (n = string.indexOf(32)) < 1) continue;
            if (string.charAt(n - 1) == '.') {
                --n;
            }
            char[] cArray2 = string.substring(0, n).toCharArray();
            for (int i = 0; cArray2.length > i && cArray.length > i && cArray2[i] == cArray[i]; ++i) {
            }
            for (n2 = i; n2 < cArray.length; ++n2) {
                stringBuffer.append(closeList.get(new Character(cArray[n2]))).append("\n");
            }
            for (n2 = i; n2 < cArray2.length; ++n2) {
                stringBuffer.append(openList.get(new Character(cArray2[n2]))).append("\n");
            }
            stringBuffer.append("<li>");
            stringBuffer.append(string.substring(string.indexOf(32) + 1));
            stringBuffer.append("</li>\n");
            cArray = cArray2;
        }
        for (n = cArray.length - 1; n >= 0; --n) {
            stringBuffer.append(closeList.get(new Character(cArray[n])));
        }
    }
}

