/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import org.radeox.filter.CacheFilter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;
import org.radeox.util.Encoder;

public class EscapeFilter
extends LocaleRegexTokenFilter
implements CacheFilter {
    @Override
    protected String getLocaleKey() {
        return "filter.escape";
    }

    @Override
    public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult, FilterContext filterContext) {
        stringBuffer.append(this.handleMatch(matchResult, filterContext));
    }

    public String handleMatch(MatchResult matchResult, FilterContext filterContext) {
        if (matchResult.group(1) == null) {
            String string = matchResult.group(2);
            if (string == null) {
                string = matchResult.group(3);
            }
            if ("\\".equals(string)) {
                return "\\\\";
            }
            return Encoder.toEntity(string.charAt(0));
        }
        return "&#92;";
    }

    @Override
    public String[] before() {
        return FilterPipe.FIRST_BEFORE;
    }
}

