/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.aware;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.spring.beans.MicronautContextInternal;
import io.micronaut.spring.context.MicronautApplicationContext;
import io.micronaut.spring.context.env.MicronautEnvironment;
import io.micronaut.spring.context.factory.MicronautBeanFactory;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

@Singleton
@Internal
public class SpringAwareListener
implements BeanInitializedEventListener<Object>,
BeanCreatedEventListener<Object> {
    public static final int ROLE_APPLICATION = 0;
    private final BeanProvider<MicronautBeanFactory> beanFactoryProvider;
    private final BeanProvider<MicronautEnvironment> environmentProvider;
    private final BeanProvider<MicronautApplicationContext> applicationContextProvider;
    private Collection<BeanPostProcessor> beanPostProcessors;

    public SpringAwareListener(BeanProvider<MicronautBeanFactory> beanFactoryProvider, BeanProvider<MicronautEnvironment> environmentProvider, BeanProvider<MicronautApplicationContext> applicationContextProvider) {
        this.beanFactoryProvider = beanFactoryProvider;
        this.environmentProvider = environmentProvider;
        this.applicationContextProvider = applicationContextProvider;
    }

    public Object onInitialized(BeanInitializingEvent<Object> event) {
        Object bean = event.getBean();
        if (bean instanceof MicronautContextInternal) {
            return bean;
        }
        this.wireAwareObjects(bean);
        return bean;
    }

    private void wireAwareObjects(Object bean) {
        if (bean instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)bean).setBeanClassLoader(Objects.requireNonNull(((MicronautApplicationContext)this.applicationContextProvider.get()).getClassLoader()));
        }
        if (bean instanceof EnvironmentAware) {
            ((EnvironmentAware)bean).setEnvironment((Environment)this.environmentProvider.get());
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory((BeanFactory)this.beanFactoryProvider.get());
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext((ApplicationContext)this.applicationContextProvider.get());
        }
        if (bean instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)bean).setResourceLoader((ResourceLoader)this.applicationContextProvider.get());
        }
    }

    public Object onCreated(BeanCreatedEvent<Object> event) {
        Object bean = event.getBean();
        if (bean instanceof MicronautContextInternal) {
            return bean;
        }
        return this.onBeanCreated((BeanDefinition<Object>)event.getBeanDefinition(), bean, this.resolveBeanName(event));
    }

    private String resolveBeanName(BeanCreatedEvent<Object> event) {
        BeanIdentifier beanIdentifier = event.getBeanIdentifier();
        String name = beanIdentifier.getName();
        if (name.equals("Primary")) {
            return NameUtils.decapitalize((String)event.getBeanDefinition().getBeanType().getSimpleName());
        }
        return name;
    }

    @Deprecated
    public Object onBeanCreated(Object o, Object bean) {
        return this.onBeanCreated(null, bean, null);
    }

    public Object onBeanCreated(@Nullable BeanDefinition<Object> beanDefinition, Object bean, String beanName) {
        BeanPostProcessor processor;
        Object o;
        Iterator<BeanPostProcessor> iterator;
        this.wireAwareObjects(bean);
        if (!(bean instanceof BeanPostProcessor)) {
            this.initProcessors();
            Collection<BeanPostProcessor> processors = this.beanPostProcessors;
            iterator = processors.iterator();
            while (iterator.hasNext() && (o = (processor = iterator.next()).postProcessBeforeInitialization(bean, beanName)) != null) {
                bean = o;
            }
        }
        if (bean instanceof InitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanCreationException(e.getMessage(), (Throwable)e);
            }
        }
        if (!(bean instanceof BeanPostProcessor)) {
            int role;
            int n = role = beanDefinition != null ? beanDefinition.intValue(Role.class).orElse(0) : 0;
            if (role == 0) {
                this.initProcessors();
                iterator = this.beanPostProcessors.iterator();
                while (iterator.hasNext() && (o = (processor = iterator.next()).postProcessAfterInitialization(bean, beanName)) != null) {
                    bean = o;
                }
            }
        }
        return bean;
    }

    private void initProcessors() {
        if (this.beanPostProcessors == null) {
            this.beanPostProcessors = new ArrayList<BeanPostProcessor>();
            MicronautBeanFactory micronautBeanFactory = (MicronautBeanFactory)((Object)this.beanFactoryProvider.get());
            Collection processors = micronautBeanFactory.getBeanContext().getBeansOfType(BeanPostProcessor.class);
            this.beanPostProcessors.addAll(processors);
        }
    }

    public void resetPostProcessors() {
        this.beanPostProcessors = null;
    }
}

