/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.annotation.context;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ComponentAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.stereotype.Component";
    }

    @Override
    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Optional beanName = annotation.getValue(String.class);
        ArrayList mappedAnnotations = new ArrayList(2);
        mappedAnnotations.add(AnnotationValue.builder(Bean.class).build());
        mappedAnnotations.add(AnnotationValue.builder(DefaultScope.class).value(Singleton.class).build());
        beanName.ifPresent(s -> mappedAnnotations.add(AnnotationValue.builder((String)"javax.inject.Named").value(s).build()));
        return mappedAnnotations;
    }
}

