/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.core.type;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.spring.core.annotation.MicronautMergedAnnotations;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

@Internal
public final class ClassElementSpringMetadata
implements AnnotationMetadata {
    private final ClassElement classElement;

    public ClassElementSpringMetadata(ClassElement classElement) {
        this.classElement = classElement;
    }

    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        return this.classElement.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(ann -> ann.hasAnnotation(annotationName))).stream().map(x$0 -> new MethodMetadataImpl((MethodElement)x$0)).collect(Collectors.toSet());
    }

    public MergedAnnotations getAnnotations() {
        return new MicronautMergedAnnotations(this.classElement.getAnnotationMetadata());
    }

    public String getClassName() {
        return this.classElement.getName();
    }

    public boolean isInterface() {
        return this.classElement.isInterface();
    }

    public boolean isAnnotation() {
        return this.classElement.isAssignable(Annotation.class);
    }

    public boolean isAbstract() {
        return this.classElement.isAbstract();
    }

    public boolean isFinal() {
        return this.classElement.isFinal();
    }

    public boolean isIndependent() {
        return !this.classElement.getEnclosingType().isPresent();
    }

    public String getEnclosingClassName() {
        return this.classElement.getEnclosingType().map(Element::getName).orElse(null);
    }

    public String getSuperClassName() {
        return this.classElement.getSuperType().map(Element::getName).orElse(null);
    }

    public String[] getInterfaceNames() {
        return (String[])this.classElement.getInterfaces().stream().map(Element::getName).toArray(String[]::new);
    }

    public String[] getMemberClassNames() {
        return (String[])this.classElement.getEnclosedElements(ElementQuery.ALL_INNER_CLASSES).stream().map(Element::getName).toArray(String[]::new);
    }

    private final class MethodMetadataImpl
    implements MethodMetadata {
        private final MethodElement methodElement;

        private MethodMetadataImpl(MethodElement methodElement) {
            this.methodElement = methodElement;
        }

        public String getMethodName() {
            return this.methodElement.getName();
        }

        public String getDeclaringClassName() {
            return this.methodElement.getDeclaringType().getName();
        }

        public String getReturnTypeName() {
            return this.methodElement.getGenericReturnType().getName();
        }

        public boolean isAbstract() {
            return this.methodElement.isAbstract();
        }

        public boolean isStatic() {
            return this.methodElement.isStatic();
        }

        public boolean isFinal() {
            return this.methodElement.isFinal();
        }

        public boolean isOverridable() {
            return !this.isAbstract() && !this.methodElement.isPrivate();
        }

        public MergedAnnotations getAnnotations() {
            return new MicronautMergedAnnotations(this.methodElement.getAnnotationMetadata());
        }
    }
}

