+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "PanelOptionsEditorConfig"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## PanelOptionsEditorConfig interface

<b>Signature</b>

```typescript
export interface PanelOptionsEditorConfig<TOptions, TSettings = any, TValue = any> 
```
<b>Import</b>

```typescript
import { PanelOptionsEditorConfig } from '@grafana/data';
```
<b>Properties</b>

|  Property | Type | Description |
|  --- | --- | --- |
|  [category](#category-property) | <code>string[]</code> | Array of strings representing category of the option. First element in the array will make option render as collapsible section. |
|  [defaultValue](#defaultvalue-property) | <code>TValue</code> |  |
|  [description](#description-property) | <code>string</code> | Description of the option. Will be displayed in the UI as form element description. |
|  [name](#name-property) | <code>string</code> | Name of the option. Will be displayed in the UI as form element label. |
|  [path](#path-property) | <code>(keyof TOptions &amp; string) &#124; string</code> | Path of the option property to control. |
|  [settings](#settings-property) | <code>TSettings</code> | al Custom settings of the editor. |
|  [showIf](#showif-property) | <code>(currentConfig: TOptions) =&gt; boolean &#124; undefined</code> | Function that enables configuration of when option editor should be shown based on current panel option properties. |

### category property

Array of strings representing category of the option. First element in the array will make option render as collapsible section.

<b>Signature</b>

```typescript
category?: string[];
```

### defaultValue property

<b>Signature</b>

```typescript
defaultValue?: TValue;
```

### description property

Description of the option. Will be displayed in the UI as form element description.

<b>Signature</b>

```typescript
description?: string;
```

### name property

Name of the option. Will be displayed in the UI as form element label.

<b>Signature</b>

```typescript
name: string;
```

### path property

Path of the option property to control.

<b>Signature</b>

```typescript
path: (keyof TOptions & string) | string;
```

## Example

Given options object of a type:

```ts
interface Options {
  a: {
    b: string;
  }
}

```
path can be either 'a' or 'a.b'.

### settings property

al Custom settings of the editor.

<b>Signature</b>

```typescript
settings?: TSettings;
```

### showIf property

Function that enables configuration of when option editor should be shown based on current panel option properties.

<b>Signature</b>

```typescript
showIf?: (currentConfig: TOptions) => boolean | undefined;
```
