+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "DataSourceInstanceSettings"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## DataSourceInstanceSettings interface

Frontend settings model that is passed to Datasource constructor. This differs a bit from the model above as this data model is available to every user who has access to a data source (Viewers+). This is loaded in bootData (on page load), or from: /api/frontend/settings

<b>Signature</b>

```typescript
export interface DataSourceInstanceSettings<T extends DataSourceJsonData = DataSourceJsonData> 
```
<b>Import</b>

```typescript
import { DataSourceInstanceSettings } from '@grafana/data';
```
<b>Properties</b>

|  Property | Type | Description |
|  --- | --- | --- |
|  [basicAuth](#basicauth-property) | <code>string</code> | This is the full Authorization header if basic auth is enabled. Only available here when access is Browser (direct), when access is Server (proxy) The basic auth header, username &amp; password is never exposed to browser/Frontend so this will be empty then. |
|  [database](#database-property) | <code>string</code> |  |
|  [id](#id-property) | <code>number</code> |  |
|  [jsonData](#jsondata-property) | <code>T</code> |  |
|  [meta](#meta-property) | <code>DataSourcePluginMeta</code> |  |
|  [name](#name-property) | <code>string</code> |  |
|  [password](#password-property) | <code>string</code> |  |
|  [type](#type-property) | <code>string</code> |  |
|  [uid](#uid-property) | <code>string</code> |  |
|  [url](#url-property) | <code>string</code> |  |
|  [username](#username-property) | <code>string</code> |  |
|  [withCredentials](#withcredentials-property) | <code>boolean</code> |  |

### basicAuth property

This is the full Authorization header if basic auth is enabled. Only available here when access is Browser (direct), when access is Server (proxy) The basic auth header, username &amp; password is never exposed to browser/Frontend so this will be empty then.

<b>Signature</b>

```typescript
basicAuth?: string;
```

### database property

<b>Signature</b>

```typescript
database?: string;
```

### id property

<b>Signature</b>

```typescript
id: number;
```

### jsonData property

<b>Signature</b>

```typescript
jsonData: T;
```

### meta property

<b>Signature</b>

```typescript
meta: DataSourcePluginMeta;
```

### name property

<b>Signature</b>

```typescript
name: string;
```

### password property

<b>Signature</b>

```typescript
password?: string;
```

### type property

<b>Signature</b>

```typescript
type: string;
```

### uid property

<b>Signature</b>

```typescript
uid: string;
```

### url property

<b>Signature</b>

```typescript
url?: string;
```

### username property

<b>Signature</b>

```typescript
username?: string;
```

### withCredentials property

<b>Signature</b>

```typescript
withCredentials?: boolean;
```
