/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.filters;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class OrFilter
implements ElementFilter {
    private final List<ElementFilter> myFilters;

    public OrFilter(ElementFilter ... filters) {
        this.myFilters = new SmartList<ElementFilter>(filters);
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter -> filter.isAcceptable(element, context));
    }

    public boolean isClassAcceptable(Class elementClass) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter -> filter.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, " | ") + ')';
    }
}

