/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationFinder;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AttributeMatchDetails;
import org.gradle.api.tasks.diagnostics.internal.dependencies.MatchType;
import org.gradle.api.tasks.diagnostics.internal.dsl.DependencyResultSpecNotationConverter;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphsRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.Section;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.api.tasks.diagnostics.internal.text.StyledTable;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Produces only non-cacheable console output")
public abstract class DependencyInsightReportTask
extends DefaultTask {
    private Spec<DependencyResult> dependencySpec;
    private boolean showSinglePathToDependency;
    private final Property<Boolean> showingAllVariants = this.getProject().getObjects().property(Boolean.class);
    private transient Configuration configuration;
    private final Property<ResolvedComponentResult> rootComponentProperty = this.getProject().getObjects().property(ResolvedComponentResult.class);
    private Provider<AttributeContainer> zConfigurationAttributes;
    private String configurationName;
    private String configurationDescription;

    @Input
    @Optional
    @Incubating
    public Property<ResolvedComponentResult> getRootComponentProperty() {
        Configuration configuration = this.getConfiguration();
        if (!this.rootComponentProperty.isPresent() && configuration != null && this.dependencySpec != null) {
            if (((Boolean)this.getShowingAllVariants().get()).booleanValue()) {
                ConfigurationInternal configurationInternal = (ConfigurationInternal)configuration;
                if (!configurationInternal.isCanBeMutated()) {
                    throw new IllegalStateException("The configuration '" + configuration.getName() + "' is not mutable. In order to use the '--all-variants' option, the configuration must not be resolved before this task is executed.");
                }
                configurationInternal.getResolutionStrategy().setIncludeAllSelectableVariantResults(true);
            }
            this.configurationName = configuration.getName();
            this.configurationDescription = configuration.toString();
            this.zConfigurationAttributes = this.getProject().provider(() -> ((Configuration)configuration).getAttributes());
            this.rootComponentProperty.set(configuration.getIncoming().getResolutionResult().getRootComponent());
        }
        return this.rootComponentProperty;
    }

    @Internal
    @Deprecated
    @Nullable
    public Spec<DependencyResult> getDependencySpec() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(DependencyInsightReportTask.class, (String)"getDependencySpec()").withContext("This method is not intended for public use.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "dependency-insight-report-task-get-dependency-spec")).nagUser();
        return this.dependencySpec;
    }

    public void setDependencySpec(@Nullable Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Option(option="dependency", description="Shows the details of given dependency.")
    public void setDependencySpec(@Nullable Object dependencyInsightNotation) {
        NotationParser<Object, Spec<DependencyResult>> parser = DependencyResultSpecNotationConverter.parser();
        this.setDependencySpec((Spec<DependencyResult>)((Spec)parser.parseNotation(dependencyInsightNotation)));
    }

    @Internal
    @Nullable
    @ToBeReplacedByLazyProperty
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
    }

    @Option(option="configuration", description="Looks for the dependency in given configuration.")
    public void setConfiguration(@Nullable String configurationName) {
        this.setConfiguration(configurationName == null ? null : ConfigurationFinder.find(this.getProject().getConfigurations(), configurationName));
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isShowSinglePathToDependency() {
        return this.showSinglePathToDependency;
    }

    @Option(option="single-path", description="Show at most one path to each dependency")
    public void setShowSinglePathToDependency(boolean showSinglePathToDependency) {
        this.showSinglePathToDependency = showSinglePathToDependency;
    }

    @Option(option="all-variants", description="Show all variants of each dependency")
    @Incubating
    @Internal
    public Property<Boolean> getShowingAllVariants() {
        return this.showingAllVariants;
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionParser getVersionParser() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Inject
    protected AttributesFactory getImmutableAttributesFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    @Incubating
    protected AttributesFactory getAttributesFactory() {
        return this.getImmutableAttributesFactory();
    }

    @TaskAction
    public void report() {
        this.assertValidTaskConfiguration();
        ResolvedComponentResult rootComponent = (ResolvedComponentResult)this.getRootComponentProperty().get();
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        Set<DependencyResult> selectedDependencies = this.selectDependencies(rootComponent);
        if (selectedDependencies.isEmpty()) {
            output.println((Object)("No dependencies matching given input were found in " + this.configurationDescription));
            return;
        }
        this.renderSelectedDependencies(output, selectedDependencies);
        this.renderBuildScanHint(output);
    }

    private void renderSelectedDependencies(StyledTextOutput output, Set<DependencyResult> selectedDependencies) {
        GraphRenderer renderer = new GraphRenderer(output);
        DependencyInsightReporter reporter = new DependencyInsightReporter(this.getVersionSelectorScheme(), this.getVersionComparator(), this.getVersionParser());
        Collection<RenderableDependency> itemsToRender = reporter.convertToRenderableItems(selectedDependencies, this.isShowSinglePathToDependency());
        RootDependencyRenderer rootRenderer = new RootDependencyRenderer(this, (AttributeContainer)this.zConfigurationAttributes.get(), this.getAttributesFactory());
        ReplaceProjectWithConfigurationNameRenderer dependenciesRenderer = new ReplaceProjectWithConfigurationNameRenderer(this.configurationName);
        DependencyGraphsRenderer dependencyGraphRenderer = new DependencyGraphsRenderer(output, renderer, rootRenderer, dependenciesRenderer);
        dependencyGraphRenderer.setShowSinglePath(this.showSinglePathToDependency);
        dependencyGraphRenderer.render(itemsToRender);
        dependencyGraphRenderer.complete();
    }

    private void renderBuildScanHint(StyledTextOutput output) {
        output.println();
        output.text((Object)"A web-based, searchable dependency report is available by adding the ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        output.println((Object)" option.");
    }

    private void assertValidTaskConfiguration() {
        if (this.configurationName == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the input configuration was not specified. \nIt can be specified from the command line, e.g: '" + this.getPath() + " --configuration someConf --dependency someDep'");
        }
        if (this.dependencySpec == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the dependency to show was not specified.\nIt can be specified from the command line, e.g: '" + this.getPath() + " --dependency someDep'");
        }
    }

    private Set<DependencyResult> selectDependencies(ResolvedComponentResult rootComponent) {
        LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        this.eachDependency(rootComponent, (Action<? super DependencyResult>)((Action)dependencyResult -> {
            if (Objects.requireNonNull(this.dependencySpec).isSatisfiedBy(dependencyResult)) {
                selectedDependencies.add((DependencyResult)dependencyResult);
            }
        }), new HashSet<ResolvedComponentResult>());
        return selectedDependencies;
    }

    private void eachDependency(ResolvedComponentResult node, Action<? super DependencyResult> dependencyAction, Set<ResolvedComponentResult> visited) {
        if (!visited.add(node)) {
            return;
        }
        for (DependencyResult d : node.getDependencies()) {
            dependencyAction.execute((Object)d);
            if (!(d instanceof ResolvedDependencyResult)) continue;
            this.eachDependency(((ResolvedDependencyResult)d).getSelected(), dependencyAction, visited);
        }
    }

    private AttributeMatchDetails match(Attribute<?> actualAttribute, @Nullable Object actualValue, AttributeContainer requestedAttributes) {
        for (Attribute requested : requestedAttributes.keySet()) {
            Object requestedValue = requestedAttributes.getAttribute(requested);
            if (!requested.getName().equals(actualAttribute.getName())) continue;
            if (requested.equals(actualAttribute)) {
                if (Objects.equals(actualValue, requestedValue)) {
                    return new AttributeMatchDetails(MatchType.EQUAL, requested, requestedValue);
                }
            } else {
                String requestedString;
                String actualString = actualValue != null ? actualValue.toString() : null;
                String string = requestedString = requestedValue != null ? requestedValue.toString() : null;
                if (Objects.equals(actualString, requestedString)) {
                    return new AttributeMatchDetails(MatchType.EQUAL, requested, requestedValue);
                }
            }
            return new AttributeMatchDetails(MatchType.INCOMPATIBLE, requested, requestedValue);
        }
        return new AttributeMatchDetails(MatchType.NOT_REQUESTED, null, null);
    }

    private static final class RootDependencyRenderer
    implements NodeRenderer {
        private final DependencyInsightReportTask task;
        private final AttributeContainer configurationAttributes;
        private final AttributesFactory attributesFactory;

        public RootDependencyRenderer(DependencyInsightReportTask task, AttributeContainer configurationAttributes, AttributesFactory attributesFactory) {
            this.task = task;
            this.configurationAttributes = configurationAttributes;
            this.attributesFactory = attributesFactory;
        }

        @Override
        public void renderNode(StyledTextOutput out, RenderableDependency dependency, boolean alreadyRendered) {
            out.withStyle(StyledTextOutput.Style.Identifier).text((Object)dependency.getName());
            if (StringUtils.isNotEmpty((String)dependency.getDescription())) {
                out.withStyle(StyledTextOutput.Style.Description).text((Object)(" (" + dependency.getDescription() + ")"));
            }
            switch (dependency.getResolutionState()) {
                case FAILED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text((Object)" FAILED");
                    break;
                }
                case RESOLVED: 
                case RESOLVED_CONSTRAINT: {
                    break;
                }
                case UNRESOLVED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text((Object)" (n)");
                }
            }
            this.printVariantDetails(out, dependency);
            this.printExtraDetails(out, dependency);
        }

        private void printExtraDetails(StyledTextOutput out, RenderableDependency dependency) {
            List<Section> extraDetails = dependency.getExtraDetails();
            if (!extraDetails.isEmpty()) {
                this.printSections(out, extraDetails, 1);
            }
        }

        private void printSections(StyledTextOutput out, List<Section> extraDetails, int depth) {
            for (Section extraDetail : extraDetails) {
                this.printSection(out, extraDetail, depth);
                this.printSections(out, extraDetail.getChildren(), depth + 1);
            }
        }

        private void printSection(StyledTextOutput out, Section extraDetail, int depth) {
            out.println();
            String indent = StringUtils.leftPad((String)"", (int)(3 * depth)) + (depth > 1 ? "- " : "");
            String appendix = extraDetail.getChildren().isEmpty() ? "" : ":";
            String description = StringUtils.trim((String)extraDetail.getDescription());
            String padding = "\n" + StringUtils.leftPad((String)"", (int)indent.length());
            description = description.replaceAll("(?m)(\r?\n)", padding);
            out.withStyle(StyledTextOutput.Style.Description).text((Object)(indent + description + appendix));
        }

        private void printVariantDetails(StyledTextOutput out, RenderableDependency dependency) {
            if (dependency.getResolvedVariants().isEmpty() && dependency.getAllVariants().isEmpty()) {
                return;
            }
            Set selectedVariantNames = dependency.getResolvedVariants().stream().map(ResolvedVariantResult::getDisplayName).collect(Collectors.toSet());
            if (((Boolean)this.task.getShowingAllVariants().get()).booleanValue()) {
                out.style(StyledTextOutput.Style.Header);
                out.println();
                out.text((Object)"-------------------").println();
                out.text((Object)"Selected Variant(s)").println();
                out.text((Object)"-------------------");
                out.style(StyledTextOutput.Style.Normal);
                out.println();
            }
            for (ResolvedVariantResult variant : dependency.getResolvedVariants()) {
                this.printVariant(out, dependency, variant, true);
            }
            if (((Boolean)this.task.getShowingAllVariants().get()).booleanValue()) {
                out.style(StyledTextOutput.Style.Header);
                out.println();
                out.println();
                out.text((Object)"---------------------").println();
                out.text((Object)"Unselected Variant(s)").println();
                out.text((Object)"---------------------");
                out.println();
                out.style(StyledTextOutput.Style.Normal);
                List sortedVariants = dependency.getAllVariants().stream().sorted(Comparator.comparing(ResolvedVariantResult::getDisplayName)).collect(Collectors.toList());
                for (ResolvedVariantResult variant : sortedVariants) {
                    if (selectedVariantNames.contains(variant.getDisplayName())) continue;
                    this.printVariant(out, dependency, variant, true);
                    out.println();
                }
            }
        }

        private void printVariant(StyledTextOutput out, RenderableDependency dependency, ResolvedVariantResult variant, boolean selected) {
            AttributeContainer attributes = variant.getAttributes();
            AttributeContainer requested = this.getRequestedAttributes(dependency);
            AttributeBuckets buckets = this.bucketAttributes(attributes, requested);
            out.println().style(StyledTextOutput.Style.Normal).text((Object)"  Variant ");
            out.text((Object)variant.getDisplayName()).style(StyledTextOutput.Style.Normal).text((Object)":").println();
            if (!attributes.isEmpty() || !requested.isEmpty()) {
                this.writeAttributeBlock(out, attributes, requested, buckets, selected);
            }
        }

        private AttributeContainer getRequestedAttributes(RenderableDependency dependency) {
            if (dependency instanceof HasAttributes) {
                AttributeContainer dependencyAttributes = ((HasAttributes)dependency).getAttributes();
                return this.concat(this.configurationAttributes, dependencyAttributes);
            }
            return this.configurationAttributes;
        }

        private AttributeContainer concat(AttributeContainer configAttributes, AttributeContainer dependencyAttributes) {
            return this.attributesFactory.concat(((AttributeContainerInternal)configAttributes).asImmutable(), ((AttributeContainerInternal)dependencyAttributes).asImmutable());
        }

        private void writeAttributeBlock(StyledTextOutput out, AttributeContainer attributes, AttributeContainer requested, AttributeBuckets buckets, boolean selected) {
            new StyledTable.Renderer().render(this.createAttributeTable(attributes, requested, buckets, selected), out);
        }

        private StyledTable createAttributeTable(AttributeContainer attributes, AttributeContainer requested, AttributeBuckets buckets, boolean selected) {
            ImmutableList.Builder header = ImmutableList.builder().add((Object[])new String[]{"Attribute Name", "Provided", "Requested"});
            if (!selected) {
                header.add((Object)"Compatibility");
            }
            ImmutableList<StyledTable.Row> rows = this.buildRows(attributes, requested, buckets, selected);
            return new StyledTable(Strings.repeat((String)" ", (int)4), (List)header.build(), rows);
        }

        private ImmutableList<StyledTable.Row> buildRows(AttributeContainer attributes, AttributeContainer requested, AttributeBuckets buckets, boolean selected) {
            ImmutableList.Builder rows = ImmutableList.builder();
            for (Attribute<?> attribute : buckets.providedAttributes) {
                rows.add((Object)this.createProvidedRow(attributes, selected, attribute));
            }
            for (Map.Entry entry : buckets.bothAttributes.entrySet()) {
                rows.add((Object)this.createMatchBasedRow(attributes, selected, entry));
            }
            for (Attribute attribute : buckets.requestedAttributes) {
                rows.add((Object)this.createRequestedRow(requested, selected, attribute));
            }
            return rows.build();
        }

        private AttributeBuckets bucketAttributes(AttributeContainer attributes, AttributeContainer requested) {
            AttributeBuckets buckets = new AttributeBuckets();
            for (Attribute attribute : attributes.keySet()) {
                AttributeMatchDetails details = this.task.match(attribute, attributes.getAttribute(attribute), requested);
                if (details.matchType() != MatchType.NOT_REQUESTED) {
                    buckets.bothAttributes.put(attribute, details);
                    continue;
                }
                buckets.providedAttributes.add(attribute);
            }
            for (Attribute attribute : requested.keySet()) {
                if (!buckets.bothAttributes.values().stream().map(AttributeMatchDetails::requested).noneMatch(Predicate.isEqual(attribute))) continue;
                buckets.requestedAttributes.add(attribute);
            }
            return buckets;
        }

        private StyledTable.Row createProvidedRow(AttributeContainer attributes, boolean selected, Attribute<?> attribute) {
            Object providedValue = attributes.getAttribute(attribute);
            ImmutableList.Builder text = ImmutableList.builder().add((Object[])new String[]{attribute.getName(), providedValue == null ? "" : providedValue.toString(), ""});
            if (!selected) {
                text.add((Object)"Compatible");
            }
            return new StyledTable.Row((List)text.build(), StyledTextOutput.Style.Info);
        }

        private StyledTable.Row createMatchBasedRow(AttributeContainer attributes, boolean selected, Map.Entry<Attribute<?>, AttributeMatchDetails> entry) {
            Object providedValue = attributes.getAttribute(entry.getKey());
            AttributeMatchDetails match = entry.getValue();
            ImmutableList.Builder text = ImmutableList.builder().add((Object[])new String[]{entry.getKey().getName(), providedValue == null ? "" : providedValue.toString(), String.valueOf(entry.getValue().requestedValue())});
            if (!selected) {
                text.add((Object)(match.matchType() == MatchType.INCOMPATIBLE ? "Incompatible" : "Compatible"));
            }
            return new StyledTable.Row((List)text.build(), StyledTextOutput.Style.Normal);
        }

        private StyledTable.Row createRequestedRow(AttributeContainer requested, boolean selected, Attribute<?> attribute) {
            Object requestedValue = requested.getAttribute(attribute);
            ImmutableList.Builder text = ImmutableList.builder().add((Object[])new String[]{attribute.getName(), "", String.valueOf(requestedValue)});
            if (!selected) {
                text.add((Object)"Compatible");
            }
            return new StyledTable.Row((List)text.build(), StyledTextOutput.Style.Info);
        }

        private static final class AttributeBuckets {
            private static final Comparator<Attribute<?>> sortedByAttributeName = Comparator.comparing(Attribute::getName);
            Set<Attribute<?>> providedAttributes = new TreeSet(sortedByAttributeName);
            Map<Attribute<?>, AttributeMatchDetails> bothAttributes = new TreeMap(sortedByAttributeName);
            Set<Attribute<?>> requestedAttributes = new TreeSet(sortedByAttributeName);

            private AttributeBuckets() {
            }
        }
    }

    private static class ReplaceProjectWithConfigurationNameRenderer
    implements NodeRenderer {
        private final String configurationName;

        public ReplaceProjectWithConfigurationNameRenderer(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public void renderNode(StyledTextOutput target, RenderableDependency node, boolean alreadyRendered) {
            boolean leaf = node.getChildren().isEmpty();
            target.text((Object)(leaf ? this.configurationName : node.getName()));
            if (node.getDescription() != null) {
                target.text((Object)" ").withStyle(StyledTextOutput.Style.Description).text((Object)node.getDescription());
            }
            if (alreadyRendered && !leaf) {
                target.withStyle(StyledTextOutput.Style.Info).text((Object)" (*)");
            }
        }
    }
}

