/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

@NonNullApi
public class TransformingConverter<N, T, R>
implements NotationConverter<N, R> {
    private final NotationConverter<N, T> converter;
    private final Transformer<? extends R, T> transformer;

    public TransformingConverter(NotationConverter<N, T> converter, Transformer<? extends R, T> transformer) {
        this.converter = converter;
        this.transformer = transformer;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super R> result) throws TypeConversionException {
        ResultImpl intermediateResult = new ResultImpl();
        this.converter.convert(notation, intermediateResult);
        if (intermediateResult.hasResult()) {
            result.converted(this.transformer.transform(intermediateResult.result));
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.converter.describe(visitor);
    }

    @NonNullApi
    private static class ResultImpl<T>
    implements NotationConvertResult<T> {
        private boolean hasResult;
        private T result;

        private ResultImpl() {
        }

        @Override
        public boolean hasResult() {
            return this.hasResult;
        }

        @Override
        public void converted(T result) {
            this.hasResult = true;
            this.result = result;
        }
    }
}

