/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.reporting.model.ModelReport;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.diagnostics.ProjectReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.configuration.Help;

public abstract class HelpTasksPlugin
implements Plugin<Project> {
    public static final String HELP_GROUP = "help";
    public static final String PROPERTIES_TASK = "properties";
    public static final String DEPENDENCIES_TASK = "dependencies";
    public static final String DEPENDENCY_INSIGHT_TASK = "dependencyInsight";
    public static final String COMPONENTS_TASK = "components";
    public static final String OUTGOING_VARIANTS_TASK = "outgoingVariants";
    @Incubating
    public static final String RESOLVABLE_CONFIGURATIONS_TASK = "resolvableConfigurations";
    @Incubating
    public static final String ARTIFACT_TRANSFORMS_TASK = "artifactTransforms";
    public static final String MODEL_TASK = "model";
    public static final String DEPENDENT_COMPONENTS_TASK = "dependentComponents";

    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        String projectName = project.toString();
        tasks.register(HELP_GROUP, Help.class, (Action)new HelpAction());
        tasks.register("projects", ProjectReportTask.class, (Action)new ProjectReportTaskAction(projectName));
        tasks.register("tasks", TaskReportTask.class, (Action)new TaskReportTaskAction(projectName, ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project).isEmpty()));
        tasks.register(PROPERTIES_TASK, PropertyReportTask.class, (Action)new PropertyReportTaskAction(projectName));
        this.registerDeprecatedSoftwareModelTasks(tasks, projectName);
        tasks.withType(TaskReportTask.class).configureEach(task -> task.getShowTypes().convention((Object)false));
    }

    private void registerDeprecatedSoftwareModelTasks(TaskContainer tasks, String projectName) {
        tasks.register(MODEL_TASK, ModelReport.class, (Action)new ModelReportAction(projectName));
    }

    private static class HelpAction
    implements Action<Help> {
        private HelpAction() {
        }

        public void execute(Help task) {
            task.setDescription("Displays a help message.");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class ProjectReportTaskAction
    implements Action<ProjectReportTask> {
        private final String project;

        public ProjectReportTaskAction(String projectName) {
            this.project = projectName;
        }

        public void execute(ProjectReportTask task) {
            task.setDescription("Displays the sub-projects of " + this.project + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class TaskReportTaskAction
    implements Action<TaskReportTask> {
        private final String projectName;
        private final boolean noChildren;

        public TaskReportTaskAction(String projectName, boolean noChildren) {
            this.projectName = projectName;
            this.noChildren = noChildren;
        }

        public void execute(TaskReportTask task) {
            String description = this.noChildren ? "Displays the tasks runnable from " + this.projectName + "." : "Displays the tasks runnable from " + this.projectName + " (some of the displayed tasks may belong to subprojects).";
            task.setDescription(description);
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class PropertyReportTaskAction
    implements Action<PropertyReportTask> {
        private final String projectName;

        public PropertyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(PropertyReportTask task) {
            task.setDescription("Displays the properties of " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class ModelReportAction
    implements Action<ModelReport> {
        private final String projectName;

        public ModelReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(ModelReport task) {
            task.setDescription("Displays the configuration model of " + this.projectName + ". [deprecated]");
            task.setImpliesSubProjects(true);
        }
    }
}

