/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.plugins.ExtraPropertiesExtensionInternal;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class DefaultExtraPropertiesExtension
extends GroovyObjectSupport
implements ExtraPropertiesExtensionInternal {
    private ImmutableMap<String, Object> gradleProperties = ImmutableMap.of();
    @Nullable
    private Map<String, Object> storage = null;

    public boolean has(String name) {
        if (this.storage != null && this.storage.containsKey(name)) {
            return true;
        }
        return this.gradleProperties.containsKey((Object)name);
    }

    @Nullable
    public Object get(String name) {
        Object value = this.find(name);
        if (value == null && !this.has(name)) {
            throw new ExtraPropertiesExtension.UnknownPropertyException((ExtraPropertiesExtension)this, name);
        }
        return value;
    }

    @Nullable
    private Object find(String name) {
        Object value;
        if (this.storage != null && ((value = this.storage.get(name)) != null || this.storage.containsKey(name))) {
            return value;
        }
        return this.gradleProperties.get((Object)name);
    }

    public void set(String name, @Nullable Object value) {
        if (this.storage == null) {
            this.storage = new HashMap<String, Object>();
        }
        this.storage.put(name, value);
    }

    @Nullable
    public Object getProperty(String name) {
        Object value;
        if (name.equals("properties")) {
            return this.getProperties();
        }
        if (this.storage != null && ((value = this.storage.get(name)) != null || this.storage.containsKey(name))) {
            return value;
        }
        if (this.gradleProperties.containsKey((Object)name)) {
            return this.gradleProperties.get((Object)name);
        }
        throw new MissingPropertyException(ExtraPropertiesExtension.UnknownPropertyException.createMessage((String)name), name, null);
    }

    public void setProperty(String name, @Nullable Object newValue) {
        if (name.equals("properties")) {
            throw new ReadOnlyPropertyException("name", ExtraPropertiesExtension.class);
        }
        this.set(name, newValue);
    }

    public Map<String, Object> getProperties() {
        if (this.storage == null) {
            return new HashMap<String, Object>((Map<String, Object>)this.gradleProperties);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(this.storage.size() + this.gradleProperties.size());
        properties.putAll(this.storage);
        for (Map.Entry entry : this.gradleProperties.entrySet()) {
            if (this.storage.containsKey(entry.getKey())) continue;
            properties.put((String)entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public Object methodMissing(String name, Object args) {
        Object item = this.find(name);
        if (item instanceof Closure) {
            Closure closure = (Closure)item;
            return closure.call((Object[])args);
        }
        throw new MissingMethodException(name, this.getClass(), (Object[])args);
    }

    @Override
    public void setGradleProperties(Map<String, Object> properties) {
        this.gradleProperties = ImmutableMap.copyOf(properties);
    }
}

