/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.OpFiringRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.RemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRemoteBuildCacheServiceHandle
implements RemoteBuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpFiringRemoteBuildCacheServiceHandle.class);
    protected final BuildCacheService service;
    protected final BuildCacheServiceRole role;
    private final boolean pushEnabled;
    private final boolean logStackTraces;
    private final boolean disableOnError;
    private boolean disabled;

    public BaseRemoteBuildCacheServiceHandle(BuildCacheService service, boolean push, BuildCacheServiceRole role, boolean logStackTraces, boolean disableOnError) {
        this.role = role;
        this.service = service;
        this.pushEnabled = push;
        this.logStackTraces = logStackTraces;
        this.disableOnError = disableOnError;
    }

    @Override
    @Nullable
    public BuildCacheService getService() {
        return this.service;
    }

    @Override
    public boolean canLoad() {
        return !this.disabled;
    }

    @Override
    public final Optional<BuildCacheLoadResult> maybeLoad(BuildCacheKey key, File loadTargetFile, Function<File, BuildCacheLoadResult> unpackFunction) {
        if (!this.canLoad()) {
            return Optional.empty();
        }
        String description = Operation.LOAD.describe(key, this.role);
        LOGGER.debug(description);
        LoadTarget loadTarget = new LoadTarget(loadTargetFile);
        try {
            this.loadInner(description, key, loadTarget);
        }
        catch (Exception e) {
            this.failure(Operation.LOAD, key, e);
        }
        return BaseRemoteBuildCacheServiceHandle.maybeUnpack(loadTarget, unpackFunction);
    }

    protected void loadInner(String description, BuildCacheKey key, LoadTarget loadTarget) {
        this.service.load(key, (BuildCacheEntryReader)loadTarget);
    }

    protected void loadInner(BuildCacheKey key, BuildCacheEntryReader entryReader) {
        this.service.load(key, entryReader);
    }

    private static Optional<BuildCacheLoadResult> maybeUnpack(LoadTarget loadTarget, Function<File, BuildCacheLoadResult> unpackFunction) {
        if (loadTarget.isLoaded()) {
            return Optional.ofNullable(unpackFunction.apply(loadTarget.getFile()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled && !this.disabled;
    }

    @Override
    public final boolean maybeStore(BuildCacheKey key, File file) {
        if (!this.canStore()) {
            return false;
        }
        String description = Operation.STORE.describe(key, this.role);
        LOGGER.debug(description);
        try {
            this.storeInner(description, key, new StoreTarget(file));
            return true;
        }
        catch (Exception e) {
            this.failure(Operation.STORE, key, e);
            return false;
        }
    }

    protected void storeInner(String description, BuildCacheKey key, StoreTarget storeTarget) {
        this.service.store(key, (BuildCacheEntryWriter)storeTarget);
    }

    private void failure(Operation operation, BuildCacheKey key, Throwable failure) {
        if (this.disableOnError) {
            this.disabled = true;
            this.onCacheDisabledDueToFailure(key, operation, failure);
        }
        String description = operation.describeFailure(key, this.role);
        if (LOGGER.isWarnEnabled()) {
            if (this.logStackTraces) {
                LOGGER.warn(description, failure);
            } else {
                LOGGER.warn(description + ": " + failure.getMessage());
            }
        }
    }

    protected void onCacheDisabledDueToFailure(BuildCacheKey key, Operation operation, Throwable failure) {
    }

    @Override
    public void close() {
        LOGGER.debug("Closing {} build cache", (Object)this.role.getDisplayName());
        if (this.disabled) {
            LOGGER.warn("The {} build cache was disabled during the build due to errors.", (Object)this.role.getDisplayName());
        }
        try {
            this.service.close();
        }
        catch (Exception e) {
            if (this.logStackTraces) {
                LOGGER.warn("Error closing {} build cache: ", (Object)this.role.getDisplayName(), (Object)e);
            }
            LOGGER.warn("Error closing {} build cache: {}", (Object)this.role.getDisplayName(), (Object)e.getMessage());
        }
    }

    protected static enum Operation {
        LOAD("Load", "from"),
        STORE("Store", "in");

        private final String verb;
        private final String capitalizedVerb;
        private final String preposition;

        private Operation(String capitalizedVerb, String preposition) {
            this.capitalizedVerb = capitalizedVerb;
            this.verb = capitalizedVerb.toLowerCase(Locale.ROOT);
            this.preposition = preposition;
        }

        public String describe(BuildCacheKey key, BuildCacheServiceRole role) {
            return this.capitalizedVerb + " entry " + key.getHashCode() + " " + this.preposition + " " + role.getDisplayName() + " build cache";
        }

        public String describeFailure(BuildCacheKey key, BuildCacheServiceRole role) {
            return "Could not " + this.verb + " entry " + key.getHashCode() + " " + this.preposition + " " + role.getDisplayName() + " build cache";
        }
    }
}

