/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.AssertCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.TypeOfKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.TypeOfChecker;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a2\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"createSpecialEnumMethodBody", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "name", "", "typeParameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "typeSystem", "Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;", "generateInlineIntrinsic", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeParameters", "", "getSpecialEnumFunDescriptor", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "isValueOf", "", "isSpecialEnumMethod", "backend"})
public final class InlineIntrinsicsKt {
    @Nullable
    public static final MethodNode generateInlineIntrinsic(@NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @Nullable List<? extends TypeParameterMarker> typeParameters2, @NotNull TypeSystemCommonBackendContext typeSystem) {
        MethodNode methodNode;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        LanguageVersionSettings languageVersionSettings = state.getLanguageVersionSettings();
        if (InlineIntrinsicsKt.isSpecialEnumMethod(descriptor2)) {
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
            List<? extends TypeParameterMarker> list2 = typeParameters2;
            Intrinsics.checkNotNull(list2);
            methodNode = InlineIntrinsicsKt.createSpecialEnumMethodBody(string2, (TypeParameterMarker)CollectionsKt.single(list2), typeSystem);
        } else if (TypeOfChecker.INSTANCE.isTypeOf(descriptor2)) {
            List<? extends TypeParameterMarker> list3 = typeParameters2;
            Intrinsics.checkNotNull(list3);
            methodNode = TypeOfKt.createTypeOfMethodBody(typeSystem, (TypeParameterMarker)CollectionsKt.single(list3));
        } else {
            methodNode = CommonCoroutineCodegenUtilKt.isBuiltInIntercepted(descriptor2, languageVersionSettings) ? CoroutineCodegenUtilKt.createMethodNodeForIntercepted(languageVersionSettings) : (CoroutineCallCheckerKt.isBuiltInCoroutineContext(descriptor2, languageVersionSettings) ? CoroutineCodegenUtilKt.createMethodNodeForCoroutineContext(descriptor2, languageVersionSettings) : (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(descriptor2, languageVersionSettings) ? CoroutineCodegenUtilKt.createMethodNodeForSuspendCoroutineUninterceptedOrReturn(languageVersionSettings) : (AssertCodegenUtilKt.isBuiltinAlwaysEnabledAssert(descriptor2) ? AssertCodegenUtilKt.createMethodNodeForAlwaysEnabledAssert(descriptor2) : null)));
        }
        return methodNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSpecialEnumMethod(FunctionDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        if (packageFragmentDescriptor == null) return false;
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        if (Intrinsics.areEqual((Object)containingDeclaration.getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) ^ true) {
            return false;
        }
        if (descriptor2.getTypeParameters().size() != 1) {
            return false;
        }
        String string2 = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
        String name = string2;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        List<ValueParameterDescriptor> parameters2 = list2;
        if (Intrinsics.areEqual((Object)name, (Object)"enumValues")) {
            if (parameters2.size() == 0) return true;
        }
        if (!Intrinsics.areEqual((Object)name, (Object)"enumValueOf")) return false;
        if (parameters2.size() != 1) return false;
        ValueParameterDescriptor valueParameterDescriptor = parameters2.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameters[0]");
        if (!KotlinBuiltIns.isString(valueParameterDescriptor.getType())) return false;
        return true;
    }

    private static final MethodNode createSpecialEnumMethodBody(String name, TypeParameterMarker typeParameter, TypeSystemCommonBackendContext typeSystem) {
        boolean isValueOf = Intrinsics.areEqual((Object)"enumValueOf", (Object)name);
        Type type2 = AsmTypes.ENUM_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"ENUM_TYPE");
        String desc = InlineIntrinsicsKt.getSpecialEnumFunDescriptor(type2, isValueOf);
        MethodNode node = new MethodNode(458752, 8, "fake", desc, null, null);
        ReifiedTypeInliner.Companion.putReifiedOperationMarkerIfNeeded(typeParameter, false, ReifiedTypeInliner.OperationKind.ENUM_REIFIED, new InstructionAdapter(node), typeSystem);
        if (isValueOf) {
            node.visitInsn(1);
            node.visitVarInsn(25, 0);
            Type type3 = AsmTypes.ENUM_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"ENUM_TYPE");
            node.visitMethodInsn(184, type3.getInternalName(), "valueOf", Type.getMethodDescriptor(AsmTypes.ENUM_TYPE, AsmTypes.JAVA_CLASS_TYPE, AsmTypes.JAVA_STRING_TYPE), false);
        } else {
            node.visitInsn(3);
            Type type4 = AsmTypes.ENUM_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"ENUM_TYPE");
            node.visitTypeInsn(189, type4.getInternalName());
        }
        node.visitInsn(176);
        node.visitMaxs(isValueOf ? 3 : 2, isValueOf ? 1 : 0);
        return node;
    }

    @NotNull
    public static final String getSpecialEnumFunDescriptor(@NotNull Type type2, boolean isValueOf) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String string2 = isValueOf ? Type.getMethodDescriptor(type2, AsmTypes.JAVA_STRING_TYPE) : Type.getMethodDescriptor(AsmUtil.getArrayType(type2), new Type[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (isValueOf) Type.getM\u2026mUtil.getArrayType(type))");
        return string2;
    }
}

