/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001f\u0010\u0006\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0007\u001aI\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\u00020\n0\t\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\u0004\u001a\u0002H\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"findAllReachableDeclarations", "", "Function", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "function", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Ljava/util/Set;", "findConcreteSuperDeclaration", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "generateBridges", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "signature", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "backend-common"})
public final class BridgesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle, Signature> Set<Bridge<Signature, Function>> generateBridges(@NotNull Function function2, @NotNull Function1<? super Function, ? extends Signature> signature2) {
        void $this$mapTo$iv$iv;
        Object value$iv$iv;
        void $this$groupByTo$iv;
        boolean $i$f$none;
        boolean fake;
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        if (function2.isAbstract()) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        boolean bl = fake = !function2.isDeclaration();
        if (fake) {
            boolean bl2;
            block15: {
                Iterable<FunctionHandle> $this$none$iv = function2.getOverridden();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object e : $this$none$iv) {
                        FunctionHandle it = (FunctionHandle)e;
                        boolean bl3 = false;
                        if (!it.isAbstract()) continue;
                        bl2 = false;
                        break block15;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                boolean $this$none$iv = false;
                return SetsKt.emptySet();
            }
        }
        Function Function4 = BridgesKt.findConcreteSuperDeclaration(function2);
        if (Function4 == null) {
            $i$f$none = false;
            return SetsKt.emptySet();
        }
        Function implementation2 = Function4;
        Iterable iterable = BridgesKt.findAllReachableDeclarations(function2);
        Map map2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            Object key$iv = signature2.invoke(element$iv);
            Map $this$getOrPut$iv$iv = map2;
            boolean $i$f$getOrPut = false;
            value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        LinkedHashMap bridgesToGenerate2 = (LinkedHashMap)map2;
        if (fake) {
            Iterable<FunctionHandle> iterable2 = function2.getOverridden();
            if (iterable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Iterable<Function>");
            }
            for (FunctionHandle overridden : iterable2) {
                if (overridden.isAbstract()) continue;
                for (FunctionHandle reachable : BridgesKt.findAllReachableDeclarations(overridden)) {
                    bridgesToGenerate2.remove(signature2.invoke((Object)reachable));
                }
            }
        }
        Object method = signature2.invoke(implementation2);
        bridgesToGenerate2.remove(method);
        Set set = bridgesToGenerate2.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"bridgesToGenerate.entries");
        Iterable iterable3 = set;
        boolean $i$f$map = false;
        Iterator<FunctionHandle> bl3 = iterable3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void overriddenSignature;
            List overriddenFunctions2;
            void $dstr$overriddenSignature$overriddenFunctions;
            value$iv$iv = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            void var15_30 = $dstr$overriddenSignature$overriddenFunctions;
            boolean bl4 = false;
            Object k = var15_30.getKey();
            var15_30 = $dstr$overriddenSignature$overriddenFunctions;
            bl4 = false;
            List list2 = overriddenFunctions2 = (List)var15_30.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"overriddenFunctions");
            Bridge bridge = new Bridge(overriddenSignature, method, CollectionsKt.toSet((Iterable)list2));
            collection.add(bridge);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final <Function extends FunctionHandle> Set<Function> findAllReachableDeclarations(@NotNull Function function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        DFS.NodeHandlerWithListResult collector2 = new DFS.NodeHandlerWithListResult<Function, Function>(){

            public void afterChildren(@NotNull Function current2) {
                Intrinsics.checkNotNullParameter(current2, (String)"current");
                if (current2.isDeclaration()) {
                    ((LinkedList)this.result).add(current2);
                }
            }
        };
        DFS.dfs(CollectionsKt.listOf(function2), findAllReachableDeclarations.1.INSTANCE, collector2);
        return new LinkedHashSet((Collection)collector2.result());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <Function extends FunctionHandle> Function findConcreteSuperDeclaration(@NotNull Function function2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        boolean bl = !function2.isAbstract();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Only concrete functions have implementations: " + function2;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (function2.isDeclaration()) {
            return function2;
        }
        Set<Function> result2 = BridgesKt.findAllReachableDeclarations(function2);
        HashSet toRemove = new HashSet();
        for (Function declaration2 : result2) {
            Set<Function> reachable = BridgesKt.findAllReachableDeclarations(declaration2);
            reachable.remove(declaration2);
            toRemove.addAll(reachable);
        }
        result2.removeAll(toRemove);
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionHandle it = (FunctionHandle)element$iv$iv;
            boolean bl5 = false;
            if (!(!it.isAbstract() && it.getMayBeUsedAsSuperImplementation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List concreteRelevantDeclarations = (List)destination$iv$iv;
        if (concreteRelevantDeclarations.size() != 1) {
            if (!function2.getMightBeIncorrectCode()) {
                String string3 = "Concrete fake override " + function2 + " should have exactly one concrete super-declaration: " + concreteRelevantDeclarations;
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return null;
        }
        return (Function)((FunctionHandle)concreteRelevantDeclarations.get(0));
    }
}

