/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;

public abstract class AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    protected BuildActionRunner.Result runClientAction(ClientAction action, BuildController buildController) {
        GradleInternal gradle = buildController.getGradle();
        gradle.getStartParameter().setConfigureOnDemand(false);
        ActionRunningListener listener = new ActionRunningListener(gradle, action);
        RuntimeException buildFailure = null;
        RuntimeException clientFailure = null;
        try {
            gradle.addBuildListener((BuildListener)listener);
            if (action.isRunTasks()) {
                buildController.run();
            } else {
                buildController.configure();
            }
        }
        catch (RuntimeException e) {
            buildFailure = e;
            clientFailure = e;
        }
        if (listener.actionFailure != null) {
            clientFailure = new InternalBuildActionFailureException((Throwable)listener.actionFailure);
        }
        if (buildFailure != null) {
            return BuildActionRunner.Result.failed((Throwable)buildFailure, (RuntimeException)clientFailure);
        }
        return BuildActionRunner.Result.of((Object)action.getResult());
    }

    private void forceFullConfiguration(GradleInternal gradle, Set<GradleInternal> alreadyConfigured) {
        ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchyFully(gradle.getRootProject());
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || alreadyConfigured.contains(build = ((IncludedBuildState)includedBuild).getConfiguredBuild())) continue;
            alreadyConfigured.add(build);
            this.forceFullConfiguration(build, alreadyConfigured);
        }
    }

    private class ActionRunningListener
    extends InternalBuildAdapter {
        private final GradleInternal gradle;
        private final ClientAction clientAction;
        RuntimeException actionFailure;

        ActionRunningListener(GradleInternal gradle, ClientAction clientAction) {
            this.gradle = gradle;
            this.clientAction = clientAction;
        }

        public void projectsEvaluated(Gradle gradle) {
            AbstractClientProvidedBuildActionRunner.this.forceFullConfiguration(this.gradle, new HashSet());
            this.runAction(this.clientAction.getProjectsEvaluatedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
        }

        public void buildFinished(BuildResult result) {
            if (result.getFailure() != null) {
                return;
            }
            this.runAction(this.clientAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
        }

        private void runAction(@Nullable Object action, PhasedActionResult.Phase phase) {
            if (action == null || this.actionFailure != null) {
                return;
            }
            DefaultBuildController internalBuildController = new DefaultBuildController(this.gradle, (BuildCancellationToken)this.gradle.getServices().get(BuildCancellationToken.class), (BuildOperationExecutor)this.gradle.getServices().get(BuildOperationExecutor.class), (ProjectLeaseRegistry)this.gradle.getServices().get(ProjectLeaseRegistry.class));
            try {
                Object result = action instanceof InternalBuildActionVersion2 ? ((InternalBuildActionVersion2)action).execute((InternalBuildControllerVersion2)internalBuildController) : ((InternalBuildAction)action).execute((InternalBuildController)internalBuildController);
                this.clientAction.collectActionResult(result, phase);
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
        }
    }

    protected static interface ClientAction {
        @Nullable
        public Object getProjectsEvaluatedAction();

        @Nullable
        public Object getBuildFinishedAction();

        public void collectActionResult(Object var1, PhasedActionResult.Phase var2);

        public boolean isRunTasks();

        public Object getResult();
    }
}

