/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.language.twirl.internal.DefaultTwirlSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.ScalaSourceCode;
import org.gradle.play.internal.platform.PlayPlatformInternal;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.play.tasks.TwirlCompile;
import org.gradle.util.CollectionUtils;

@Incubating
@Deprecated
public class PlayTwirlPlugin
extends RuleSource {
    @ComponentType
    void registerTwirlLanguageType(TypeBuilder<TwirlSourceSet> builder) {
        DeprecationLogger.deprecatePlugin((String)"Play Twirl").replaceWithExternalPlugin("org.gradle.playframework-twirl").willBeRemovedInGradle7().withUserManual("play_plugin").nagUser();
        builder.defaultImplementation(DefaultTwirlSourceSet.class);
    }

    @Mutate
    void createGeneratedScalaSourceSets(@Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> binaries, final ObjectFactory objectFactory) {
        binaries.all((Action)new Action<PlayApplicationBinarySpecInternal>(){

            public void execute(PlayApplicationBinarySpecInternal playApplicationBinarySpec) {
                for (LanguageSourceSet languageSourceSet : playApplicationBinarySpec.getInputs().withType(TwirlSourceSet.class)) {
                    playApplicationBinarySpec.addGeneratedScala(languageSourceSet, objectFactory);
                }
            }
        });
    }

    @Mutate
    void addPlayJavaDependencyIfNeeded(@Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> binaries, final PlayPluginConfigurations configurations, PlatformResolvers platforms) {
        binaries.beforeEach((Action)new Action<PlayApplicationBinarySpecInternal>(){

            public void execute(PlayApplicationBinarySpecInternal binary) {
                if (PlayTwirlPlugin.hasTwirlSourceSetsWithJavaImports(binary.getApplication())) {
                    PlayPlatform targetPlatform = binary.getTargetPlatform();
                    configurations.getPlay().addDependency(((PlayPlatformInternal)targetPlatform).getDependencyNotation("play-java"));
                }
            }
        });
    }

    @Mutate
    void registerLanguageTransform(LanguageTransformContainer languages) {
        languages.add((Object)new Twirl());
    }

    private static boolean hasTwirlSourceSetsWithJavaImports(PlayApplicationSpec playApplicationSpec) {
        return CollectionUtils.any((Iterable)playApplicationSpec.getSources().withType(TwirlSourceSet.class).values(), (Spec)new Spec<TwirlSourceSet>(){

            public boolean isSatisfiedBy(TwirlSourceSet twirlSourceSet) {
                return twirlSourceSet.getDefaultImports() == TwirlImports.JAVA;
            }
        });
    }

    private static class Twirl
    implements LanguageTransform<TwirlSourceSet, ScalaSourceCode> {
        private Twirl() {
        }

        public String getLanguageName() {
            return "twirl";
        }

        public Class<TwirlSourceSet> getSourceSetType() {
            return TwirlSourceSet.class;
        }

        public Class<ScalaSourceCode> getOutputType() {
            return ScalaSourceCode.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return TwirlCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    PlayApplicationBinarySpecInternal binary = (PlayApplicationBinarySpecInternal)binarySpec;
                    TwirlSourceSet twirlSourceSet = (TwirlSourceSet)sourceSet;
                    TwirlCompile twirlCompile = (TwirlCompile)task;
                    ScalaLanguageSourceSet twirlScalaSources = binary.getGeneratedScala().get(twirlSourceSet);
                    File generatedSourceDir = binary.getNamingScheme().getOutputDirectory(task.getProject().getBuildDir(), "src");
                    File twirlCompileOutputDirectory = new File(generatedSourceDir, twirlScalaSources.getName());
                    twirlCompile.setDescription("Compiles Twirl templates for the '" + twirlSourceSet.getName() + "' source set.");
                    twirlCompile.setPlatform(binary.getTargetPlatform());
                    twirlCompile.setSource((FileTree)twirlSourceSet.getSource());
                    twirlCompile.setOutputDirectory(twirlCompileOutputDirectory);
                    twirlCompile.setDefaultImports(twirlSourceSet.getDefaultImports());
                    twirlCompile.setUserTemplateFormats(twirlSourceSet.getUserTemplateFormats());
                    twirlCompile.setAdditionalImports(twirlSourceSet.getAdditionalImports());
                    twirlScalaSources.getSource().srcDir((Object)twirlCompileOutputDirectory);
                    twirlScalaSources.builtBy(new Object[]{twirlCompile});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof PlayApplicationBinarySpecInternal;
        }
    }
}

