/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;

public class LocalComponentInAnotherBuildProvider
implements LocalComponentProvider {
    private final ProjectStateRegistry projectRegistry;
    private final IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder;
    private final LoadingCache<ProjectComponentIdentifier, LocalComponentMetadata> projectMetadata = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ProjectComponentIdentifier, LocalComponentMetadata>(){

        public LocalComponentMetadata load(ProjectComponentIdentifier projectIdentifier) {
            return LocalComponentInAnotherBuildProvider.this.getRegisteredProject(projectIdentifier);
        }
    });

    public LocalComponentInAnotherBuildProvider(ProjectStateRegistry projectRegistry, IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder) {
        this.projectRegistry = projectRegistry;
        this.dependencyMetadataBuilder = dependencyMetadataBuilder;
    }

    public LocalComponentMetadata getComponent(ProjectComponentIdentifier project) {
        try {
            return (LocalComponentMetadata)this.projectMetadata.get((Object)project);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    private LocalComponentMetadata getRegisteredProject(ProjectComponentIdentifier projectId) {
        ProjectState projectState = this.projectRegistry.stateFor(projectId);
        CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)projectState.getOwner();
        if (buildState instanceof IncludedBuildState) {
            ((IncludedBuildState)buildState).getConfiguredBuild();
        }
        return (LocalComponentMetadata)projectState.fromMutableState(p -> this.dependencyMetadataBuilder.build(buildState, projectId));
    }
}

