/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskActionFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.specs.Specs;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.reflect.Instantiator;

public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final Instantiator instantiator;
    private final TaskClassInfoStore taskClassInfoStore;
    private final ITaskFactory taskFactory;

    public AnnotationProcessingTaskFactory(Instantiator instantiator, TaskClassInfoStore taskClassInfoStore, ITaskFactory taskFactory) {
        this.instantiator = instantiator;
        this.taskClassInfoStore = taskClassInfoStore;
        this.taskFactory = taskFactory;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, InstantiationScheme instantiationScheme) {
        return new AnnotationProcessingTaskFactory(this.instantiator, this.taskClassInfoStore, this.taskFactory.createChild(project, instantiationScheme));
    }

    @Override
    public <S extends Task> S create(TaskIdentity<S> taskIdentity, @Nullable Object[] constructorArgs) {
        return this.process(this.taskFactory.create(taskIdentity, constructorArgs));
    }

    private <S extends Task> S process(S task) {
        TaskClassInfo taskClassInfo = this.taskClassInfoStore.getTaskClassInfo(task.getClass());
        for (TaskActionFactory actionFactory : taskClassInfo.getTaskActionFactories()) {
            ((TaskInternal)task).prependParallelSafeAction(actionFactory.create(this.instantiator));
        }
        if (taskClassInfo.isCacheable()) {
            task.getOutputs().cacheIf("Annotated with @CacheableTask", Specs.SATISFIES_ALL);
        }
        return task;
    }
}

