/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonHierarchicalFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonHierarchicalFileWatcherUpdater.class);
    private final Multiset<String> watchedRoots = HashMultiset.create();
    private final Map<String, ImmutableList<String>> watchedRootsForSnapshot = new HashMap<String, ImmutableList<String>>();
    private final FileWatcher fileWatcher;

    public NonHierarchicalFileWatcherUpdater(FileWatcher fileWatcher) {
        this.fileWatcher = fileWatcher;
    }

    @Override
    public void changed(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots) {
        HashMap<String, Integer> changedWatchedDirectories = new HashMap<String, Integer>();
        removedSnapshots.forEach(snapshot -> {
            ImmutableList<String> previousWatchedRoots = this.watchedRootsForSnapshot.remove(snapshot.getAbsolutePath());
            previousWatchedRoots.forEach(path -> NonHierarchicalFileWatcherUpdater.decrement(path, changedWatchedDirectories));
            snapshot.accept((FileSystemSnapshotVisitor)new OnlyVisitSubDirectories(path -> NonHierarchicalFileWatcherUpdater.decrement(path, changedWatchedDirectories)));
        });
        addedSnapshots.forEach(snapshot -> {
            ImmutableList directoriesToWatchForRoot = ImmutableList.copyOf((Collection)WatchRootUtil.getDirectoriesToWatch(snapshot).stream().map(Path::toString).collect(Collectors.toList()));
            this.watchedRootsForSnapshot.put(snapshot.getAbsolutePath(), (ImmutableList<String>)directoriesToWatchForRoot);
            directoriesToWatchForRoot.forEach(path -> NonHierarchicalFileWatcherUpdater.increment(path, changedWatchedDirectories));
            snapshot.accept((FileSystemSnapshotVisitor)new OnlyVisitSubDirectories(path -> NonHierarchicalFileWatcherUpdater.increment(path, changedWatchedDirectories)));
        });
        this.updateWatchedDirectories(changedWatchedDirectories);
    }

    @Override
    public void updateProjectRootDirectory(File projectRoot) {
    }

    private void updateWatchedDirectories(Map<String, Integer> changedWatchDirectories) {
        if (changedWatchDirectories.isEmpty()) {
            return;
        }
        HashSet watchRootsToRemove = new HashSet();
        HashSet watchRootsToAdd = new HashSet();
        changedWatchDirectories.forEach((absolutePath, value) -> {
            int contained;
            int count = value;
            if (count < 0) {
                int toRemove = -count;
                int contained2 = this.watchedRoots.remove(absolutePath, toRemove);
                if (contained2 <= toRemove) {
                    watchRootsToRemove.add(new File((String)absolutePath));
                }
            } else if (count > 0 && (contained = this.watchedRoots.add(absolutePath, count)) == 0) {
                watchRootsToAdd.add(new File((String)absolutePath));
            }
        });
        if (this.watchedRoots.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        LOGGER.info("Watching {} directories to track changes", (Object)this.watchedRoots.entrySet().size());
        try {
            if (!watchRootsToRemove.isEmpty()) {
                this.fileWatcher.stopWatching(watchRootsToRemove);
            }
            if (!watchRootsToAdd.isEmpty()) {
                this.fileWatcher.startWatching(watchRootsToAdd);
            }
        }
        catch (NativeException e) {
            if (e.getMessage().contains("Already watching path: ")) {
                throw new WatchingNotSupportedException("Unable to watch same file twice via different paths: " + e.getMessage(), e);
            }
            throw e;
        }
    }

    private static void decrement(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? -1 : value - 1);
    }

    private static void increment(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? 1 : value + 1);
    }

    private static class OnlyVisitSubDirectories
    implements FileSystemSnapshotVisitor {
        private final Consumer<String> subDirectoryConsumer;
        boolean root;

        public OnlyVisitSubDirectories(Consumer<String> subDirectoryConsumer) {
            this.subDirectoryConsumer = subDirectoryConsumer;
            this.root = true;
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            boolean directoryAccessedDirectly;
            boolean bl = directoryAccessedDirectly = directorySnapshot.getAccessType() == FileMetadata.AccessType.DIRECT;
            if (!this.root && directoryAccessedDirectly) {
                this.subDirectoryConsumer.accept(directorySnapshot.getAbsolutePath());
            }
            this.root = false;
            return directoryAccessedDirectly;
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
        }
    }
}

