/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.tree.events.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.PomModelAspect;
import org.jetbrains.kotlin.com.intellij.pom.event.PomChangeSet;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private final Map<CompositeElement, TreeChangeImpl> myChangedElements;
    private final MultiMap<CompositeElement, TreeChangeImpl> myChangesByAllParents;
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileElement treeElement) {
        if (aspect == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(0);
        }
        if (treeElement == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(1);
        }
        this.myChangedElements = new LinkedHashMap<CompositeElement, TreeChangeImpl>();
        this.myChangesByAllParents = MultiMap.createSet();
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    public void addElementaryChange(@NotNull CompositeElement parent2) {
        TreeChangeImpl existing;
        if (parent2 == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(5);
        }
        if ((existing = this.myChangedElements.get(parent2)) != null) {
            existing.clearCache();
        } else if (!this.integrateIntoExistingChanges(parent2)) {
            this.mergeChange(new TreeChangeImpl(parent2));
        }
    }

    private boolean integrateIntoExistingChanges(CompositeElement nextParent) {
        for (CompositeElement eachParent : JBIterable.generate(nextParent, TreeElement::getTreeParent)) {
            CompositeElement superParent = eachParent.getTreeParent();
            TreeChangeImpl superChange = this.myChangedElements.get(superParent);
            if (superChange == null) continue;
            superChange.markChildChanged(eachParent, 0);
            return true;
        }
        return false;
    }

    private void mergeChange(TreeChangeImpl nextChange) {
        CompositeElement newParent = nextChange.getChangedParent();
        for (TreeChangeImpl descendant : new ArrayList<TreeChangeImpl>(this.myChangesByAllParents.get(newParent))) {
            TreeElement ancestorChild = TreeChangeEventImpl.findAncestorChild(newParent, descendant);
            if (ancestorChild != null) {
                nextChange.markChildChanged(ancestorChild, descendant.getLengthDelta());
            }
            this.unregisterChange(descendant);
        }
        this.registerChange(nextChange);
    }

    private void registerChange(TreeChangeImpl nextChange) {
        this.myChangedElements.put(nextChange.getChangedParent(), nextChange);
        for (CompositeElement eachParent : nextChange.getSuperParents()) {
            this.myChangesByAllParents.putValue(eachParent, nextChange);
        }
    }

    private void unregisterChange(TreeChangeImpl change) {
        this.myChangedElements.remove(change.getChangedParent());
        for (CompositeElement superParent : change.getSuperParents()) {
            this.myChangesByAllParents.remove(superParent, change);
        }
    }

    @Nullable
    private static TreeElement findAncestorChild(@NotNull CompositeElement ancestor, @NotNull TreeChangeImpl change) {
        List<CompositeElement> superParents;
        int index2;
        if (ancestor == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(6);
        }
        if (change == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(7);
        }
        return (index2 = (superParents = change.getSuperParents()).indexOf(ancestor)) < 0 ? null : (index2 == 0 ? change.getChangedParent() : (TreeElement)superParents.get(index2 - 1));
    }

    @Override
    public void merge(@NotNull PomChangeSet next) {
        if (next == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(9);
        }
        for (TreeChangeImpl change : ((TreeChangeEventImpl)next).myChangedElements.values()) {
            TreeChangeImpl existing = this.myChangedElements.get(change.getChangedParent());
            if (existing != null) {
                existing.appendChanges(change);
                continue;
            }
            if (this.integrateIntoExistingChanges(change.getChangedParent())) continue;
            this.mergeChange(change);
        }
    }

    public String toString() {
        return new ArrayList<TreeChangeImpl>(this.myChangedElements.values()).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangesByElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addElementaryChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

